/*
 * Decompiled with CFR 0.152.
 */
package master.flame.danmaku.danmaku.renderer.android;

import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.DanmakuTimer;
import master.flame.danmaku.danmaku.model.ICacheManager;
import master.flame.danmaku.danmaku.model.IDanmakus;
import master.flame.danmaku.danmaku.model.IDisplayer;
import master.flame.danmaku.danmaku.model.IDrawingCache;
import master.flame.danmaku.danmaku.model.android.DanmakuContext;
import master.flame.danmaku.danmaku.renderer.IRenderer;
import master.flame.danmaku.danmaku.renderer.Renderer;
import master.flame.danmaku.danmaku.renderer.android.DanmakusRetainer;

public class DanmakuRenderer
extends Renderer {
    private DanmakuTimer mStartTimer;
    private final DanmakuContext mContext;
    private DanmakusRetainer.Verifier mVerifier;
    private final DanmakusRetainer.Verifier verifier = new DanmakusRetainer.Verifier(){

        @Override
        public boolean skipLayout(BaseDanmaku danmaku, float fixedTop, int lines, boolean willHit) {
            if (danmaku.priority == 0 && ((DanmakuRenderer)DanmakuRenderer.this).mContext.mDanmakuFilters.filterSecondary(danmaku, lines, 0, DanmakuRenderer.this.mStartTimer, willHit, DanmakuRenderer.this.mContext)) {
                danmaku.setVisibility(false);
                return true;
            }
            return false;
        }
    };
    private final DanmakusRetainer mDanmakusRetainer;
    private ICacheManager mCacheManager;
    private IRenderer.OnDanmakuShownListener mOnDanmakuShownListener;
    private Consumer mConsumer = new Consumer();

    public DanmakuRenderer(DanmakuContext config) {
        this.mContext = config;
        this.mDanmakusRetainer = new DanmakusRetainer(config.isAlignBottom());
    }

    @Override
    public void clear() {
        this.clearRetainer();
        this.mContext.mDanmakuFilters.clear();
    }

    @Override
    public void clearRetainer() {
        this.mDanmakusRetainer.clear();
    }

    @Override
    public void release() {
        this.mDanmakusRetainer.release();
        this.mContext.mDanmakuFilters.clear();
    }

    @Override
    public void setVerifierEnabled(boolean enabled) {
        this.mVerifier = enabled ? this.verifier : null;
    }

    @Override
    public void draw(IDisplayer disp, IDanmakus danmakus, long startRenderTime, IRenderer.RenderingState renderingState) {
        this.mStartTimer = renderingState.timer;
        this.mConsumer.disp = disp;
        this.mConsumer.renderingState = renderingState;
        this.mConsumer.startRenderTime = startRenderTime;
        danmakus.forEachSync(this.mConsumer);
    }

    @Override
    public void setCacheManager(ICacheManager cacheManager) {
        this.mCacheManager = cacheManager;
    }

    @Override
    public void setOnDanmakuShownListener(IRenderer.OnDanmakuShownListener onDanmakuShownListener) {
        this.mOnDanmakuShownListener = onDanmakuShownListener;
    }

    @Override
    public void removeOnDanmakuShownListener() {
        this.mOnDanmakuShownListener = null;
    }

    @Override
    public void alignBottom(boolean enable) {
        if (this.mDanmakusRetainer != null) {
            this.mDanmakusRetainer.alignBottom(enable);
        }
    }

    private class Consumer
    extends IDanmakus.DefaultConsumer<BaseDanmaku> {
        private BaseDanmaku lastItem;
        public IDisplayer disp;
        public IRenderer.RenderingState renderingState;
        public long startRenderTime;

        private Consumer() {
        }

        @Override
        public int accept(BaseDanmaku drawItem) {
            this.lastItem = drawItem;
            if (drawItem.isTimeOut()) {
                this.disp.recycle(drawItem);
                return this.renderingState.isRunningDanmakus ? 2 : 0;
            }
            if (!this.renderingState.isRunningDanmakus && drawItem.isOffset()) {
                return 0;
            }
            if (!drawItem.hasPassedFilter()) {
                ((DanmakuRenderer)DanmakuRenderer.this).mContext.mDanmakuFilters.filter(drawItem, this.renderingState.indexInScreen, this.renderingState.totalSizeInScreen, this.renderingState.timer, false, DanmakuRenderer.this.mContext);
            }
            if (drawItem.getActualTime() < this.startRenderTime || drawItem.priority == 0 && drawItem.isFiltered()) {
                return 0;
            }
            if (drawItem.isLate()) {
                IDrawingCache<?> cache = drawItem.getDrawingCache();
                if (DanmakuRenderer.this.mCacheManager != null && (cache == null || cache.get() == null)) {
                    DanmakuRenderer.this.mCacheManager.addDanmaku(drawItem);
                }
                return 1;
            }
            if (drawItem.getType() == 1) {
                ++this.renderingState.indexInScreen;
            }
            if (!drawItem.isMeasured()) {
                drawItem.measure(this.disp, false);
            }
            if (!drawItem.isPrepared()) {
                drawItem.prepare(this.disp, false);
            }
            DanmakuRenderer.this.mDanmakusRetainer.fix(drawItem, this.disp, DanmakuRenderer.this.mVerifier);
            if (drawItem.isShown()) {
                if (drawItem.lines == null && drawItem.getBottom() > (float)this.disp.getHeight()) {
                    return 0;
                }
                int renderingType = drawItem.draw(this.disp);
                if (renderingType == 1) {
                    ++this.renderingState.cacheHitCount;
                } else if (renderingType == 2) {
                    ++this.renderingState.cacheMissCount;
                    if (DanmakuRenderer.this.mCacheManager != null) {
                        DanmakuRenderer.this.mCacheManager.addDanmaku(drawItem);
                    }
                }
                this.renderingState.addCount(drawItem.getType(), 1);
                this.renderingState.addTotalCount(1);
                this.renderingState.appendToRunningDanmakus(drawItem);
                if (DanmakuRenderer.this.mOnDanmakuShownListener != null && drawItem.firstShownFlag != ((DanmakuRenderer)DanmakuRenderer.this).mContext.mGlobalFlagValues.FIRST_SHOWN_RESET_FLAG) {
                    drawItem.firstShownFlag = ((DanmakuRenderer)DanmakuRenderer.this).mContext.mGlobalFlagValues.FIRST_SHOWN_RESET_FLAG;
                    DanmakuRenderer.this.mOnDanmakuShownListener.onDanmakuShown(drawItem);
                }
            }
            return 0;
        }

        @Override
        public void after() {
            this.renderingState.lastDanmaku = this.lastItem;
            super.after();
        }
    }
}

