/*
 * Decompiled with CFR 0.152.
 */
package master.flame.danmaku.danmaku.parser;

import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.DanmakuTimer;
import master.flame.danmaku.danmaku.model.IDanmakus;
import master.flame.danmaku.danmaku.model.IDisplayer;
import master.flame.danmaku.danmaku.model.android.DanmakuContext;
import master.flame.danmaku.danmaku.parser.IDataSource;

public abstract class BaseDanmakuParser {
    protected IDataSource<?> mDataSource;
    protected DanmakuTimer mTimer;
    protected int mDispWidth;
    protected int mDispHeight;
    protected float mDispDensity;
    protected float mScaledDensity;
    private IDanmakus mDanmakus;
    protected IDisplayer mDisp;
    protected DanmakuContext mContext;
    protected Listener mListener;

    public BaseDanmakuParser setDisplayer(IDisplayer disp) {
        this.mDisp = disp;
        this.mDispWidth = disp.getWidth();
        this.mDispHeight = disp.getHeight();
        this.mDispDensity = disp.getDensity();
        this.mScaledDensity = disp.getScaledDensity();
        this.mContext.mDanmakuFactory.updateViewportState(this.mDispWidth, this.mDispHeight, this.getViewportSizeFactor());
        this.mContext.mDanmakuFactory.updateMaxDanmakuDuration();
        return this;
    }

    public IDisplayer getDisplayer() {
        return this.mDisp;
    }

    public BaseDanmakuParser setListener(Listener listener) {
        this.mListener = listener;
        return this;
    }

    protected float getViewportSizeFactor() {
        return 1.0f / (this.mDispDensity - 0.6f);
    }

    public BaseDanmakuParser load(IDataSource<?> source) {
        this.mDataSource = source;
        return this;
    }

    public BaseDanmakuParser setTimer(DanmakuTimer timer) {
        this.mTimer = timer;
        return this;
    }

    public DanmakuTimer getTimer() {
        return this.mTimer;
    }

    public IDanmakus getDanmakus() {
        if (this.mDanmakus != null) {
            return this.mDanmakus;
        }
        this.mContext.mDanmakuFactory.resetDurationsData();
        this.mDanmakus = this.parse();
        this.releaseDataSource();
        this.mContext.mDanmakuFactory.updateMaxDanmakuDuration();
        return this.mDanmakus;
    }

    protected void releaseDataSource() {
        if (this.mDataSource != null) {
            this.mDataSource.release();
        }
        this.mDataSource = null;
    }

    protected abstract IDanmakus parse();

    public void release() {
        this.releaseDataSource();
    }

    public BaseDanmakuParser setConfig(DanmakuContext config) {
        this.mContext = config;
        return this;
    }

    public static interface Listener {
        public void onDanmakuAdd(BaseDanmaku var1);
    }
}

