/*
 * Decompiled with CFR 0.152.
 */
package master.flame.danmaku.danmaku.model.android;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextPaint;
import java.util.HashMap;
import java.util.Map;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.SpecialDanmaku;
import master.flame.danmaku.danmaku.model.android.AndroidDisplayer;
import master.flame.danmaku.danmaku.model.android.BaseCacheStuffer;

public class SimpleTextCacheStuffer
extends BaseCacheStuffer {
    private static final Map<Float, Float> sTextHeightCache = new HashMap<Float, Float>();

    protected Float getCacheHeight(BaseDanmaku danmaku, Paint paint) {
        Float textSize = Float.valueOf(paint.getTextSize());
        Float textHeight = sTextHeightCache.get(textSize);
        if (textHeight == null) {
            Paint.FontMetrics fontMetrics = paint.getFontMetrics();
            textHeight = Float.valueOf(fontMetrics.descent - fontMetrics.ascent + fontMetrics.leading);
            sTextHeightCache.put(textSize, textHeight);
        }
        return textHeight;
    }

    @Override
    public void measure(BaseDanmaku danmaku, TextPaint paint, boolean fromWorkerThread) {
        float w = 0.0f;
        Float textHeight = Float.valueOf(0.0f);
        if (danmaku.lines == null) {
            if (danmaku.text == null) {
                w = 0.0f;
            } else {
                w = paint.measureText(danmaku.text.toString());
                textHeight = this.getCacheHeight(danmaku, (Paint)paint);
            }
            danmaku.paintWidth = w;
            danmaku.paintHeight = textHeight.floatValue();
        } else {
            textHeight = this.getCacheHeight(danmaku, (Paint)paint);
            for (String tempStr : danmaku.lines) {
                if (tempStr.length() <= 0) continue;
                float tr = paint.measureText(tempStr);
                w = Math.max(tr, w);
            }
            danmaku.paintWidth = w;
            danmaku.paintHeight = (float)danmaku.lines.length * textHeight.floatValue();
        }
    }

    protected void drawStroke(BaseDanmaku danmaku, String lineText, Canvas canvas, float left, float top, Paint paint) {
        if (lineText != null) {
            canvas.drawText(lineText, left, top, paint);
        } else {
            canvas.drawText(danmaku.text.toString(), left, top, paint);
        }
    }

    protected void drawText(BaseDanmaku danmaku, String lineText, Canvas canvas, float left, float top, TextPaint paint, boolean fromWorkerThread) {
        if (fromWorkerThread && danmaku instanceof SpecialDanmaku) {
            paint.setAlpha(255);
        }
        if (lineText != null) {
            canvas.drawText(lineText, left, top, (Paint)paint);
        } else {
            canvas.drawText(danmaku.text.toString(), left, top, (Paint)paint);
        }
    }

    @Override
    public void clearCaches() {
        sTextHeightCache.clear();
    }

    protected void drawBackground(BaseDanmaku danmaku, Canvas canvas, float left, float top) {
    }

    @Override
    public void drawDanmaku(BaseDanmaku danmaku, Canvas canvas, float left, float top, boolean fromWorkerThread, AndroidDisplayer.DisplayerConfig displayerConfig) {
        float _left = left;
        float _top = top;
        left += (float)danmaku.padding;
        top += (float)danmaku.padding;
        if (danmaku.borderColor != 0) {
            left += 4.0f;
            top += 4.0f;
        }
        displayerConfig.definePaintParams(fromWorkerThread);
        TextPaint paint = displayerConfig.getPaint(danmaku, fromWorkerThread);
        this.drawBackground(danmaku, canvas, _left, _top);
        if (danmaku.lines != null) {
            String[] lines = danmaku.lines;
            if (lines.length == 1) {
                if (displayerConfig.hasStroke(danmaku)) {
                    displayerConfig.applyPaintConfig(danmaku, (Paint)paint, true);
                    float strokeLeft = left;
                    float strokeTop = top - paint.ascent();
                    if (displayerConfig.HAS_PROJECTION) {
                        strokeLeft += displayerConfig.sProjectionOffsetX;
                        strokeTop += displayerConfig.sProjectionOffsetY;
                    }
                    this.drawStroke(danmaku, lines[0], canvas, strokeLeft, strokeTop, (Paint)paint);
                }
                displayerConfig.applyPaintConfig(danmaku, (Paint)paint, false);
                this.drawText(danmaku, lines[0], canvas, left, top - paint.ascent(), paint, fromWorkerThread);
            } else {
                float textHeight = (danmaku.paintHeight - (float)(2 * danmaku.padding)) / (float)lines.length;
                for (int t = 0; t < lines.length; ++t) {
                    if (lines[t] == null || lines[t].length() == 0) continue;
                    if (displayerConfig.hasStroke(danmaku)) {
                        displayerConfig.applyPaintConfig(danmaku, (Paint)paint, true);
                        float strokeLeft = left;
                        float strokeTop = (float)t * textHeight + top - paint.ascent();
                        if (displayerConfig.HAS_PROJECTION) {
                            strokeLeft += displayerConfig.sProjectionOffsetX;
                            strokeTop += displayerConfig.sProjectionOffsetY;
                        }
                        this.drawStroke(danmaku, lines[t], canvas, strokeLeft, strokeTop, (Paint)paint);
                    }
                    displayerConfig.applyPaintConfig(danmaku, (Paint)paint, false);
                    this.drawText(danmaku, lines[t], canvas, left, (float)t * textHeight + top - paint.ascent(), paint, fromWorkerThread);
                }
            }
        } else {
            if (displayerConfig.hasStroke(danmaku)) {
                displayerConfig.applyPaintConfig(danmaku, (Paint)paint, true);
                float strokeLeft = left;
                float strokeTop = top - paint.ascent();
                if (displayerConfig.HAS_PROJECTION) {
                    strokeLeft += displayerConfig.sProjectionOffsetX;
                    strokeTop += displayerConfig.sProjectionOffsetY;
                }
                this.drawStroke(danmaku, null, canvas, strokeLeft, strokeTop, (Paint)paint);
            }
            displayerConfig.applyPaintConfig(danmaku, (Paint)paint, false);
            this.drawText(danmaku, null, canvas, left, top - paint.ascent(), paint, fromWorkerThread);
        }
        if (danmaku.underlineColor != 0) {
            Paint linePaint = displayerConfig.getUnderlinePaint(danmaku);
            float bottom = _top + danmaku.paintHeight - (float)displayerConfig.UNDERLINE_HEIGHT;
            canvas.drawLine(_left, bottom, _left + danmaku.paintWidth, bottom, linePaint);
        }
        if (danmaku.borderColor != 0) {
            Paint borderPaint = displayerConfig.getBorderPaint(danmaku);
            canvas.drawRect(_left, _top, _left + danmaku.paintWidth, _top + danmaku.paintHeight, borderPaint);
        }
    }
}

