/*
 * Decompiled with CFR 0.152.
 */
package master.flame.danmaku.danmaku.model.android;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.Danmaku;
import master.flame.danmaku.danmaku.model.IDanmakus;

public class Danmakus
implements IDanmakus {
    public Collection<BaseDanmaku> items;
    private Danmakus subItems;
    private BaseDanmaku startItem;
    private BaseDanmaku endItem;
    private BaseDanmaku endSubItem;
    private BaseDanmaku startSubItem;
    private volatile AtomicInteger mSize = new AtomicInteger(0);
    private int mSortType = 0;
    private IDanmakus.BaseComparator mComparator;
    private boolean mDuplicateMergingEnabled;
    private Object mLockObject = new Object();

    public Danmakus() {
        this(0, false);
    }

    public Danmakus(int sortType) {
        this(sortType, false);
    }

    public Danmakus(int sortType, boolean duplicateMergingEnabled) {
        this(sortType, duplicateMergingEnabled, null);
    }

    public Danmakus(int sortType, boolean duplicateMergingEnabled, IDanmakus.BaseComparator baseComparator) {
        IDanmakus.BaseComparator comparator = null;
        if (sortType == 0) {
            comparator = baseComparator == null ? new IDanmakus.TimeComparator(duplicateMergingEnabled) : baseComparator;
        } else if (sortType == 1) {
            comparator = new IDanmakus.YPosComparator(duplicateMergingEnabled);
        } else if (sortType == 2) {
            comparator = new IDanmakus.YPosDescComparator(duplicateMergingEnabled);
        }
        if (sortType == 4) {
            this.items = new LinkedList<BaseDanmaku>();
        } else {
            this.mDuplicateMergingEnabled = duplicateMergingEnabled;
            comparator.setDuplicateMergingEnabled(duplicateMergingEnabled);
            this.items = new TreeSet<BaseDanmaku>(comparator);
            this.mComparator = comparator;
        }
        this.mSortType = sortType;
        this.mSize.set(0);
    }

    public Danmakus(Collection<BaseDanmaku> items) {
        this.setItems(items);
    }

    public Danmakus(boolean duplicateMergingEnabled) {
        this(0, duplicateMergingEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setItems(Collection<BaseDanmaku> items) {
        if (this.mDuplicateMergingEnabled && this.mSortType != 4) {
            Object object = this.mLockObject;
            synchronized (object) {
                this.items.clear();
                this.items.addAll(items);
                items = this.items;
            }
        } else {
            this.items = items;
        }
        if (items instanceof List) {
            this.mSortType = 4;
        }
        this.mSize.set(items == null ? 0 : items.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addItem(BaseDanmaku item) {
        Object object = this.mLockObject;
        synchronized (object) {
            if (this.items != null) {
                try {
                    if (this.items.add(item)) {
                        this.mSize.incrementAndGet();
                        return true;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeItem(BaseDanmaku item) {
        if (item == null) {
            return false;
        }
        if (item.isOutside()) {
            item.setVisibility(false);
        }
        Object object = this.mLockObject;
        synchronized (object) {
            if (this.items.remove(item)) {
                this.mSize.decrementAndGet();
                return true;
            }
        }
        return false;
    }

    private Collection<BaseDanmaku> subset(long startTime, long endTime) {
        if (this.mSortType == 4 || this.items == null || this.items.size() == 0) {
            return null;
        }
        if (this.subItems == null) {
            this.subItems = new Danmakus(this.mDuplicateMergingEnabled);
            this.subItems.mLockObject = this.mLockObject;
        }
        if (this.startSubItem == null) {
            this.startSubItem = this.createItem("start");
        }
        if (this.endSubItem == null) {
            this.endSubItem = this.createItem("end");
        }
        this.startSubItem.setTime(startTime);
        this.endSubItem.setTime(endTime);
        return ((SortedSet)this.items).subSet(this.startSubItem, this.endSubItem);
    }

    @Override
    public IDanmakus subnew(long startTime, long endTime) {
        Collection<BaseDanmaku> subset = this.subset(startTime, endTime);
        if (subset == null || subset.isEmpty()) {
            return null;
        }
        LinkedList<BaseDanmaku> newSet = new LinkedList<BaseDanmaku>(subset);
        return new Danmakus(newSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDanmakus sub(long startTime, long endTime) {
        long dtime;
        if (this.items == null || this.items.size() == 0) {
            return null;
        }
        if (this.subItems == null) {
            if (this.mSortType == 4) {
                this.subItems = new Danmakus(4);
                this.subItems.mLockObject = this.mLockObject;
                Object object = this.mLockObject;
                synchronized (object) {
                    this.subItems.setItems(this.items);
                }
            } else {
                this.subItems = new Danmakus(this.mDuplicateMergingEnabled);
                this.subItems.mLockObject = this.mLockObject;
            }
        }
        if (this.mSortType == 4) {
            return this.subItems;
        }
        if (this.startItem == null) {
            this.startItem = this.createItem("start");
        }
        if (this.endItem == null) {
            this.endItem = this.createItem("end");
        }
        if (this.subItems != null && (dtime = startTime - this.startItem.getActualTime()) >= 0L && endTime <= this.endItem.getActualTime()) {
            return this.subItems;
        }
        this.startItem.setTime(startTime);
        this.endItem.setTime(endTime);
        Object object = this.mLockObject;
        synchronized (object) {
            this.subItems.setItems(((SortedSet)this.items).subSet(this.startItem, this.endItem));
        }
        return this.subItems;
    }

    private BaseDanmaku createItem(String text) {
        return new Danmaku(text);
    }

    @Override
    public int size() {
        return this.mSize.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.mLockObject;
        synchronized (object) {
            if (this.items != null) {
                this.items.clear();
                this.mSize.set(0);
            }
        }
        if (this.subItems != null) {
            this.subItems = null;
            this.startItem = this.createItem("start");
            this.endItem = this.createItem("end");
        }
    }

    @Override
    public BaseDanmaku first() {
        if (this.items != null && !this.items.isEmpty()) {
            if (this.mSortType == 4) {
                return (BaseDanmaku)((LinkedList)this.items).peek();
            }
            return (BaseDanmaku)((SortedSet)this.items).first();
        }
        return null;
    }

    @Override
    public BaseDanmaku last() {
        if (this.items != null && !this.items.isEmpty()) {
            if (this.mSortType == 4) {
                return (BaseDanmaku)((LinkedList)this.items).peekLast();
            }
            return (BaseDanmaku)((SortedSet)this.items).last();
        }
        return null;
    }

    @Override
    public boolean contains(BaseDanmaku item) {
        return this.items != null && this.items.contains(item);
    }

    @Override
    public boolean isEmpty() {
        return this.items == null || this.items.isEmpty();
    }

    private void setDuplicateMergingEnabled(boolean enable) {
        this.mComparator.setDuplicateMergingEnabled(enable);
        this.mDuplicateMergingEnabled = enable;
    }

    @Override
    public void setSubItemsDuplicateMergingEnabled(boolean enable) {
        this.mDuplicateMergingEnabled = enable;
        this.endItem = null;
        this.startItem = null;
        if (this.subItems == null) {
            this.subItems = new Danmakus(enable);
            this.subItems.mLockObject = this.mLockObject;
        }
        this.subItems.setDuplicateMergingEnabled(enable);
    }

    @Override
    public Collection<BaseDanmaku> getCollection() {
        return this.items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachSync(IDanmakus.Consumer<? super BaseDanmaku, ?> consumer) {
        Object object = this.mLockObject;
        synchronized (object) {
            this.forEach(consumer);
        }
    }

    @Override
    public void forEach(IDanmakus.Consumer<? super BaseDanmaku, ?> consumer) {
        consumer.before();
        Iterator<BaseDanmaku> it = this.items.iterator();
        while (it.hasNext()) {
            BaseDanmaku next = it.next();
            if (next == null) continue;
            int action = consumer.accept(next);
            if (action == 1) break;
            if (action == 2) {
                it.remove();
                this.mSize.decrementAndGet();
                continue;
            }
            if (action != 3) continue;
            it.remove();
            this.mSize.decrementAndGet();
            break;
        }
        consumer.after();
    }

    @Override
    public Object obtainSynchronizer() {
        return this.mLockObject;
    }
}

