/*
 * Decompiled with CFR 0.152.
 */
package master.flame.danmaku.danmaku.model;

import master.flame.danmaku.danmaku.model.AlphaValue;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.IDisplayer;

public class SpecialDanmaku
extends BaseDanmaku {
    public float beginX;
    public float beginY;
    public float endX;
    public float endY;
    public float deltaX;
    public float deltaY;
    public long translationDuration;
    public long translationStartDelay;
    private ScaleFactor mScaleFactor;
    private int mScaleFactorChangedFlag;
    private int mCurrentWidth = 0;
    private int mCurrentHeight = 0;
    public boolean isQuadraticEaseOut = false;
    public int beginAlpha;
    public int endAlpha;
    public int deltaAlpha;
    public long alphaDuration;
    public float rotateX;
    public float rotateZ;
    public float pivotX;
    public float pivotY;
    private float[] currStateValues = new float[4];
    public LinePath[] linePaths;

    @Override
    public void measure(IDisplayer displayer, boolean fromWorkerThread) {
        super.measure(displayer, fromWorkerThread);
        if (this.mCurrentWidth == 0 || this.mCurrentHeight == 0) {
            this.mCurrentWidth = displayer.getWidth();
            this.mCurrentHeight = displayer.getHeight();
        }
    }

    @Override
    public void layout(IDisplayer displayer, float x, float y) {
        this.getRectAtTime(displayer, this.mTimer.currMillisecond);
    }

    @Override
    public float[] getRectAtTime(IDisplayer displayer, long currTime) {
        if (!this.isMeasured()) {
            return null;
        }
        if (this.mScaleFactor.isUpdated(this.mScaleFactorChangedFlag, this.mCurrentWidth, this.mCurrentHeight)) {
            float scaleX = this.mScaleFactor.scaleX;
            float scaleY = this.mScaleFactor.scaleY;
            this.setTranslationData(this.beginX * scaleX, this.beginY * scaleY, this.endX * scaleX, this.endY * scaleY, this.translationDuration, this.translationStartDelay);
            if (this.linePaths != null && this.linePaths.length > 0) {
                int length = this.linePaths.length;
                float[][] points = new float[length + 1][2];
                for (int j = 0; j < length; ++j) {
                    points[j] = this.linePaths[j].getBeginPoint();
                    points[j + 1] = this.linePaths[j].getEndPoint();
                }
                for (int i = 0; i < points.length; ++i) {
                    float[] fArray = points[i];
                    fArray[0] = fArray[0] * scaleX;
                    float[] fArray2 = points[i];
                    fArray2[1] = fArray2[1] * scaleY;
                }
                this.setLinePathData(points);
            }
            this.mScaleFactorChangedFlag = this.mScaleFactor.flag;
            this.mCurrentWidth = this.mScaleFactor.width;
            this.mCurrentHeight = this.mScaleFactor.height;
        }
        long deltaTime = currTime - this.getActualTime();
        if (this.alphaDuration > 0L && this.deltaAlpha != 0) {
            if (deltaTime >= this.alphaDuration) {
                this.alpha = this.endAlpha;
            } else {
                float alphaProgress = (float)deltaTime / (float)this.alphaDuration;
                int vectorAlpha = (int)((float)this.deltaAlpha * alphaProgress);
                this.alpha = this.beginAlpha + vectorAlpha;
            }
        }
        float currX = this.beginX;
        float currY = this.beginY;
        long dtime = deltaTime - this.translationStartDelay;
        if (this.translationDuration > 0L && dtime >= 0L && dtime <= this.translationDuration) {
            float tranalationProgress = 0.0f;
            if (this.linePaths != null) {
                LinePath currentLinePath = null;
                for (LinePath line : this.linePaths) {
                    if (dtime >= line.beginTime && dtime < line.endTime) {
                        currentLinePath = line;
                        break;
                    }
                    currX = line.pEnd.x;
                    currY = line.pEnd.y;
                }
                if (currentLinePath != null) {
                    float deltaX = currentLinePath.delatX;
                    float deltaY = currentLinePath.deltaY;
                    tranalationProgress = (float)(deltaTime - currentLinePath.beginTime) / (float)currentLinePath.duration;
                    float beginX = currentLinePath.pBegin.x;
                    float beginY = currentLinePath.pBegin.y;
                    if (deltaX != 0.0f) {
                        float vectorX = deltaX * tranalationProgress;
                        currX = beginX + vectorX;
                    }
                    if (deltaY != 0.0f) {
                        float vectorY = deltaY * tranalationProgress;
                        currY = beginY + vectorY;
                    }
                }
            } else {
                float f = tranalationProgress = this.isQuadraticEaseOut ? SpecialDanmaku.getQuadEaseOutProgress(dtime, this.translationDuration) : (float)dtime / (float)this.translationDuration;
                if (this.deltaX != 0.0f) {
                    float vectorX = this.deltaX * tranalationProgress;
                    currX = this.beginX + vectorX;
                }
                if (this.deltaY != 0.0f) {
                    float vectorY = this.deltaY * tranalationProgress;
                    currY = this.beginY + vectorY;
                }
            }
        } else if (dtime > this.translationDuration) {
            currX = this.endX;
            currY = this.endY;
        }
        this.currStateValues[0] = currX;
        this.currStateValues[1] = currY;
        this.currStateValues[2] = currX + this.paintWidth;
        this.currStateValues[3] = currY + this.paintHeight;
        this.setVisibility(!this.isOutside());
        return this.currStateValues;
    }

    private static final float getQuadEaseOutProgress(long ctime, long duration) {
        float t = ctime;
        float c = 1.0f;
        float d = duration;
        return -c * (t /= d) * (t - 2.0f);
    }

    @Override
    public float getLeft() {
        return this.currStateValues[0];
    }

    @Override
    public float getTop() {
        return this.currStateValues[1];
    }

    @Override
    public float getRight() {
        return this.currStateValues[2];
    }

    @Override
    public float getBottom() {
        return this.currStateValues[3];
    }

    @Override
    public int getType() {
        return 7;
    }

    public void setTranslationData(float beginX, float beginY, float endX, float endY, long translationDuration, long translationStartDelay) {
        this.beginX = beginX;
        this.beginY = beginY;
        this.endX = endX;
        this.endY = endY;
        this.deltaX = endX - beginX;
        this.deltaY = endY - beginY;
        this.translationDuration = translationDuration;
        this.translationStartDelay = translationStartDelay;
    }

    public void setAlphaData(int beginAlpha, int endAlpha, long alphaDuration) {
        this.beginAlpha = beginAlpha;
        this.endAlpha = endAlpha;
        this.deltaAlpha = endAlpha - beginAlpha;
        this.alphaDuration = alphaDuration;
        if (beginAlpha != AlphaValue.MAX) {
            this.alpha = beginAlpha;
        }
    }

    public void setLinePathData(float[][] points) {
        if (points != null) {
            int length = points.length;
            this.beginX = points[0][0];
            this.beginY = points[0][1];
            this.endX = points[length - 1][0];
            this.endY = points[length - 1][1];
            if (points.length > 1) {
                this.linePaths = new LinePath[points.length - 1];
                for (int i = 0; i < this.linePaths.length; ++i) {
                    this.linePaths[i] = new LinePath();
                    this.linePaths[i].setPoints(new Point(points[i][0], points[i][1]), new Point(points[i + 1][0], points[i + 1][1]));
                }
                float totalDistance = 0.0f;
                for (LinePath line : this.linePaths) {
                    totalDistance += line.getDistance();
                }
                LinePath lastLine = null;
                for (LinePath line : this.linePaths) {
                    line.duration = (long)(line.getDistance() / totalDistance * (float)this.translationDuration);
                    line.beginTime = lastLine == null ? 0L : lastLine.endTime;
                    line.endTime = line.beginTime + line.duration;
                    lastLine = line;
                }
            }
        }
    }

    public void setScaleFactor(ScaleFactor scaleFactor) {
        this.mScaleFactor = scaleFactor;
        this.mScaleFactorChangedFlag = scaleFactor.flag;
    }

    public class LinePath {
        Point pBegin;
        Point pEnd;
        public long duration;
        public long beginTime;
        public long endTime;
        float delatX;
        float deltaY;

        public void setPoints(Point pBegin, Point pEnd) {
            this.pBegin = pBegin;
            this.pEnd = pEnd;
            this.delatX = pEnd.x - pBegin.x;
            this.deltaY = pEnd.y - pBegin.y;
        }

        public float getDistance() {
            return this.pEnd.getDistance(this.pBegin);
        }

        public float[] getBeginPoint() {
            return new float[]{this.pBegin.x, this.pBegin.y};
        }

        public float[] getEndPoint() {
            return new float[]{this.pEnd.x, this.pEnd.y};
        }
    }

    private class Point {
        float x;
        float y;

        public Point(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public float getDistance(Point p) {
            float _x = Math.abs(this.x - p.x);
            float _y = Math.abs(this.y - p.y);
            return (float)Math.sqrt(_x * _x + _y * _y);
        }
    }

    public static class ScaleFactor {
        int flag = 0;
        float scaleX;
        float scaleY;
        int width;
        int height;

        public ScaleFactor(int width, int height, float scaleX, float scaleY) {
            this.update(width, height, scaleX, scaleY);
        }

        public void update(int width, int height, float scaleX, float scaleY) {
            if (Float.compare(this.scaleX, scaleX) != 0 || Float.compare(this.scaleY, scaleY) != 0) {
                ++this.flag;
            }
            this.width = width;
            this.height = height;
            this.scaleX = scaleX;
            this.scaleY = scaleY;
        }

        public boolean isUpdated(int flag, int width, int height) {
            return this.flag != flag && (this.width != width || this.height != height);
        }
    }
}

