/*
 * Decompiled with CFR 0.152.
 */
package master.flame.danmaku.danmaku.model;

import java.util.Collection;
import java.util.Comparator;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.util.DanmakuUtils;

public interface IDanmakus {
    public static final int ST_BY_TIME = 0;
    public static final int ST_BY_YPOS = 1;
    public static final int ST_BY_YPOS_DESC = 2;
    public static final int ST_BY_LIST = 4;

    public boolean addItem(BaseDanmaku var1);

    public boolean removeItem(BaseDanmaku var1);

    public IDanmakus subnew(long var1, long var3);

    public IDanmakus sub(long var1, long var3);

    public int size();

    public void clear();

    public BaseDanmaku first();

    public BaseDanmaku last();

    public boolean contains(BaseDanmaku var1);

    public boolean isEmpty();

    public void setSubItemsDuplicateMergingEnabled(boolean var1);

    public Collection<BaseDanmaku> getCollection();

    public void forEachSync(Consumer<? super BaseDanmaku, ?> var1);

    public void forEach(Consumer<? super BaseDanmaku, ?> var1);

    public Object obtainSynchronizer();

    public static class YPosDescComparator
    extends BaseComparator {
        public YPosDescComparator(boolean duplicateMergingEnabled) {
            super(duplicateMergingEnabled);
        }

        @Override
        public int compare(BaseDanmaku obj1, BaseDanmaku obj2) {
            if (this.mDuplicateMergingEnable && DanmakuUtils.isDuplicate(obj1, obj2)) {
                return 0;
            }
            return Float.compare(obj2.getTop(), obj1.getTop());
        }
    }

    public static class YPosComparator
    extends BaseComparator {
        public YPosComparator(boolean duplicateMergingEnabled) {
            super(duplicateMergingEnabled);
        }

        @Override
        public int compare(BaseDanmaku obj1, BaseDanmaku obj2) {
            if (this.mDuplicateMergingEnable && DanmakuUtils.isDuplicate(obj1, obj2)) {
                return 0;
            }
            return Float.compare(obj1.getTop(), obj2.getTop());
        }
    }

    public static class TimeComparator
    extends BaseComparator {
        public TimeComparator(boolean duplicateMergingEnabled) {
            super(duplicateMergingEnabled);
        }

        @Override
        public int compare(BaseDanmaku obj1, BaseDanmaku obj2) {
            return super.compare(obj1, obj2);
        }
    }

    public static class BaseComparator
    implements Comparator<BaseDanmaku> {
        protected boolean mDuplicateMergingEnable;

        public BaseComparator(boolean duplicateMergingEnabled) {
            this.setDuplicateMergingEnabled(duplicateMergingEnabled);
        }

        public void setDuplicateMergingEnabled(boolean enable) {
            this.mDuplicateMergingEnable = enable;
        }

        @Override
        public int compare(BaseDanmaku obj1, BaseDanmaku obj2) {
            if (this.mDuplicateMergingEnable && DanmakuUtils.isDuplicate(obj1, obj2)) {
                return 0;
            }
            return DanmakuUtils.compare(obj1, obj2);
        }
    }

    public static abstract class DefaultConsumer<Progress>
    extends Consumer<Progress, Void> {
    }

    public static abstract class Consumer<Progress, Result> {
        public static final int ACTION_CONTINUE = 0;
        public static final int ACTION_BREAK = 1;
        public static final int ACTION_REMOVE = 2;
        public static final int ACTION_REMOVE_AND_BREAK = 3;

        public abstract int accept(Progress var1);

        public void before() {
        }

        public void after() {
        }

        public Result result() {
            return null;
        }
    }
}

