/*
 * Decompiled with CFR 0.152.
 */
package master.flame.danmaku.controller;

import android.graphics.Canvas;
import master.flame.danmaku.controller.DrawHelper;
import master.flame.danmaku.controller.IDrawTask;
import master.flame.danmaku.danmaku.model.AbsDisplayer;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.DanmakuTimer;
import master.flame.danmaku.danmaku.model.IDanmakus;
import master.flame.danmaku.danmaku.model.android.DanmakuContext;
import master.flame.danmaku.danmaku.model.android.Danmakus;
import master.flame.danmaku.danmaku.parser.BaseDanmakuParser;
import master.flame.danmaku.danmaku.renderer.IRenderer;
import master.flame.danmaku.danmaku.renderer.android.DanmakuRenderer;
import master.flame.danmaku.danmaku.util.SystemClock;

public class DrawTask
implements IDrawTask {
    protected final DanmakuContext mContext;
    protected final AbsDisplayer mDisp;
    protected IDanmakus danmakuList;
    protected BaseDanmakuParser mParser;
    IDrawTask.TaskListener mTaskListener;
    final IRenderer mRenderer;
    DanmakuTimer mTimer;
    private IDanmakus danmakus = new Danmakus(4);
    protected boolean clearRetainerFlag;
    private long mStartRenderTime = 0L;
    private final IRenderer.RenderingState mRenderingState = new IRenderer.RenderingState();
    protected boolean mReadyState;
    private long mLastBeginMills;
    private long mLastEndMills;
    protected int mPlayState;
    private boolean mIsHidden;
    private BaseDanmaku mLastDanmaku;
    private Danmakus mLiveDanmakus = new Danmakus(4);
    private IDanmakus mRunningDanmakus;
    private boolean mRequestRender;
    private DanmakuContext.ConfigChangedCallback mConfigChangedCallback = new DanmakuContext.ConfigChangedCallback(){

        @Override
        public boolean onDanmakuConfigChanged(DanmakuContext config, DanmakuContext.DanmakuConfigTag tag, Object ... values) {
            return DrawTask.this.onDanmakuConfigChanged(config, tag, values);
        }
    };

    public DrawTask(DanmakuTimer timer, DanmakuContext context, IDrawTask.TaskListener taskListener) {
        if (context == null) {
            throw new IllegalArgumentException("context is null");
        }
        this.mContext = context;
        this.mDisp = context.getDisplayer();
        this.mTaskListener = taskListener;
        this.mRenderer = new DanmakuRenderer(context);
        this.mRenderer.setOnDanmakuShownListener(new IRenderer.OnDanmakuShownListener(){

            @Override
            public void onDanmakuShown(BaseDanmaku danmaku) {
                if (DrawTask.this.mTaskListener != null) {
                    DrawTask.this.mTaskListener.onDanmakuShown(danmaku);
                }
            }
        });
        this.mRenderer.setVerifierEnabled(this.mContext.isPreventOverlappingEnabled() || this.mContext.isMaxLinesLimited());
        this.initTimer(timer);
        Boolean enable = this.mContext.isDuplicateMergingEnabled();
        if (enable != null) {
            if (enable.booleanValue()) {
                this.mContext.mDanmakuFilters.registerFilter("1017_Filter");
            } else {
                this.mContext.mDanmakuFilters.unregisterFilter("1017_Filter");
            }
        }
    }

    protected void initTimer(DanmakuTimer timer) {
        this.mTimer = timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addDanmaku(BaseDanmaku item) {
        if (this.danmakuList == null) {
            return;
        }
        if (item.isLive) {
            this.mLiveDanmakus.addItem(item);
            this.removeUnusedLiveDanmakusIn(10);
        }
        item.index = this.danmakuList.size();
        boolean subAdded = true;
        if (this.mLastBeginMills <= item.getActualTime() && item.getActualTime() <= this.mLastEndMills) {
            IDanmakus iDanmakus = this.danmakus;
            synchronized (iDanmakus) {
                subAdded = this.danmakus.addItem(item);
            }
        } else if (item.isLive) {
            subAdded = false;
        }
        boolean added = false;
        IDanmakus iDanmakus = this.danmakuList;
        synchronized (iDanmakus) {
            added = this.danmakuList.addItem(item);
        }
        if (!subAdded || !added) {
            this.mLastEndMills = 0L;
            this.mLastBeginMills = 0L;
        }
        if (added && this.mTaskListener != null) {
            this.mTaskListener.onDanmakuAdd(item);
        }
        if (this.mLastDanmaku == null || item != null && this.mLastDanmaku != null && item.getActualTime() > this.mLastDanmaku.getActualTime()) {
            this.mLastDanmaku = item;
        }
    }

    @Override
    public void invalidateDanmaku(BaseDanmaku item, boolean remeasure) {
        this.mContext.getDisplayer().getCacheStuffer().clearCache(item);
        item.requestFlags |= 2;
        if (remeasure) {
            item.paintWidth = -1.0f;
            item.paintHeight = -1.0f;
            item.requestFlags |= 1;
            ++item.measureResetFlag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeAllDanmakus(boolean isClearDanmakusOnScreen) {
        if (this.danmakuList == null || this.danmakuList.isEmpty()) {
            return;
        }
        IDanmakus iDanmakus = this.danmakuList;
        synchronized (iDanmakus) {
            long endMills;
            long beginMills;
            IDanmakus tempDanmakus;
            if (!isClearDanmakusOnScreen && (tempDanmakus = this.danmakuList.subnew(beginMills = this.mTimer.currMillisecond - this.mContext.mDanmakuFactory.MAX_DANMAKU_DURATION - 100L, endMills = this.mTimer.currMillisecond + this.mContext.mDanmakuFactory.MAX_DANMAKU_DURATION)) != null) {
                this.danmakus = tempDanmakus;
            }
            this.danmakuList.clear();
        }
    }

    protected void onDanmakuRemoved(BaseDanmaku danmaku) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeAllLiveDanmakus() {
        if (this.danmakus == null || this.danmakus.isEmpty()) {
            return;
        }
        IDanmakus iDanmakus = this.danmakus;
        synchronized (iDanmakus) {
            this.danmakus.forEachSync(new IDanmakus.DefaultConsumer<BaseDanmaku>(){

                @Override
                public int accept(BaseDanmaku danmaku) {
                    if (danmaku.isLive) {
                        DrawTask.this.onDanmakuRemoved(danmaku);
                        return 2;
                    }
                    return 0;
                }
            });
        }
    }

    protected synchronized void removeUnusedLiveDanmakusIn(final int msec) {
        if (this.danmakuList == null || this.danmakuList.isEmpty() || this.mLiveDanmakus.isEmpty()) {
            return;
        }
        this.mLiveDanmakus.forEachSync(new IDanmakus.DefaultConsumer<BaseDanmaku>(){
            long startTime = SystemClock.uptimeMillis();

            @Override
            public int accept(BaseDanmaku danmaku) {
                boolean isTimeout = danmaku.isTimeOut();
                if (SystemClock.uptimeMillis() - this.startTime > (long)msec) {
                    return 1;
                }
                if (isTimeout) {
                    DrawTask.this.danmakuList.removeItem(danmaku);
                    DrawTask.this.onDanmakuRemoved(danmaku);
                    return 2;
                }
                return 1;
            }
        });
    }

    @Override
    public IDanmakus getVisibleDanmakusOnTime(long time) {
        long beginMills = time - this.mContext.mDanmakuFactory.MAX_DANMAKU_DURATION - 100L;
        long endMills = time + this.mContext.mDanmakuFactory.MAX_DANMAKU_DURATION;
        IDanmakus subDanmakus = null;
        int i = 0;
        while (i++ < 3) {
            try {
                subDanmakus = this.danmakuList.subnew(beginMills, endMills);
                break;
            }
            catch (Exception e) {
            }
        }
        final Danmakus visibleDanmakus = new Danmakus();
        if (null != subDanmakus && !subDanmakus.isEmpty()) {
            subDanmakus.forEachSync(new IDanmakus.DefaultConsumer<BaseDanmaku>(){

                @Override
                public int accept(BaseDanmaku danmaku) {
                    if (danmaku.isShown() && !danmaku.isOutside()) {
                        visibleDanmakus.addItem(danmaku);
                    }
                    return 0;
                }
            });
        }
        return visibleDanmakus;
    }

    @Override
    public synchronized IRenderer.RenderingState draw(AbsDisplayer displayer) {
        return this.drawDanmakus(displayer, this.mTimer);
    }

    @Override
    public void reset() {
        if (this.danmakus != null) {
            this.danmakus = new Danmakus();
        }
        if (this.mRenderer != null) {
            this.mRenderer.clear();
        }
    }

    @Override
    public void seek(long mills) {
        BaseDanmaku last;
        this.reset();
        this.mContext.mGlobalFlagValues.updateVisibleFlag();
        this.mContext.mGlobalFlagValues.updateFirstShownFlag();
        this.mContext.mGlobalFlagValues.updateSyncOffsetTimeFlag();
        this.mContext.mGlobalFlagValues.updatePrepareFlag();
        this.mRunningDanmakus = new Danmakus(4);
        this.mStartRenderTime = mills < 1000L ? 0L : mills;
        this.mRenderingState.reset();
        this.mRenderingState.endTime = this.mStartRenderTime;
        this.mLastEndMills = 0L;
        this.mLastBeginMills = 0L;
        if (this.danmakuList != null && (last = this.danmakuList.last()) != null && !last.isTimeOut()) {
            this.mLastDanmaku = last;
        }
    }

    @Override
    public void clearDanmakusOnScreen(long currMillis) {
        this.reset();
        this.mContext.mGlobalFlagValues.updateVisibleFlag();
        this.mContext.mGlobalFlagValues.updateFirstShownFlag();
        this.mStartRenderTime = currMillis;
    }

    @Override
    public void start() {
        this.mContext.registerConfigChangedCallback(this.mConfigChangedCallback);
    }

    @Override
    public void quit() {
        this.mContext.unregisterAllConfigChangedCallbacks();
        if (this.mRenderer != null) {
            this.mRenderer.release();
        }
    }

    @Override
    public void prepare() {
        if (this.mParser == null) {
            return;
        }
        this.loadDanmakus(this.mParser);
        this.mLastEndMills = 0L;
        this.mLastBeginMills = 0L;
        if (this.mTaskListener != null) {
            this.mTaskListener.ready();
            this.mReadyState = true;
        }
    }

    @Override
    public void onPlayStateChanged(int state) {
        this.mPlayState = state;
    }

    protected void loadDanmakus(BaseDanmakuParser parser) {
        this.danmakuList = parser.setConfig(this.mContext).setDisplayer(this.mDisp).setTimer(this.mTimer).setListener(new BaseDanmakuParser.Listener(){

            @Override
            public void onDanmakuAdd(BaseDanmaku danmaku) {
                if (DrawTask.this.mTaskListener != null) {
                    DrawTask.this.mTaskListener.onDanmakuAdd(danmaku);
                }
            }
        }).getDanmakus();
        this.mContext.mGlobalFlagValues.resetAll();
        if (this.danmakuList != null) {
            this.mLastDanmaku = this.danmakuList.last();
        }
    }

    @Override
    public void setParser(BaseDanmakuParser parser) {
        this.mParser = parser;
        this.mReadyState = false;
    }

    protected IRenderer.RenderingState drawDanmakus(AbsDisplayer disp, DanmakuTimer timer) {
        if (this.clearRetainerFlag) {
            this.mRenderer.clearRetainer();
            this.clearRetainerFlag = false;
        }
        if (this.danmakuList != null) {
            Canvas canvas = (Canvas)disp.getExtraData();
            DrawHelper.clearCanvas(canvas);
            if (this.mIsHidden && !this.mRequestRender) {
                return this.mRenderingState;
            }
            this.mRequestRender = false;
            IRenderer.RenderingState renderingState = this.mRenderingState;
            long beginMills = timer.currMillisecond - this.mContext.mDanmakuFactory.MAX_DANMAKU_DURATION - 100L;
            long endMills = timer.currMillisecond + this.mContext.mDanmakuFactory.MAX_DANMAKU_DURATION;
            IDanmakus screenDanmakus = this.danmakus;
            if (this.mLastBeginMills > beginMills || timer.currMillisecond > this.mLastEndMills) {
                screenDanmakus = this.danmakuList.sub(beginMills, endMills);
                if (screenDanmakus != null) {
                    this.danmakus = screenDanmakus;
                }
                this.mLastBeginMills = beginMills;
                this.mLastEndMills = endMills;
            } else {
                beginMills = this.mLastBeginMills;
                endMills = this.mLastEndMills;
            }
            IDanmakus runningDanmakus = this.mRunningDanmakus;
            this.beginTracing(renderingState, runningDanmakus, screenDanmakus);
            if (runningDanmakus != null && !runningDanmakus.isEmpty()) {
                this.mRenderingState.isRunningDanmakus = true;
                this.mRenderer.draw(disp, runningDanmakus, 0L, this.mRenderingState);
            }
            this.mRenderingState.isRunningDanmakus = false;
            if (screenDanmakus != null && !screenDanmakus.isEmpty()) {
                this.mRenderer.draw(this.mDisp, screenDanmakus, this.mStartRenderTime, renderingState);
                this.endTracing(renderingState);
                if (renderingState.nothingRendered) {
                    if (this.mLastDanmaku != null && this.mLastDanmaku.isTimeOut()) {
                        this.mLastDanmaku = null;
                        if (this.mTaskListener != null) {
                            this.mTaskListener.onDanmakusDrawingFinished();
                        }
                    }
                    if (renderingState.beginTime == -1L) {
                        renderingState.beginTime = beginMills;
                    }
                    if (renderingState.endTime == -1L) {
                        renderingState.endTime = endMills;
                    }
                }
                return renderingState;
            }
            renderingState.nothingRendered = true;
            renderingState.beginTime = beginMills;
            renderingState.endTime = endMills;
            return renderingState;
        }
        return null;
    }

    @Override
    public void requestClear() {
        this.mLastEndMills = 0L;
        this.mLastBeginMills = 0L;
        this.mIsHidden = false;
    }

    @Override
    public void requestClearRetainer() {
        this.clearRetainerFlag = true;
    }

    @Override
    public void requestSync(long fromTimeMills, long toTimeMills, final long offsetMills) {
        IDanmakus runningDanmakus;
        this.mRunningDanmakus = runningDanmakus = this.mRenderingState.obtainRunningDanmakus();
        runningDanmakus.forEachSync(new IDanmakus.DefaultConsumer<BaseDanmaku>(){

            @Override
            public int accept(BaseDanmaku danmaku) {
                if (danmaku.isOutside()) {
                    return 2;
                }
                danmaku.setTimeOffset(offsetMills + danmaku.timeOffset);
                if (danmaku.timeOffset == 0L) {
                    return 2;
                }
                return 0;
            }
        });
        this.mStartRenderTime = toTimeMills;
    }

    public boolean onDanmakuConfigChanged(DanmakuContext config, DanmakuContext.DanmakuConfigTag tag, Object ... values) {
        boolean handled = this.handleOnDanmakuConfigChanged(config, tag, values);
        if (this.mTaskListener != null) {
            this.mTaskListener.onDanmakuConfigChanged();
        }
        return handled;
    }

    protected boolean handleOnDanmakuConfigChanged(DanmakuContext config, DanmakuContext.DanmakuConfigTag tag, Object[] values) {
        Boolean enable;
        boolean handled = false;
        if (tag == null || DanmakuContext.DanmakuConfigTag.MAXIMUM_NUMS_IN_SCREEN.equals((Object)tag)) {
            handled = true;
        } else if (DanmakuContext.DanmakuConfigTag.DUPLICATE_MERGING_ENABLED.equals((Object)tag)) {
            Boolean enable2 = (Boolean)values[0];
            if (enable2 != null) {
                if (enable2.booleanValue()) {
                    this.mContext.mDanmakuFilters.registerFilter("1017_Filter");
                } else {
                    this.mContext.mDanmakuFilters.unregisterFilter("1017_Filter");
                }
                handled = true;
            }
        } else if (DanmakuContext.DanmakuConfigTag.SCALE_TEXTSIZE.equals((Object)tag) || DanmakuContext.DanmakuConfigTag.SCROLL_SPEED_FACTOR.equals((Object)tag) || DanmakuContext.DanmakuConfigTag.DANMAKU_MARGIN.equals((Object)tag)) {
            this.requestClearRetainer();
            handled = false;
        } else if (DanmakuContext.DanmakuConfigTag.MAXIMUN_LINES.equals((Object)tag) || DanmakuContext.DanmakuConfigTag.OVERLAPPING_ENABLE.equals((Object)tag)) {
            if (this.mRenderer != null) {
                this.mRenderer.setVerifierEnabled(this.mContext.isPreventOverlappingEnabled() || this.mContext.isMaxLinesLimited());
            }
            handled = true;
        } else if (DanmakuContext.DanmakuConfigTag.ALIGN_BOTTOM.equals((Object)tag) && (enable = (Boolean)values[0]) != null) {
            if (this.mRenderer != null) {
                this.mRenderer.alignBottom(enable);
            }
            handled = true;
        }
        return handled;
    }

    @Override
    public void requestHide() {
        this.mIsHidden = true;
    }

    @Override
    public void requestRender() {
        this.mRequestRender = true;
    }

    private void beginTracing(IRenderer.RenderingState renderingState, IDanmakus runningDanmakus, IDanmakus screenDanmakus) {
        renderingState.reset();
        renderingState.timer.update(SystemClock.uptimeMillis());
        renderingState.indexInScreen = 0;
        renderingState.totalSizeInScreen = (runningDanmakus != null ? runningDanmakus.size() : 0) + (screenDanmakus != null ? screenDanmakus.size() : 0);
    }

    private void endTracing(IRenderer.RenderingState renderingState) {
        boolean bl = renderingState.nothingRendered = renderingState.totalDanmakuCount == 0;
        if (renderingState.nothingRendered) {
            renderingState.beginTime = -1L;
        }
        BaseDanmaku lastDanmaku = renderingState.lastDanmaku;
        renderingState.lastDanmaku = null;
        renderingState.endTime = lastDanmaku != null ? lastDanmaku.getActualTime() : -1L;
        renderingState.consumingTime = renderingState.timer.update(SystemClock.uptimeMillis());
    }
}

