/*
 * Decompiled with CFR 0.152.
 */
package master.flame.danmaku.controller;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import master.flame.danmaku.controller.DrawTask;
import master.flame.danmaku.controller.IDrawTask;
import master.flame.danmaku.danmaku.model.AbsDisplayer;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.DanmakuTimer;
import master.flame.danmaku.danmaku.model.ICacheManager;
import master.flame.danmaku.danmaku.model.IDanmakus;
import master.flame.danmaku.danmaku.model.IDrawingCache;
import master.flame.danmaku.danmaku.model.android.DanmakuContext;
import master.flame.danmaku.danmaku.model.android.DanmakuFactory;
import master.flame.danmaku.danmaku.model.android.Danmakus;
import master.flame.danmaku.danmaku.model.android.DrawingCache;
import master.flame.danmaku.danmaku.model.android.DrawingCachePoolManager;
import master.flame.danmaku.danmaku.model.objectpool.Pool;
import master.flame.danmaku.danmaku.model.objectpool.Pools;
import master.flame.danmaku.danmaku.renderer.IRenderer;
import master.flame.danmaku.danmaku.util.DanmakuUtils;
import master.flame.danmaku.danmaku.util.SystemClock;
import tv.cjump.jni.NativeBitmapFactory;

public class CacheManagingDrawTask
extends DrawTask {
    private static final int MAX_CACHE_SCREEN_SIZE = 3;
    private int mMaxCacheSize = 2;
    private CacheManager mCacheManager;
    private DanmakuTimer mCacheTimer;
    private final Object mDrawingNotify = new Object();
    private int mRemaininCacheCount;

    public CacheManagingDrawTask(DanmakuTimer timer, DanmakuContext config, IDrawTask.TaskListener taskListener) {
        super(timer, config, taskListener);
        NativeBitmapFactory.loadLibs();
        this.mMaxCacheSize = (int)Math.max(4194304.0f, (float)Runtime.getRuntime().maxMemory() * config.cachingPolicy.maxCachePoolSizeFactorPercentage);
        this.mCacheManager = new CacheManager(this.mMaxCacheSize, 3);
        this.mRenderer.setCacheManager(this.mCacheManager);
    }

    @Override
    protected void initTimer(DanmakuTimer timer) {
        this.mTimer = timer;
        this.mCacheTimer = new DanmakuTimer();
        this.mCacheTimer.update(timer.currMillisecond);
    }

    @Override
    public void addDanmaku(BaseDanmaku danmaku) {
        super.addDanmaku(danmaku);
        if (this.mCacheManager == null) {
            return;
        }
        this.mCacheManager.addDanmaku(danmaku);
    }

    @Override
    public void invalidateDanmaku(BaseDanmaku item, boolean remeasure) {
        super.invalidateDanmaku(item, remeasure);
        if (this.mCacheManager == null) {
            return;
        }
        this.mCacheManager.invalidateDanmaku(item, remeasure);
    }

    @Override
    public void removeAllDanmakus(boolean isClearDanmakusOnScreen) {
        super.removeAllDanmakus(isClearDanmakusOnScreen);
        if (this.mCacheManager != null) {
            this.mCacheManager.requestClearAll();
        }
    }

    @Override
    protected void onDanmakuRemoved(BaseDanmaku danmaku) {
        super.onDanmakuRemoved(danmaku);
        if (this.mCacheManager != null) {
            if (++this.mRemaininCacheCount > 5) {
                this.mCacheManager.requestClearTimeout();
                this.mRemaininCacheCount = 0;
            }
        } else {
            IDrawingCache<?> cache = danmaku.getDrawingCache();
            if (cache != null) {
                if (cache.hasReferences()) {
                    cache.decreaseReference();
                } else {
                    cache.destroy();
                }
                danmaku.cache = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRenderer.RenderingState draw(AbsDisplayer displayer) {
        IRenderer.RenderingState result = super.draw(displayer);
        Object object = this.mDrawingNotify;
        synchronized (object) {
            this.mDrawingNotify.notify();
        }
        if (result != null && this.mCacheManager != null && result.totalDanmakuCount - result.lastTotalDanmakuCount < -20) {
            this.mCacheManager.requestClearTimeout();
            this.mCacheManager.requestBuild(-this.mContext.mDanmakuFactory.MAX_DANMAKU_DURATION);
        }
        return result;
    }

    @Override
    public void seek(long mills) {
        super.seek(mills);
        if (this.mCacheManager == null) {
            this.start();
        }
        this.mCacheManager.seek(mills);
    }

    @Override
    public void start() {
        super.start();
        NativeBitmapFactory.loadLibs();
        if (this.mCacheManager == null) {
            this.mCacheManager = new CacheManager(this.mMaxCacheSize, 3);
            this.mCacheManager.begin();
            this.mRenderer.setCacheManager(this.mCacheManager);
        } else {
            this.mCacheManager.resume();
        }
    }

    @Override
    public void quit() {
        super.quit();
        this.reset();
        this.mRenderer.setCacheManager(null);
        if (this.mCacheManager != null) {
            this.mCacheManager.end();
            this.mCacheManager = null;
        }
        NativeBitmapFactory.releaseLibs();
    }

    @Override
    public void prepare() {
        if (this.mParser == null) {
            return;
        }
        this.loadDanmakus(this.mParser);
        this.mCacheManager.begin();
    }

    @Override
    public void onPlayStateChanged(int state) {
        super.onPlayStateChanged(state);
        if (this.mCacheManager != null) {
            this.mCacheManager.onPlayStateChanged(state);
        }
    }

    @Override
    public void requestSync(long fromTimeMills, long toTimeMills, long offsetMills) {
        super.requestSync(fromTimeMills, toTimeMills, offsetMills);
        if (this.mCacheManager != null) {
            this.mCacheManager.seek(toTimeMills);
        }
    }

    @Override
    public boolean onDanmakuConfigChanged(DanmakuContext config, DanmakuContext.DanmakuConfigTag tag, Object ... values) {
        if (!super.handleOnDanmakuConfigChanged(config, tag, values)) {
            if (DanmakuContext.DanmakuConfigTag.SCROLL_SPEED_FACTOR.equals((Object)tag)) {
                this.mDisp.resetSlopPixel(this.mContext.scaleTextSize);
                this.requestClear();
            } else if (tag.isVisibilityRelatedTag()) {
                if (values != null && values.length > 0 && values[0] != null && (!(values[0] instanceof Boolean) || ((Boolean)values[0]).booleanValue()) && this.mCacheManager != null) {
                    this.mCacheManager.requestBuild(0L);
                }
                this.requestClear();
            } else if (DanmakuContext.DanmakuConfigTag.TRANSPARENCY.equals((Object)tag) || DanmakuContext.DanmakuConfigTag.SCALE_TEXTSIZE.equals((Object)tag) || DanmakuContext.DanmakuConfigTag.DANMAKU_STYLE.equals((Object)tag)) {
                if (DanmakuContext.DanmakuConfigTag.SCALE_TEXTSIZE.equals((Object)tag)) {
                    this.mDisp.resetSlopPixel(this.mContext.scaleTextSize);
                }
                if (this.mCacheManager != null) {
                    this.mCacheManager.requestClearAll();
                    this.mCacheManager.requestBuild(-this.mContext.mDanmakuFactory.MAX_DANMAKU_DURATION);
                }
            } else if (this.mCacheManager != null) {
                this.mCacheManager.requestClearUnused();
                this.mCacheManager.requestBuild(0L);
            }
        }
        if (this.mTaskListener != null && this.mCacheManager != null) {
            this.mCacheManager.post(new Runnable(){

                @Override
                public void run() {
                    CacheManagingDrawTask.this.mTaskListener.onDanmakuConfigChanged();
                }
            });
        }
        return true;
    }

    public class CacheManager
    implements ICacheManager {
        private static final String TAG = "CacheManager";
        public static final byte RESULT_SUCCESS = 0;
        public static final byte RESULT_FAILED = 1;
        public static final byte RESULT_FAILED_OVERSIZE = 2;
        public HandlerThread mThread;
        Danmakus mCaches = new Danmakus();
        DrawingCachePoolManager mCachePoolManager = new DrawingCachePoolManager();
        Pool<DrawingCache> mCachePool = Pools.finitePool(this.mCachePoolManager, 800);
        private int mMaxSize;
        private int mRealSize = 0;
        private int mScreenSize = 3;
        private CacheHandler mHandler;
        private boolean mEndFlag = false;

        public CacheManager(int maxSize, int screenSize) {
            this.mMaxSize = maxSize;
            this.mScreenSize = screenSize;
        }

        public void seek(long mills) {
            if (this.mHandler == null) {
                return;
            }
            this.mHandler.requestCancelCaching();
            this.mHandler.removeMessages(3);
            this.mHandler.obtainMessage(5, mills).sendToTarget();
        }

        @Override
        public void addDanmaku(BaseDanmaku danmaku) {
            if (this.mHandler != null) {
                if (danmaku.isLive && danmaku.forceBuildCacheInSameThread) {
                    if (!danmaku.isTimeOut()) {
                        this.mHandler.createCache(danmaku);
                    }
                    return;
                }
                this.mHandler.obtainMessage(2, danmaku).sendToTarget();
            }
        }

        public void invalidateDanmaku(BaseDanmaku danmaku, boolean remeasure) {
            if (this.mHandler != null) {
                this.mHandler.requestCancelCaching();
                this.mHandler.obtainMessage(17, danmaku).sendToTarget();
                this.mHandler.sendEmptyMessage(18);
                this.requestBuild(0L);
            }
        }

        public void begin() {
            this.mEndFlag = false;
            if (this.mThread == null) {
                this.mThread = new HandlerThread("DFM Cache-Building Thread");
                this.mThread.start();
            }
            if (this.mHandler == null) {
                this.mHandler = new CacheHandler(this.mThread.getLooper());
            }
            this.mHandler.begin();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void end() {
            this.mEndFlag = true;
            Object object = CacheManagingDrawTask.this.mDrawingNotify;
            synchronized (object) {
                CacheManagingDrawTask.this.mDrawingNotify.notifyAll();
            }
            if (this.mHandler != null) {
                this.mHandler.removeCallbacksAndMessages(null);
                this.mHandler.pause();
                this.mHandler = null;
            }
            if (this.mThread != null) {
                try {
                    this.mThread.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.mThread.quit();
                this.mThread = null;
            }
        }

        public void resume() {
            if (this.mHandler != null) {
                this.mHandler.resume();
            } else {
                this.begin();
            }
        }

        public void onPlayStateChanged(int state) {
            if (this.mHandler != null) {
                this.mHandler.onPlayStateChanged(state == 1);
            }
        }

        public float getPoolPercent() {
            if (this.mMaxSize == 0) {
                return 0.0f;
            }
            return (float)this.mRealSize / (float)this.mMaxSize;
        }

        public boolean isPoolFull() {
            return this.mRealSize + 5120 >= this.mMaxSize;
        }

        private void evictAll() {
            if (this.mCaches != null) {
                this.mCaches.forEach(new IDanmakus.DefaultConsumer<BaseDanmaku>(){

                    @Override
                    public int accept(BaseDanmaku danmaku) {
                        CacheManager.this.entryRemoved(true, danmaku, null);
                        return 0;
                    }
                });
                this.mCaches.clear();
            }
            this.mRealSize = 0;
        }

        private void evictAllNotInScreen() {
            if (this.mCaches != null) {
                this.mCaches.forEach(new IDanmakus.DefaultConsumer<BaseDanmaku>(){

                    @Override
                    public int accept(BaseDanmaku danmaku) {
                        if (danmaku.isOutside()) {
                            CacheManager.this.entryRemoved(true, danmaku, null);
                            return 2;
                        }
                        return 0;
                    }
                });
            }
        }

        protected void entryRemoved(boolean evicted, BaseDanmaku oldValue, BaseDanmaku newValue) {
            IDrawingCache<?> cache = oldValue.getDrawingCache();
            if (cache != null) {
                long releasedSize = this.clearCache(oldValue);
                if (oldValue.isTimeOut()) {
                    CacheManagingDrawTask.this.mContext.getDisplayer().getCacheStuffer().releaseResource(oldValue);
                }
                if (releasedSize <= 0L) {
                    return;
                }
                this.mRealSize = (int)((long)this.mRealSize - releasedSize);
                this.mCachePool.release((DrawingCache)cache);
            }
        }

        private long clearCache(BaseDanmaku oldValue) {
            IDrawingCache<?> cache = oldValue.cache;
            if (cache == null) {
                return 0L;
            }
            if (cache.hasReferences()) {
                cache.decreaseReference();
                oldValue.cache = null;
                return 0L;
            }
            long size = this.sizeOf(oldValue);
            cache.destroy();
            oldValue.cache = null;
            return size;
        }

        protected int sizeOf(BaseDanmaku value) {
            if (value.cache != null && !value.cache.hasReferences()) {
                return value.cache.size();
            }
            return 0;
        }

        private void clearCachePool() {
            DrawingCache item;
            while ((item = this.mCachePool.acquire()) != null) {
                item.destroy();
            }
        }

        private boolean push(BaseDanmaku item, int itemSize, boolean forcePush) {
            int size = itemSize;
            if (size > 0) {
                this.clearTimeOutAndFilteredCaches(size, forcePush);
            }
            this.mCaches.addItem(item);
            this.mRealSize += size;
            return true;
        }

        private void clearTimeOutCaches() {
            this.mCaches.forEach(new IDanmakus.DefaultConsumer<BaseDanmaku>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public int accept(BaseDanmaku val) {
                    if (val.isTimeOut()) {
                        IDrawingCache<?> cache = val.cache;
                        if (CacheManagingDrawTask.this.mContext.cachingPolicy.periodOfRecycle == -1L && cache != null && !cache.hasReferences() && (float)cache.size() / (float)CacheManagingDrawTask.this.mMaxCacheSize < CacheManagingDrawTask.this.mContext.cachingPolicy.forceRecyleThreshold) {
                            return 0;
                        }
                        if (!CacheManager.this.mEndFlag) {
                            Object object = CacheManagingDrawTask.this.mDrawingNotify;
                            synchronized (object) {
                                try {
                                    CacheManagingDrawTask.this.mDrawingNotify.wait(30L);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                    return 1;
                                }
                            }
                        }
                        CacheManager.this.entryRemoved(false, val, null);
                        return 2;
                    }
                    return 1;
                }
            });
        }

        private BaseDanmaku findReusableCache(final BaseDanmaku refDanmaku, final boolean strictMode, final int maximumTimes) {
            int slopPixel = 0;
            if (!strictMode) {
                slopPixel = CacheManagingDrawTask.this.mDisp.getSlopPixel() * 2;
            }
            final int finalSlopPixel = slopPixel + CacheManagingDrawTask.this.mContext.cachingPolicy.reusableOffsetPixel;
            IDanmakus.Consumer<BaseDanmaku, BaseDanmaku> consumer = new IDanmakus.Consumer<BaseDanmaku, BaseDanmaku>(){
                int count = 0;
                BaseDanmaku mResult;

                @Override
                public BaseDanmaku result() {
                    return this.mResult;
                }

                @Override
                public int accept(BaseDanmaku danmaku) {
                    if (this.count++ >= maximumTimes) {
                        return 1;
                    }
                    IDrawingCache<?> cache = danmaku.getDrawingCache();
                    if (cache == null || cache.get() == null) {
                        return 0;
                    }
                    if (danmaku.paintWidth == refDanmaku.paintWidth && danmaku.paintHeight == refDanmaku.paintHeight && danmaku.underlineColor == refDanmaku.underlineColor && danmaku.borderColor == refDanmaku.borderColor && danmaku.textColor == refDanmaku.textColor && danmaku.text.equals(refDanmaku.text) && danmaku.tag == refDanmaku.tag) {
                        this.mResult = danmaku;
                        return 1;
                    }
                    if (strictMode) {
                        return 0;
                    }
                    if (!danmaku.isTimeOut()) {
                        return 1;
                    }
                    if (cache.hasReferences()) {
                        return 0;
                    }
                    float widthGap = (float)cache.width() - refDanmaku.paintWidth;
                    float heightGap = (float)cache.height() - refDanmaku.paintHeight;
                    if (widthGap >= 0.0f && widthGap <= (float)finalSlopPixel && heightGap >= 0.0f && heightGap <= (float)finalSlopPixel) {
                        this.mResult = danmaku;
                        return 1;
                    }
                    return 0;
                }
            };
            this.mCaches.forEach(consumer);
            return (BaseDanmaku)consumer.result();
        }

        private void clearTimeOutAndFilteredCaches(int expectedFreeSize, final boolean forcePush) {
            final int fexpectedFreeSize = expectedFreeSize;
            this.mCaches.forEach(new IDanmakus.DefaultConsumer<BaseDanmaku>(){

                @Override
                public int accept(BaseDanmaku oldValue) {
                    if (CacheManager.this.mEndFlag) {
                        return 1;
                    }
                    if (CacheManager.this.mRealSize + fexpectedFreeSize > CacheManager.this.mMaxSize) {
                        if (oldValue.isTimeOut() || oldValue.isFiltered()) {
                            CacheManager.this.entryRemoved(false, oldValue, null);
                            return 2;
                        }
                        if (forcePush) {
                            return 1;
                        }
                    } else {
                        return 1;
                    }
                    return 0;
                }
            });
        }

        public long getFirstCacheTime() {
            if (this.mCaches != null && this.mCaches.size() > 0) {
                BaseDanmaku firstItem = this.mCaches.first();
                if (firstItem == null) {
                    return 0L;
                }
                return firstItem.getActualTime();
            }
            return 0L;
        }

        public void requestBuild(long correctionTime) {
            if (this.mHandler != null) {
                this.mHandler.requestBuildCacheAndDraw(correctionTime);
            }
        }

        public void requestClearAll() {
            if (this.mHandler == null) {
                return;
            }
            this.mHandler.removeMessages(3);
            this.mHandler.removeMessages(18);
            this.mHandler.requestCancelCaching();
            this.mHandler.removeMessages(7);
            this.mHandler.sendEmptyMessage(7);
        }

        public void requestClearUnused() {
            if (this.mHandler == null) {
                return;
            }
            this.mHandler.removeMessages(9);
            this.mHandler.sendEmptyMessage(9);
        }

        public void requestClearTimeout() {
            if (this.mHandler == null) {
                return;
            }
            this.mHandler.removeMessages(4);
            this.mHandler.sendEmptyMessage(4);
        }

        public void post(Runnable runnable) {
            if (this.mHandler == null) {
                return;
            }
            this.mHandler.post(runnable);
        }

        public class CacheHandler
        extends Handler {
            private static final int PREPARE = 1;
            public static final int ADD_DANMAKU = 2;
            public static final int BUILD_CACHES = 3;
            public static final int CLEAR_TIMEOUT_CACHES = 4;
            public static final int SEEK = 5;
            public static final int QUIT = 6;
            public static final int CLEAR_ALL_CACHES = 7;
            public static final int CLEAR_OUTSIDE_CACHES = 8;
            public static final int CLEAR_OUTSIDE_CACHES_AND_RESET = 9;
            public static final int DISPATCH_ACTIONS = 16;
            public static final int REBUILD_CACHE = 17;
            public static final int DISABLE_CANCEL_FLAG = 18;
            private boolean mPause;
            private boolean mIsPlayerPause;
            private boolean mSeekedFlag;
            private boolean mCancelFlag;

            public CacheHandler(Looper looper) {
                super(looper);
            }

            public void requestCancelCaching() {
                this.mCancelFlag = true;
            }

            public void handleMessage(Message msg) {
                int what = msg.what;
                switch (what) {
                    case 1: {
                        CacheManager.this.evictAllNotInScreen();
                        for (int i = 0; i < 300; ++i) {
                            CacheManager.this.mCachePool.release(new DrawingCache());
                        }
                    }
                    case 16: {
                        long delayed = this.dispatchAction();
                        if (delayed <= 0L) {
                            delayed = CacheManagingDrawTask.this.mContext.mDanmakuFactory.MAX_DANMAKU_DURATION / 2L;
                        }
                        this.sendEmptyMessageDelayed(16, delayed);
                        break;
                    }
                    case 3: {
                        this.removeMessages(3);
                        boolean repositioned = CacheManagingDrawTask.this.mTaskListener != null && !CacheManagingDrawTask.this.mReadyState || this.mSeekedFlag;
                        this.prepareCaches(repositioned);
                        if (repositioned) {
                            this.mSeekedFlag = false;
                        }
                        if (CacheManagingDrawTask.this.mTaskListener == null || CacheManagingDrawTask.this.mReadyState) break;
                        CacheManagingDrawTask.this.mTaskListener.ready();
                        CacheManagingDrawTask.this.mReadyState = true;
                        break;
                    }
                    case 2: {
                        BaseDanmaku item = (BaseDanmaku)msg.obj;
                        this.addDanmakuAndBuildCache(item);
                        break;
                    }
                    case 17: {
                        boolean requestRemeasure;
                        BaseDanmaku cacheitem = (BaseDanmaku)msg.obj;
                        if (cacheitem == null) break;
                        DrawingCache cache = cacheitem.getDrawingCache();
                        boolean bl = requestRemeasure = 0 != (cacheitem.requestFlags & 1);
                        if (!requestRemeasure && cache != null && cache.get() != null && !cache.hasReferences()) {
                            cacheitem.cache = cache = DanmakuUtils.buildDanmakuDrawingCache(cacheitem, CacheManagingDrawTask.this.mDisp, (DrawingCache)cacheitem.cache, CacheManagingDrawTask.this.mContext.cachingPolicy.bitsPerPixelOfCache);
                            CacheManager.this.push(cacheitem, 0, true);
                            return;
                        }
                        if (cacheitem.isLive) {
                            CacheManager.this.clearCache(cacheitem);
                            this.createCache(cacheitem);
                            break;
                        }
                        if (cache != null && cache.hasReferences()) {
                            cache.destroy();
                        }
                        CacheManager.this.entryRemoved(true, cacheitem, null);
                        this.addDanmakuAndBuildCache(cacheitem);
                        break;
                    }
                    case 4: {
                        CacheManager.this.clearTimeOutCaches();
                        break;
                    }
                    case 5: {
                        Long seekMills = (Long)msg.obj;
                        if (seekMills == null) break;
                        long seekCacheTime = seekMills;
                        long oldCacheTime = ((CacheManagingDrawTask)CacheManagingDrawTask.this).mCacheTimer.currMillisecond;
                        CacheManagingDrawTask.this.mCacheTimer.update(seekCacheTime);
                        this.mSeekedFlag = true;
                        long firstCacheTime = CacheManager.this.getFirstCacheTime();
                        if (seekCacheTime > oldCacheTime || firstCacheTime - seekCacheTime > CacheManagingDrawTask.this.mContext.mDanmakuFactory.MAX_DANMAKU_DURATION) {
                            CacheManager.this.evictAllNotInScreen();
                        } else {
                            CacheManager.this.clearTimeOutCaches();
                        }
                        this.prepareCaches(true);
                        this.resume();
                        break;
                    }
                    case 6: {
                        this.removeCallbacksAndMessages(null);
                        this.mPause = true;
                        CacheManager.this.evictAll();
                        CacheManager.this.clearCachePool();
                        this.getLooper().quit();
                        break;
                    }
                    case 7: {
                        CacheManager.this.evictAll();
                        CacheManagingDrawTask.this.mCacheTimer.update(CacheManagingDrawTask.this.mTimer.currMillisecond - CacheManagingDrawTask.this.mContext.mDanmakuFactory.MAX_DANMAKU_DURATION);
                        this.mSeekedFlag = true;
                        break;
                    }
                    case 8: {
                        CacheManager.this.evictAllNotInScreen();
                        CacheManagingDrawTask.this.mCacheTimer.update(CacheManagingDrawTask.this.mTimer.currMillisecond);
                        break;
                    }
                    case 9: {
                        CacheManager.this.evictAllNotInScreen();
                        CacheManagingDrawTask.this.mCacheTimer.update(CacheManagingDrawTask.this.mTimer.currMillisecond);
                        CacheManagingDrawTask.this.requestClear();
                        break;
                    }
                    case 18: {
                        this.mCancelFlag = false;
                    }
                }
            }

            private long dispatchAction() {
                if (((CacheManagingDrawTask)CacheManagingDrawTask.this).mCacheTimer.currMillisecond <= CacheManagingDrawTask.this.mTimer.currMillisecond - CacheManagingDrawTask.this.mContext.mDanmakuFactory.MAX_DANMAKU_DURATION) {
                    if (CacheManagingDrawTask.this.mContext.cachingPolicy.periodOfRecycle != -1L) {
                        CacheManager.this.evictAllNotInScreen();
                    }
                    CacheManagingDrawTask.this.mCacheTimer.update(CacheManagingDrawTask.this.mTimer.currMillisecond);
                    this.sendEmptyMessage(3);
                    return 0L;
                }
                float level = CacheManager.this.getPoolPercent();
                BaseDanmaku firstCache = CacheManager.this.mCaches.first();
                long gapTime = firstCache != null ? firstCache.getActualTime() - CacheManagingDrawTask.this.mTimer.currMillisecond : 0L;
                long doubleScreenDuration = CacheManagingDrawTask.this.mContext.mDanmakuFactory.MAX_DANMAKU_DURATION * 2L;
                if (level < 0.6f && gapTime > CacheManagingDrawTask.this.mContext.mDanmakuFactory.MAX_DANMAKU_DURATION) {
                    CacheManagingDrawTask.this.mCacheTimer.update(CacheManagingDrawTask.this.mTimer.currMillisecond);
                    this.removeMessages(3);
                    this.sendEmptyMessage(3);
                    return 0L;
                }
                if (level > 0.4f && gapTime < -doubleScreenDuration) {
                    this.removeMessages(4);
                    this.sendEmptyMessage(4);
                    return 0L;
                }
                if (level >= 0.9f) {
                    return 0L;
                }
                long deltaTime = ((CacheManagingDrawTask)CacheManagingDrawTask.this).mCacheTimer.currMillisecond - CacheManagingDrawTask.this.mTimer.currMillisecond;
                if (firstCache != null && firstCache.isTimeOut() && deltaTime < -CacheManagingDrawTask.this.mContext.mDanmakuFactory.MAX_DANMAKU_DURATION) {
                    CacheManagingDrawTask.this.mCacheTimer.update(CacheManagingDrawTask.this.mTimer.currMillisecond);
                    this.sendEmptyMessage(8);
                    this.sendEmptyMessage(3);
                    return 0L;
                }
                if (deltaTime > doubleScreenDuration) {
                    return 0L;
                }
                this.removeMessages(3);
                this.sendEmptyMessage(3);
                return 0L;
            }

            private void releaseDanmakuCache(BaseDanmaku item, DrawingCache cache) {
                if (cache == null) {
                    cache = (DrawingCache)item.cache;
                }
                item.cache = null;
                if (cache == null) {
                    return;
                }
                cache.destroy();
                CacheManager.this.mCachePool.release(cache);
            }

            private void preMeasure() {
                IDanmakus danmakus = null;
                try {
                    long begin = CacheManagingDrawTask.this.mTimer.currMillisecond;
                    long end = begin + CacheManagingDrawTask.this.mContext.mDanmakuFactory.MAX_DANMAKU_DURATION * 2L;
                    danmakus = CacheManagingDrawTask.this.danmakuList.subnew(begin - CacheManagingDrawTask.this.mContext.mDanmakuFactory.MAX_DANMAKU_DURATION, end);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (danmakus == null || danmakus.isEmpty()) {
                    return;
                }
                danmakus.forEach(new IDanmakus.DefaultConsumer<BaseDanmaku>(){

                    @Override
                    public int accept(BaseDanmaku item) {
                        if (CacheHandler.this.mPause || CacheHandler.this.mCancelFlag) {
                            return 1;
                        }
                        if (!item.hasPassedFilter()) {
                            CacheManagingDrawTask.this.mContext.mDanmakuFilters.filter(item, 0, 0, null, true, CacheManagingDrawTask.this.mContext);
                        }
                        if (item.isFiltered()) {
                            return 0;
                        }
                        if (!item.isMeasured()) {
                            item.measure(CacheManagingDrawTask.this.mDisp, true);
                        }
                        if (!item.isPrepared()) {
                            item.prepare(CacheManagingDrawTask.this.mDisp, true);
                        }
                        return 0;
                    }
                });
            }

            private long prepareCaches(final boolean repositioned) {
                this.preMeasure();
                final long curr = ((CacheManagingDrawTask)CacheManagingDrawTask.this).mCacheTimer.currMillisecond - 30L;
                long end = curr + CacheManagingDrawTask.this.mContext.mDanmakuFactory.MAX_DANMAKU_DURATION * (long)CacheManager.this.mScreenSize;
                if (end < CacheManagingDrawTask.this.mTimer.currMillisecond) {
                    return 0L;
                }
                final long startTime = SystemClock.uptimeMillis();
                IDanmakus danmakus = null;
                int tryCount = 0;
                boolean hasException = false;
                do {
                    try {
                        danmakus = CacheManagingDrawTask.this.danmakuList.subnew(curr, end);
                    }
                    catch (Exception e) {
                        hasException = true;
                        SystemClock.sleep(10L);
                    }
                } while (++tryCount < 3 && danmakus == null && hasException);
                if (danmakus == null) {
                    CacheManagingDrawTask.this.mCacheTimer.update(end);
                    return 0L;
                }
                BaseDanmaku first = danmakus.first();
                final BaseDanmaku last = danmakus.last();
                if (first == null || last == null) {
                    CacheManagingDrawTask.this.mCacheTimer.update(end);
                    return 0L;
                }
                long deltaTime = first.getActualTime() - CacheManagingDrawTask.this.mTimer.currMillisecond;
                long sleepTime = deltaTime < 0L ? 30L : 30L + 10L * deltaTime / CacheManagingDrawTask.this.mContext.mDanmakuFactory.MAX_DANMAKU_DURATION;
                sleepTime = Math.min(100L, sleepTime);
                if (repositioned) {
                    sleepTime = 0L;
                }
                final long finalSleepTime = sleepTime;
                BaseDanmaku item = null;
                long consumingTime = 0L;
                boolean orderInScreen = false;
                boolean currScreenIndex = false;
                final int sizeInScreen = danmakus.size();
                danmakus.forEach(new IDanmakus.DefaultConsumer<BaseDanmaku>(){
                    int orderInScreen = 0;
                    int currScreenIndex = 0;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public int accept(BaseDanmaku item) {
                        if (CacheHandler.this.mPause || CacheHandler.this.mCancelFlag) {
                            return 1;
                        }
                        if (last.getActualTime() < CacheManagingDrawTask.this.mTimer.currMillisecond) {
                            return 1;
                        }
                        IDrawingCache<?> cache = item.getDrawingCache();
                        if (cache != null && cache.get() != null) {
                            return 0;
                        }
                        if (!(repositioned || !item.isTimeOut() && item.isOutside())) {
                            return 0;
                        }
                        if (!item.hasPassedFilter()) {
                            CacheManagingDrawTask.this.mContext.mDanmakuFilters.filter(item, this.orderInScreen, sizeInScreen, null, true, CacheManagingDrawTask.this.mContext);
                        }
                        if (item.priority == 0 && item.isFiltered()) {
                            return 0;
                        }
                        if (item.getType() == 1) {
                            int screenIndex = (int)((item.getActualTime() - curr) / CacheManagingDrawTask.this.mContext.mDanmakuFactory.MAX_DANMAKU_DURATION);
                            if (this.currScreenIndex == screenIndex) {
                                ++this.orderInScreen;
                            } else {
                                this.orderInScreen = 0;
                                this.currScreenIndex = screenIndex;
                            }
                        }
                        if (!repositioned && !CacheHandler.this.mIsPlayerPause) {
                            try {
                                Object screenIndex = CacheManagingDrawTask.this.mDrawingNotify;
                                synchronized (screenIndex) {
                                    CacheManagingDrawTask.this.mDrawingNotify.wait(finalSleepTime);
                                }
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                                return 1;
                            }
                        }
                        CacheHandler.this.buildCache(item, false);
                        if (!repositioned) {
                            long consumingTime = SystemClock.uptimeMillis() - startTime;
                            DanmakuFactory cfr_ignored_0 = CacheManagingDrawTask.this.mContext.mDanmakuFactory;
                            if (consumingTime >= 3800L * (long)CacheManager.this.mScreenSize) {
                                return 1;
                            }
                        }
                        return 0;
                    }
                });
                consumingTime = SystemClock.uptimeMillis() - startTime;
                if (item != null) {
                    CacheManagingDrawTask.this.mCacheTimer.update(item.getTime());
                } else {
                    CacheManagingDrawTask.this.mCacheTimer.update(end);
                }
                return consumingTime;
            }

            public boolean createCache(BaseDanmaku item) {
                if (!item.isMeasured()) {
                    item.measure(CacheManagingDrawTask.this.mDisp, true);
                }
                DrawingCache cache = null;
                try {
                    cache = CacheManager.this.mCachePool.acquire();
                    item.cache = cache = DanmakuUtils.buildDanmakuDrawingCache(item, CacheManagingDrawTask.this.mDisp, cache, CacheManagingDrawTask.this.mContext.cachingPolicy.bitsPerPixelOfCache);
                }
                catch (OutOfMemoryError e) {
                    if (cache != null) {
                        CacheManager.this.mCachePool.release(cache);
                    }
                    item.cache = null;
                    return false;
                }
                catch (Exception e) {
                    if (cache != null) {
                        CacheManager.this.mCachePool.release(cache);
                    }
                    item.cache = null;
                    return false;
                }
                return true;
            }

            private byte buildCache(BaseDanmaku item, boolean forceInsert) {
                if (!item.isMeasured()) {
                    item.measure(CacheManagingDrawTask.this.mDisp, true);
                }
                DrawingCache cache = null;
                try {
                    BaseDanmaku danmaku = CacheManager.this.findReusableCache(item, true, CacheManagingDrawTask.this.mContext.cachingPolicy.maxTimesOfStrictReusableFinds);
                    if (danmaku != null) {
                        cache = (DrawingCache)danmaku.cache;
                    }
                    if (cache != null) {
                        cache.increaseReference();
                        item.cache = cache;
                        CacheManagingDrawTask.this.mCacheManager.push(item, 0, forceInsert);
                        return 0;
                    }
                    danmaku = CacheManager.this.findReusableCache(item, false, CacheManagingDrawTask.this.mContext.cachingPolicy.maxTimesOfReusableFinds);
                    if (danmaku != null) {
                        cache = (DrawingCache)danmaku.cache;
                    }
                    if (cache != null) {
                        danmaku.cache = null;
                        item.cache = cache = DanmakuUtils.buildDanmakuDrawingCache(item, CacheManagingDrawTask.this.mDisp, cache, CacheManagingDrawTask.this.mContext.cachingPolicy.bitsPerPixelOfCache);
                        CacheManagingDrawTask.this.mCacheManager.push(item, 0, forceInsert);
                        return 0;
                    }
                    int cacheSize = DanmakuUtils.getCacheSize((int)item.paintWidth, (int)item.paintHeight, CacheManagingDrawTask.this.mContext.cachingPolicy.bitsPerPixelOfCache / 8);
                    if (cacheSize * 2 > CacheManagingDrawTask.this.mMaxCacheSize) {
                        return 1;
                    }
                    if (!forceInsert && CacheManager.this.mRealSize + cacheSize > CacheManager.this.mMaxSize) {
                        CacheManagingDrawTask.this.mCacheManager.clearTimeOutAndFilteredCaches(cacheSize, false);
                        return 1;
                    }
                    cache = CacheManager.this.mCachePool.acquire();
                    item.cache = cache = DanmakuUtils.buildDanmakuDrawingCache(item, CacheManagingDrawTask.this.mDisp, cache, CacheManagingDrawTask.this.mContext.cachingPolicy.bitsPerPixelOfCache);
                    boolean pushed = CacheManagingDrawTask.this.mCacheManager.push(item, CacheManager.this.sizeOf(item), forceInsert);
                    if (!pushed) {
                        this.releaseDanmakuCache(item, cache);
                    }
                    return pushed ? (byte)0 : 1;
                }
                catch (OutOfMemoryError e) {
                    this.releaseDanmakuCache(item, cache);
                    return 1;
                }
                catch (Exception e) {
                    this.releaseDanmakuCache(item, cache);
                    return 1;
                }
            }

            private final void addDanmakuAndBuildCache(BaseDanmaku danmaku) {
                if (danmaku.isTimeOut() || danmaku.getActualTime() > ((CacheManagingDrawTask)CacheManagingDrawTask.this).mCacheTimer.currMillisecond + CacheManagingDrawTask.this.mContext.mDanmakuFactory.MAX_DANMAKU_DURATION && !danmaku.isLive) {
                    return;
                }
                if (danmaku.priority == 0 && danmaku.isFiltered()) {
                    return;
                }
                IDrawingCache<?> cache = danmaku.getDrawingCache();
                if (cache == null || cache.get() == null) {
                    this.buildCache(danmaku, true);
                }
            }

            public void begin() {
                this.sendEmptyMessage(1);
                this.sendEmptyMessageDelayed(4, CacheManagingDrawTask.this.mContext.mDanmakuFactory.MAX_DANMAKU_DURATION);
            }

            public void pause() {
                this.mPause = true;
                this.sendEmptyMessage(6);
            }

            public void resume() {
                this.sendEmptyMessage(18);
                this.mPause = false;
                this.removeMessages(16);
                this.sendEmptyMessage(16);
                this.sendEmptyMessageDelayed(4, CacheManagingDrawTask.this.mContext.mDanmakuFactory.MAX_DANMAKU_DURATION);
            }

            public boolean isPause() {
                return this.mPause;
            }

            public void requestBuildCacheAndDraw(long correctionTime) {
                this.removeMessages(3);
                this.mSeekedFlag = true;
                this.sendEmptyMessage(18);
                CacheManagingDrawTask.this.mCacheTimer.update(CacheManagingDrawTask.this.mTimer.currMillisecond + correctionTime);
                this.sendEmptyMessage(3);
            }

            public void onPlayStateChanged(boolean isPlaying) {
                this.mIsPlayerPause = !isPlaying;
            }
        }
    }
}

