/*
 * Decompiled with CFR 0.152.
 */
package master.flame.danmaku.danmaku.model.android;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextPaint;
import android.util.SparseArray;
import android.view.View;
import java.util.ArrayList;
import java.util.List;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.android.AndroidDisplayer;
import master.flame.danmaku.danmaku.model.android.BaseCacheStuffer;

public abstract class ViewCacheStuffer<VH extends ViewHolder>
extends BaseCacheStuffer {
    public static final int INVALID_TYPE = -1;
    public static final int MEASURE_VIEW_TYPE = -2;
    public static final int DRAW_VIEW_TYPE = -3;
    public static final int CACHE_VIEW_TYPE = -3;
    private final int mMaximumWidthPixels;
    private final int mMaximumHeightPixels;
    private SparseArray<List<VH>> mViewHolderArray = new SparseArray();

    public abstract VH onCreateViewHolder(int var1);

    public abstract void onBindViewHolder(int var1, VH var2, BaseDanmaku var3, AndroidDisplayer.DisplayerConfig var4, TextPaint var5);

    public int getItemViewType(int position, BaseDanmaku danmaku) {
        return 0;
    }

    public ViewCacheStuffer() {
        this.mMaximumWidthPixels = -1;
        this.mMaximumHeightPixels = -1;
    }

    @Override
    public void measure(BaseDanmaku danmaku, TextPaint paint, boolean fromWorkerThread) {
        int viewType = this.getItemViewType(danmaku.index, danmaku);
        ArrayList<VH> viewHolders = (ArrayList<VH>)this.mViewHolderArray.get(viewType);
        if (viewHolders == null) {
            viewHolders = new ArrayList<VH>();
            viewHolders.add(this.onCreateViewHolder(viewType));
            viewHolders.add(this.onCreateViewHolder(viewType));
            viewHolders.add(this.onCreateViewHolder(viewType));
            this.mViewHolderArray.put(viewType, viewHolders);
        }
        ViewHolder viewHolder = (ViewHolder)viewHolders.get(0);
        this.onBindViewHolder(viewType, viewHolder, danmaku, null, paint);
        viewHolder.measure(View.MeasureSpec.makeMeasureSpec((int)this.mMaximumWidthPixels, (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)this.mMaximumHeightPixels, (int)Integer.MIN_VALUE));
        viewHolder.layout(0, 0, viewHolder.getMeasureWidth(), viewHolder.getMeasureHeight());
        danmaku.paintWidth = viewHolder.getMeasureWidth();
        danmaku.paintHeight = viewHolder.getMeasureHeight();
    }

    @Override
    public void clearCaches() {
    }

    @Override
    public void releaseResource(BaseDanmaku danmaku) {
        super.releaseResource(danmaku);
        danmaku.tag = null;
    }

    @Override
    public void drawDanmaku(BaseDanmaku danmaku, Canvas canvas, float left, float top, boolean fromWorkerThread, AndroidDisplayer.DisplayerConfig displayerConfig) {
        int viewType = this.getItemViewType(danmaku.index, danmaku);
        List viewHolders = (List)this.mViewHolderArray.get(viewType);
        ViewHolder viewHolder = null;
        if (viewHolders != null) {
            viewHolder = (ViewHolder)viewHolders.get(fromWorkerThread ? 1 : 2);
        }
        if (viewHolder == null) {
            return;
        }
        displayerConfig.definePaintParams(fromWorkerThread);
        TextPaint paint = displayerConfig.getPaint(danmaku, fromWorkerThread);
        displayerConfig.applyPaintConfig(danmaku, (Paint)paint, false);
        this.onBindViewHolder(viewType, viewHolder, danmaku, displayerConfig, paint);
        viewHolder.measure(View.MeasureSpec.makeMeasureSpec((int)Math.round(danmaku.paintWidth), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)Math.round(danmaku.paintHeight), (int)0x40000000));
        boolean needRestore = false;
        if (!fromWorkerThread) {
            canvas.save();
            canvas.translate(left, top);
            needRestore = true;
        }
        if (danmaku.underlineColor != 0) {
            Paint linePaint = displayerConfig.getUnderlinePaint(danmaku);
            float bottom = top + danmaku.paintHeight - (float)displayerConfig.UNDERLINE_HEIGHT;
            canvas.drawLine(left, bottom, left + danmaku.paintWidth, bottom, linePaint);
        }
        if (danmaku.borderColor != 0) {
            Paint borderPaint = displayerConfig.getBorderPaint(danmaku);
            canvas.drawRect(left, top, left + danmaku.paintWidth, top + danmaku.paintHeight, borderPaint);
        }
        viewHolder.layout(0, 0, (int)danmaku.paintWidth, (int)danmaku.paintHeight);
        viewHolder.draw(canvas, displayerConfig);
        if (needRestore) {
            canvas.restore();
        }
    }

    public static abstract class ViewHolder {
        protected final View itemView;

        public ViewHolder(View itemView) {
            if (itemView == null) {
                throw new IllegalArgumentException("itemView may not be null");
            }
            this.itemView = itemView;
        }

        public void measure(int widthMeasureSpec, int heightMeasureSpec) {
            this.itemView.measure(widthMeasureSpec, heightMeasureSpec);
        }

        public int getMeasureWidth() {
            return this.itemView.getMeasuredWidth();
        }

        public int getMeasureHeight() {
            return this.itemView.getMeasuredHeight();
        }

        public void layout(int l, int t, int r, int b) {
            this.itemView.layout(l, t, r, b);
        }

        public void draw(Canvas canvas, AndroidDisplayer.DisplayerConfig displayerConfig) {
            this.itemView.draw(canvas);
        }
    }
}

