/*
 * Decompiled with CFR 0.152.
 */
package master.flame.danmaku.danmaku.parser.android;

import android.text.TextUtils;
import java.io.IOException;
import java.util.Locale;
import master.flame.danmaku.danmaku.model.AlphaValue;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.Duration;
import master.flame.danmaku.danmaku.model.IDisplayer;
import master.flame.danmaku.danmaku.model.android.DanmakuFactory;
import master.flame.danmaku.danmaku.model.android.Danmakus;
import master.flame.danmaku.danmaku.parser.BaseDanmakuParser;
import master.flame.danmaku.danmaku.parser.android.AndroidFileSource;
import master.flame.danmaku.danmaku.util.DanmakuUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class BiliDanmukuParser
extends BaseDanmakuParser {
    private float mDispScaleX;
    private float mDispScaleY;

    @Override
    public Danmakus parse() {
        if (this.mDataSource != null) {
            AndroidFileSource source = (AndroidFileSource)this.mDataSource;
            try {
                XMLReader xmlReader = XMLReaderFactory.createXMLReader();
                XmlContentHandler contentHandler = new XmlContentHandler();
                xmlReader.setContentHandler(contentHandler);
                xmlReader.parse(new InputSource(source.data()));
                return contentHandler.getResult();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private boolean isPercentageNumber(float number) {
        return number >= 0.0f && number <= 1.0f;
    }

    @Override
    public BaseDanmakuParser setDisplayer(IDisplayer disp) {
        super.setDisplayer(disp);
        this.mDispScaleX = (float)this.mDispWidth / 682.0f;
        this.mDispScaleY = (float)this.mDispHeight / 438.0f;
        return this;
    }

    static {
        System.setProperty("org.xml.sax.driver", "org.xmlpull.v1.sax2.Driver");
    }

    public class XmlContentHandler
    extends DefaultHandler {
        private static final String TRUE_STRING = "true";
        public Danmakus result = null;
        public BaseDanmaku item = null;
        public boolean completed = false;
        public int index = 0;

        public Danmakus getResult() {
            return this.result;
        }

        @Override
        public void startDocument() throws SAXException {
            this.result = new Danmakus();
        }

        @Override
        public void endDocument() throws SAXException {
            this.completed = true;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String pValue;
            String[] values;
            String tagName = localName.length() != 0 ? localName : qName;
            if ((tagName = tagName.toLowerCase(Locale.getDefault()).trim()).equals("d") && (values = (pValue = attributes.getValue("p")).split(",")).length > 0) {
                long time = (long)(Float.parseFloat(values[0]) * 1000.0f);
                int type = Integer.parseInt(values[1]);
                float textSize = Float.parseFloat(values[2]);
                int color = Integer.parseInt(values[3]) | 0xFF000000;
                this.item = ((BiliDanmukuParser)BiliDanmukuParser.this).mContext.mDanmakuFactory.createDanmaku(type, BiliDanmukuParser.this.mContext);
                if (this.item != null) {
                    this.item.setTime(time);
                    this.item.textSize = textSize * (BiliDanmukuParser.this.mDispDensity - 0.6f);
                    this.item.textColor = color;
                    this.item.textShadowColor = color <= -16777216 ? -1 : -16777216;
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.item != null) {
                if (this.item.duration != null) {
                    String tagName;
                    String string = tagName = localName.length() != 0 ? localName : qName;
                    if (tagName.equalsIgnoreCase("d")) {
                        this.item.setTimer(BiliDanmukuParser.this.mTimer);
                        this.result.addItem(this.item);
                    }
                }
                this.item = null;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.item != null) {
                DanmakuUtils.fillText(this.item, this.decodeXmlString(new String(ch, start, length)));
                this.item.index = this.index++;
                String text = String.valueOf(this.item.text).trim();
                if (this.item.getType() == 7 && text.startsWith("[") && text.endsWith("]")) {
                    String motionPathString;
                    String[] pointStrArray;
                    long alphaDuraion;
                    int beginAlpha;
                    String[] textArr = null;
                    try {
                        JSONArray jsonArray = new JSONArray(text);
                        textArr = new String[jsonArray.length()];
                        for (int i = 0; i < textArr.length; ++i) {
                            textArr[i] = jsonArray.getString(i);
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    if (textArr == null || textArr.length < 5) {
                        this.item = null;
                        return;
                    }
                    this.item.text = textArr[4];
                    float beginX = Float.parseFloat(textArr[0]);
                    float beginY = Float.parseFloat(textArr[1]);
                    float endX = beginX;
                    float endY = beginY;
                    String[] alphaArr = textArr[2].split("-");
                    int endAlpha = beginAlpha = (int)((float)AlphaValue.MAX * Float.parseFloat(alphaArr[0]));
                    if (alphaArr.length > 1) {
                        endAlpha = (int)((float)AlphaValue.MAX * Float.parseFloat(alphaArr[1]));
                    }
                    long translationDuration = alphaDuraion = (long)(Float.parseFloat(textArr[3]) * 1000.0f);
                    long translationStartDelay = 0L;
                    float rotateY = 0.0f;
                    float rotateZ = 0.0f;
                    if (textArr.length >= 7) {
                        rotateZ = Float.parseFloat(textArr[5]);
                        rotateY = Float.parseFloat(textArr[6]);
                    }
                    if (textArr.length >= 11) {
                        endX = Float.parseFloat(textArr[7]);
                        endY = Float.parseFloat(textArr[8]);
                        if (!"".equals(textArr[9])) {
                            translationDuration = Integer.parseInt(textArr[9]);
                        }
                        if (!"".equals(textArr[10])) {
                            translationStartDelay = (long)Float.parseFloat(textArr[10]);
                        }
                    }
                    if (BiliDanmukuParser.this.isPercentageNumber(beginX)) {
                        beginX *= 682.0f;
                    }
                    if (BiliDanmukuParser.this.isPercentageNumber(beginY)) {
                        beginY *= 438.0f;
                    }
                    if (BiliDanmukuParser.this.isPercentageNumber(endX)) {
                        endX *= 682.0f;
                    }
                    if (BiliDanmukuParser.this.isPercentageNumber(endY)) {
                        endY *= 438.0f;
                    }
                    this.item.duration = new Duration(alphaDuraion);
                    this.item.rotationZ = rotateZ;
                    this.item.rotationY = rotateY;
                    ((BiliDanmukuParser)BiliDanmukuParser.this).mContext.mDanmakuFactory.fillTranslationData(this.item, beginX, beginY, endX, endY, translationDuration, translationStartDelay, BiliDanmukuParser.this.mDispScaleX, BiliDanmukuParser.this.mDispScaleY);
                    ((BiliDanmukuParser)BiliDanmukuParser.this).mContext.mDanmakuFactory.fillAlphaData(this.item, beginAlpha, endAlpha, alphaDuraion);
                    if (textArr.length >= 12 && !TextUtils.isEmpty((CharSequence)textArr[11]) && TRUE_STRING.equals(textArr[11])) {
                        this.item.textShadowColor = 0;
                    }
                    if (textArr.length >= 13) {
                        // empty if block
                    }
                    if (textArr.length >= 14) {
                        // empty if block
                    }
                    if (textArr.length >= 15 && !"".equals(textArr[14]) && (pointStrArray = (motionPathString = textArr[14].substring(1)).split("L")) != null && pointStrArray.length > 0) {
                        float[][] points = new float[pointStrArray.length][2];
                        for (int i = 0; i < pointStrArray.length; ++i) {
                            String[] pointArray = pointStrArray[i].split(",");
                            points[i][0] = Float.parseFloat(pointArray[0]);
                            points[i][1] = Float.parseFloat(pointArray[1]);
                        }
                        DanmakuFactory cfr_ignored_0 = ((BiliDanmukuParser)BiliDanmukuParser.this).mContext.mDanmakuFactory;
                        DanmakuFactory.fillLinePathData(this.item, points, BiliDanmukuParser.this.mDispScaleX, BiliDanmukuParser.this.mDispScaleY);
                    }
                }
            }
        }

        private String decodeXmlString(String title) {
            if (title.contains("&amp;")) {
                title = title.replace("&amp;", "&");
            }
            if (title.contains("&quot;")) {
                title = title.replace("&quot;", "\"");
            }
            if (title.contains("&gt;")) {
                title = title.replace("&gt;", ">");
            }
            if (title.contains("&lt;")) {
                title = title.replace("&lt;", "<");
            }
            return title;
        }
    }
}

