/*
 * Decompiled with CFR 0.152.
 */
package com.github.cthawanapong.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.support.v7.widget.AppCompatTextView;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import com.github.cthawanapong.manager.TypeFaceManager;
import com.github.cthawanapong.styleableviews.R;

public class StyleableTextView
extends AppCompatTextView {
    private static final String TAG = StyleableTextView.class.getSimpleName();

    public StyleableTextView(Context context) {
        super(context);
        if (this.isInEditMode()) {
            return;
        }
        this.initInstance(context, null);
    }

    public StyleableTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (this.isInEditMode()) {
            return;
        }
        this.initInstance(context, attrs);
    }

    public StyleableTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (this.isInEditMode()) {
            return;
        }
        this.initInstance(context, attrs);
    }

    private void initInstance(Context context, AttributeSet attrs) {
        TypedArray ta;
        if (attrs != null && (ta = context.obtainStyledAttributes(attrs, R.styleable.StyleableTextView)) != null) {
            String fontAsset = ta.getString(R.styleable.StyleableEditText_typeFaceAsset);
            if (!TextUtils.isEmpty((CharSequence)fontAsset)) {
                fontAsset = "fonts/" + fontAsset;
                Typeface tf = TypeFaceManager.getInstance().getFont(fontAsset);
                int style = 0;
                if (this.getTypeface() != null) {
                    style = this.getTypeface().getStyle();
                }
                if (tf != null) {
                    this.setTypeface(tf, style);
                } else {
                    Log.d((String)TAG, (String)String.format("Could not create a font from asset: %s", fontAsset));
                }
            }
            ta.recycle();
        }
    }
}

