/*
 * Decompiled with CFR 0.152.
 */
package apijson.framework;

import apijson.JSON;
import apijson.JSONObject;
import apijson.JSONResponse;
import apijson.Log;
import apijson.NotNull;
import apijson.RequestMethod;
import apijson.StringUtil;
import apijson.column.ColumnUtil;
import apijson.framework.APIJSONConstant;
import apijson.framework.APIJSONCreator;
import apijson.framework.APIJSONParser;
import apijson.framework.APIJSONSQLConfig;
import apijson.framework.AssertUtil;
import apijson.orm.AbstractSQLConfig;
import apijson.orm.AbstractVerifier;
import apijson.orm.Entry;
import apijson.orm.JSONRequest;
import apijson.orm.Pair;
import apijson.orm.Visitor;
import com.alibaba.fastjson.JSONArray;
import jakarta.servlet.http.HttpSession;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class APIJSONVerifier<T>
extends AbstractVerifier<T> {
    public static final String TAG = "APIJSONVerifier";
    public static boolean ENABLE_VERIFY_COLUMN = true;
    public static APIJSONCreator<? extends Object> APIJSON_CREATOR = new APIJSONCreator();
    static final String requestConfig = "{\"Comment\":{\"REFUSE\": \"id\", \"MUST\": \"userId,momentId,content\"}, \"INSERT\":{\"@role\":\"OWNER\"}}";
    static final String responseConfig = "{\"User\":{\"REMOVE\": \"phone\", \"REPLACE\":{\"sex\":2}, \"INSERT\":{\"name\":\"api\"}, \"UPDATE\":{\"verifyURLList-()\":\"verifyURLList(pictureList)\"}}}";

    public static com.alibaba.fastjson.JSONObject init() throws ServerException {
        return APIJSONVerifier.init(false);
    }

    public static com.alibaba.fastjson.JSONObject init(boolean shutdownWhenServerError) throws ServerException {
        return APIJSONVerifier.init(shutdownWhenServerError, null);
    }

    public static <T> com.alibaba.fastjson.JSONObject init(APIJSONCreator<T> creator) throws ServerException {
        return APIJSONVerifier.init(false, creator);
    }

    public static <T> com.alibaba.fastjson.JSONObject init(boolean shutdownWhenServerError, APIJSONCreator<T> creator) throws ServerException {
        com.alibaba.fastjson.JSONObject result = new com.alibaba.fastjson.JSONObject(true);
        if (ENABLE_VERIFY_ROLE) {
            result.put(APIJSONConstant.ACCESS_, (Object)APIJSONVerifier.initAccess(shutdownWhenServerError, creator));
        }
        if (ENABLE_VERIFY_CONTENT) {
            result.put(APIJSONConstant.REQUEST_, (Object)APIJSONVerifier.initRequest(shutdownWhenServerError, creator));
        }
        return result;
    }

    public static com.alibaba.fastjson.JSONObject initAccess() throws ServerException {
        return APIJSONVerifier.initAccess(false);
    }

    public static com.alibaba.fastjson.JSONObject initAccess(boolean shutdownWhenServerError) throws ServerException {
        return APIJSONVerifier.initAccess(shutdownWhenServerError, null);
    }

    public static <T> com.alibaba.fastjson.JSONObject initAccess(APIJSONCreator<T> creator) throws ServerException {
        return APIJSONVerifier.initAccess(false, creator);
    }

    public static <T> com.alibaba.fastjson.JSONObject initAccess(boolean shutdownWhenServerError, APIJSONCreator<T> creator) throws ServerException {
        return APIJSONVerifier.initAccess(shutdownWhenServerError, creator, null);
    }

    public static <T> com.alibaba.fastjson.JSONObject initAccess(boolean shutdownWhenServerError, APIJSONCreator<T> creator, com.alibaba.fastjson.JSONObject table) throws ServerException {
        JSONArray list;
        int size;
        com.alibaba.fastjson.JSONObject access;
        if (creator == null) {
            creator = APIJSON_CREATOR;
        }
        APIJSON_CREATOR = creator;
        boolean isAll = table == null || table.isEmpty();
        Object object = access = isAll ? new JSONRequest() : table;
        if (!Log.DEBUG) {
            access.put(APIJSONConstant.KEY_DEBUG, (Object)0);
        }
        JSONRequest accessItem = new JSONRequest();
        accessItem.put(APIJSONConstant.ACCESS_, (Object)access);
        JSONRequest request = new JSONRequest();
        request.putAll((Map)accessItem.toArray(0, 0, APIJSONConstant.ACCESS_));
        com.alibaba.fastjson.JSONObject response = creator.createParser().setMethod(RequestMethod.GET).setNeedVerify(false).parseResponse((com.alibaba.fastjson.JSONObject)request);
        if (!JSONResponse.isSuccess((com.alibaba.fastjson.JSONObject)response)) {
            Log.e((String)TAG, (String)("\n\n\n\n\n !!!! \u67e5\u8be2\u6743\u9650\u914d\u7f6e\u5f02\u5e38 !!!\n" + response.getString(JSONResponse.KEY_MSG) + "\n\n\n\n\n"));
            APIJSONVerifier.onServerError("\u67e5\u8be2\u6743\u9650\u914d\u7f6e\u5f02\u5e38 !", shutdownWhenServerError);
        }
        int n = size = (list = response.getJSONArray(APIJSONConstant.ACCESS_ + "[]")) == null ? 0 : list.size();
        if (isAll && size <= 0) {
            Log.w((String)TAG, (String)"initAccess isAll && size <= 0\uff0c\uff0c\u6ca1\u6709\u53ef\u7528\u7684\u6743\u9650\u914d\u7f6e");
            return response;
        }
        Log.d((String)TAG, (String)("initAccess < for ACCESS_MAP.size() = " + ACCESS_MAP.size() + " <<<<<<<<<<<<<<<<<<<<<<<<"));
        LinkedHashMap newMap = new LinkedHashMap();
        LinkedHashMap fakeDeleteMap = new LinkedHashMap();
        LinkedHashMap<String, String> newTKMap = new LinkedHashMap<String, String>();
        TreeMap versionedTableColumnMap = new TreeMap(ColumnUtil.DESC_COMPARATOR);
        TreeMap versionedKeyColumnMap = new TreeMap(ColumnUtil.DESC_COMPARATOR);
        for (int i = 0; i < size; ++i) {
            Set set;
            com.alibaba.fastjson.JSONObject item = list.getJSONObject(i);
            if (item == null) continue;
            HashMap<RequestMethod, String[]> map = new HashMap<RequestMethod, String[]>();
            map.put(RequestMethod.GET, (String[])JSON.parseObject((String)item.getString("get"), String[].class));
            map.put(RequestMethod.HEAD, (String[])JSON.parseObject((String)item.getString("head"), String[].class));
            map.put(RequestMethod.GETS, (String[])JSON.parseObject((String)item.getString("gets"), String[].class));
            map.put(RequestMethod.HEADS, (String[])JSON.parseObject((String)item.getString("heads"), String[].class));
            map.put(RequestMethod.POST, (String[])JSON.parseObject((String)item.getString("post"), String[].class));
            map.put(RequestMethod.PUT, (String[])JSON.parseObject((String)item.getString("put"), String[].class));
            map.put(RequestMethod.DELETE, (String[])JSON.parseObject((String)item.getString("delete"), String[].class));
            String name = item.getString("name");
            String alias = item.getString("alias");
            HashMap<String, Object> fakemap = new HashMap<String, Object>();
            String deletedKey = item.getString(AbstractSQLConfig.KEY_DELETED_KEY);
            if (StringUtil.isNotEmpty((String)deletedKey, (boolean)true)) {
                boolean containNotDeletedValue = item.containsKey((Object)AbstractSQLConfig.KEY_NOT_DELETED_VALUE);
                String deletedValue = item.getString(AbstractSQLConfig.KEY_DELETED_VALUE);
                if (!containNotDeletedValue && StringUtil.isEmpty((Object)deletedValue, (boolean)true)) {
                    APIJSONVerifier.onServerError("Access\u8868 id = " + item.getString("id") + " \u5bf9\u5e94\u7684 " + AbstractSQLConfig.KEY_DELETED_VALUE + " \u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01\u6216\u8005\u5fc5\u987b\u5305\u542b\u5b57\u6bb5 " + AbstractSQLConfig.KEY_NOT_DELETED_VALUE + " \uff01", shutdownWhenServerError);
                }
                fakemap.put(AbstractSQLConfig.KEY_DELETED_KEY, deletedKey);
                fakemap.put(AbstractSQLConfig.KEY_DELETED_VALUE, deletedValue);
                if (containNotDeletedValue) {
                    fakemap.put(AbstractSQLConfig.KEY_NOT_DELETED_VALUE, item.get((Object)AbstractSQLConfig.KEY_NOT_DELETED_VALUE));
                }
            }
            if (StringUtil.isEmpty((String)name, (boolean)true)) {
                APIJSONVerifier.onServerError("\u5b57\u6bb5 name \u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01", shutdownWhenServerError);
            }
            if (StringUtil.isEmpty((String)alias, (boolean)true)) {
                if (!JSONRequest.isTableKey((String)name)) {
                    APIJSONVerifier.onServerError("name: " + name + "\u4e0d\u5408\u6cd5\uff01\u5b57\u6bb5 alias \u7684\u503c\u4e3a\u7a7a\u65f6\uff0cname \u5fc5\u987b\u4e3a\u5408\u6cd5\u8868\u540d\uff01", shutdownWhenServerError);
                }
                alias = name;
            } else if (!JSONRequest.isTableKey((String)alias)) {
                APIJSONVerifier.onServerError("alias: " + alias + "\u4e0d\u5408\u6cd5\uff01\u5b57\u6bb5 alias \u7684\u503c\u53ea\u80fd\u4e3a \u7a7a \u6216\u8005 \u5408\u6cd5\u8868\u540d\uff01", shutdownWhenServerError);
            }
            newMap.put(alias, map);
            fakeDeleteMap.put(alias, fakemap);
            newTKMap.put(alias, name);
            if (!ENABLE_VERIFY_COLUMN) continue;
            com.alibaba.fastjson.JSONObject columns = item.getJSONObject("columns");
            Set set2 = set = columns == null ? null : columns.entrySet();
            if (set == null) continue;
            for (Map.Entry entry : set) {
                Object val;
                Integer version = entry == null ? null : Integer.valueOf((String)entry.getKey());
                Object v3 = val = version == null ? null : entry.getValue();
                if (val == null) continue;
                LinkedHashMap kcm = new LinkedHashMap();
                LinkedHashMap<String, String> cm = new LinkedHashMap<String, String>();
                String[] cs = StringUtil.split((String)String.valueOf(val));
                ArrayList<String> l = new ArrayList<String>();
                for (int j = 0; j < cs.length; ++j) {
                    String v;
                    String s = cs[j];
                    Entry ety = Pair.parseEntry((String)s, (boolean)true);
                    String k = ety == null ? null : (String)ety.getKey();
                    String string = v = ety == null ? null : (String)ety.getValue();
                    if (!StringUtil.isName((String)k) || v != null && !StringUtil.isName((String)v)) {
                        throw new IllegalArgumentException("\u540e\u7aef Access \u8868\u4e2d name: " + name + " \u5bf9\u5e94 columns \u5b57\u6bb5\u7684\u503c " + version + ":value \u4e2d\u7b2c " + j + " \u4e2a\u5b57\u6bb5 column:alias \u4e2d\u5b57\u7b26 " + s + " \u4e0d\u5408\u6cd5\uff01alias \u53ef\u7f3a\u7701\uff0c\u4f46 column, alias \u90fd\u5fc5\u987b\u4e3a\u5408\u6cd5\u7684\u53d8\u91cf\u540d\uff01 \uff01 \uff01ety == null || StringUtil.isName(ety.getKey()) == false  || (ety.getValue() != null && StringUtil.isName(ety.getValue()) == false)");
                    }
                    l.add(k);
                    cm.put(v == null ? k : v, k);
                }
                LinkedHashMap<String, ArrayList<String>> m = new LinkedHashMap<String, ArrayList<String>>();
                m.put(alias, l);
                versionedTableColumnMap.put(version, m);
                kcm.put(alias, cm);
                versionedKeyColumnMap.put(version, kcm);
            }
        }
        if (isAll) {
            ACCESS_MAP = newMap;
            ACCESS_FAKE_DELETE_MAP = fakeDeleteMap;
            APIJSONSQLConfig.TABLE_KEY_MAP = newTKMap;
        } else {
            ACCESS_MAP.putAll(newMap);
            ACCESS_FAKE_DELETE_MAP.putAll(fakeDeleteMap);
            APIJSONSQLConfig.TABLE_KEY_MAP.putAll(newTKMap);
        }
        if (ENABLE_VERIFY_COLUMN) {
            if (isAll) {
                ColumnUtil.VERSIONED_TABLE_COLUMN_MAP = versionedTableColumnMap;
                ColumnUtil.VERSIONED_KEY_COLUMN_MAP = versionedKeyColumnMap;
            } else {
                ColumnUtil.VERSIONED_TABLE_COLUMN_MAP.putAll(versionedTableColumnMap);
                ColumnUtil.VERSIONED_KEY_COLUMN_MAP.putAll(versionedKeyColumnMap);
            }
            ColumnUtil.init();
        }
        Log.d((String)TAG, (String)("initAccess  for /> ACCESS_MAP.size() = " + ACCESS_MAP.size() + " >>>>>>>>>>>>>>>>>>>>>>>"));
        return response;
    }

    public static com.alibaba.fastjson.JSONObject initRequest() throws ServerException {
        return APIJSONVerifier.initRequest(false);
    }

    public static com.alibaba.fastjson.JSONObject initRequest(boolean shutdownWhenServerError) throws ServerException {
        return APIJSONVerifier.initRequest(shutdownWhenServerError, null);
    }

    public static <T> com.alibaba.fastjson.JSONObject initRequest(APIJSONCreator<T> creator) throws ServerException {
        return APIJSONVerifier.initRequest(false, creator);
    }

    public static <T> com.alibaba.fastjson.JSONObject initRequest(boolean shutdownWhenServerError, APIJSONCreator<T> creator) throws ServerException {
        return APIJSONVerifier.initRequest(shutdownWhenServerError, creator, null);
    }

    public static <T> com.alibaba.fastjson.JSONObject initRequest(boolean shutdownWhenServerError, APIJSONCreator<T> creator, com.alibaba.fastjson.JSONObject table) throws ServerException {
        JSONArray list;
        int size;
        com.alibaba.fastjson.JSONObject requestTable;
        if (creator == null) {
            creator = APIJSON_CREATOR;
        }
        APIJSON_CREATOR = creator;
        boolean isAll = table == null || table.isEmpty();
        Object object = requestTable = isAll ? new JSONRequest().setOrder("version-,id+") : table;
        if (!Log.DEBUG) {
            requestTable.put(APIJSONConstant.KEY_DEBUG, (Object)0);
        }
        JSONRequest requestItem = new JSONRequest();
        requestItem.put(APIJSONConstant.REQUEST_, (Object)requestTable);
        JSONRequest request = new JSONRequest();
        request.putAll((Map)requestItem.toArray(0, 0, APIJSONConstant.REQUEST_));
        com.alibaba.fastjson.JSONObject response = creator.createParser().setMethod(RequestMethod.GET).setNeedVerify(false).parseResponse((com.alibaba.fastjson.JSONObject)request);
        if (!JSONResponse.isSuccess((com.alibaba.fastjson.JSONObject)response)) {
            Log.e((String)TAG, (String)("\n\n\n\n\n !!!! \u67e5\u8be2\u8bf7\u6c42\u6821\u9a8c\u89c4\u5219\u914d\u7f6e\u5f02\u5e38 !!!\n" + response.getString(JSONResponse.KEY_MSG) + "\n\n\n\n\n"));
            APIJSONVerifier.onServerError("\u67e5\u8be2\u8bf7\u6c42\u6821\u9a8c\u89c4\u5219\u914d\u7f6e\u5f02\u5e38 !", shutdownWhenServerError);
        }
        int n = size = (list = response.getJSONArray(APIJSONConstant.REQUEST_ + "[]")) == null ? 0 : list.size();
        if (isAll && size <= 0) {
            Log.w((String)TAG, (String)"initRequest isAll && size <= 0\uff0c\u6ca1\u6709\u53ef\u7528\u7684\u8bf7\u6c42\u6821\u9a8c\u89c4\u5219\u914d\u7f6e");
            return response;
        }
        Log.d((String)TAG, (String)("initRequest < for REQUEST_MAP.size() = " + REQUEST_MAP.size() + " <<<<<<<<<<<<<<<<<<<<<<<<"));
        LinkedHashMap<String, TreeMap<Integer, com.alibaba.fastjson.JSONObject>> newMap = new LinkedHashMap<String, TreeMap<Integer, com.alibaba.fastjson.JSONObject>>();
        for (int i = 0; i < size; ++i) {
            String cacheKey;
            TreeMap<Integer, com.alibaba.fastjson.JSONObject> versionedMap;
            String tag;
            String method;
            com.alibaba.fastjson.JSONObject item = list.getJSONObject(i);
            if (item == null) continue;
            String version = item.getString("version");
            if (StringUtil.isEmpty((String)version, (boolean)true)) {
                Log.e((String)TAG, (String)"initRequest  for  StringUtil.isEmpty(version, true)\uff0cRequest \u8868\u4e2d\u7684 version \u4e0d\u80fd\u4e3a\u7a7a\uff01");
                APIJSONVerifier.onServerError("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff0cRequest \u8868\u4e2d\u7684 version \u4e0d\u80fd\u4e3a\u7a7a\uff01", shutdownWhenServerError);
            }
            if (StringUtil.isEmpty((String)(method = item.getString("method")), (boolean)true)) {
                Log.e((String)TAG, (String)"initRequest  for  StringUtil.isEmpty(method, true)\uff0cRequest \u8868\u4e2d\u7684 method \u4e0d\u80fd\u4e3a\u7a7a\uff01");
                APIJSONVerifier.onServerError("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff0cRequest \u8868\u4e2d\u7684 method \u4e0d\u80fd\u4e3a\u7a7a\uff01", shutdownWhenServerError);
            }
            if (StringUtil.isEmpty((String)(tag = item.getString("tag")), (boolean)true)) {
                Log.e((String)TAG, (String)"initRequest  for  StringUtil.isEmpty(tag, true)\uff0cRequest \u8868\u4e2d\u7684 tag \u4e0d\u80fd\u4e3a\u7a7a\uff01");
                APIJSONVerifier.onServerError("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff0cRequest \u8868\u4e2d\u7684 tag \u4e0d\u80fd\u4e3a\u7a7a\uff01", shutdownWhenServerError);
            }
            com.alibaba.fastjson.JSONObject structure = JSON.parseObject((String)item.getString("structure"));
            com.alibaba.fastjson.JSONObject target = null;
            if (structure != null) {
                target = structure;
                if (!structure.containsKey((Object)tag)) {
                    String key;
                    boolean isArrayKey = tag.endsWith(":[]");
                    String string = key = isArrayKey ? tag.substring(0, tag.length() - 3) : tag;
                    if (JSONObject.isTableKey((String)key)) {
                        if (isArrayKey) {
                            target.put(key + "[]", (Object)new JSONArray());
                        } else {
                            target = new com.alibaba.fastjson.JSONObject(true);
                            target.put(tag, (Object)structure);
                        }
                    }
                }
            }
            if (target == null || target.isEmpty()) {
                Log.e((String)TAG, (String)"initRequest  for  target == null || target.isEmpty()");
                APIJSONVerifier.onServerError("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff0cRequest \u8868\u4e2d\u7684 version = " + version + ", method = " + method + ", tag = " + tag + " \u5bf9\u5e94\u7684 structure \u4e0d\u80fd\u4e3a\u7a7a\uff01", shutdownWhenServerError);
            }
            if ((versionedMap = (TreeMap<Integer, com.alibaba.fastjson.JSONObject>)newMap.get(cacheKey = APIJSONVerifier.getCacheKeyForRequest((String)method, (String)tag))) == null) {
                versionedMap = new TreeMap<Integer, com.alibaba.fastjson.JSONObject>(new Comparator<Integer>(){

                    @Override
                    public int compare(Integer o1, Integer o2) {
                        return o2 == null ? -1 : o2.compareTo(o1);
                    }
                });
            }
            versionedMap.put(Integer.valueOf(version), item);
            newMap.put(cacheKey, versionedMap);
        }
        if (isAll) {
            REQUEST_MAP = newMap;
        } else {
            REQUEST_MAP.putAll(newMap);
        }
        Log.d((String)TAG, (String)("initRequest  for /> REQUEST_MAP.size() = " + REQUEST_MAP.size() + " >>>>>>>>>>>>>>>>>>>>>>>"));
        return response;
    }

    public static void test() throws Exception {
        APIJSONVerifier.testStructure();
    }

    public static void testStructure() throws Exception {
        com.alibaba.fastjson.JSONObject request;
        try {
            request = JSON.parseObject((String)"{\"Comment\":{\"userId\":0}}");
            Log.d((String)TAG, (String)("test  verifyRequest = " + AbstractVerifier.verifyRequest((RequestMethod)RequestMethod.POST, (String)"", (com.alibaba.fastjson.JSONObject)JSON.parseObject((String)requestConfig), (com.alibaba.fastjson.JSONObject)request, APIJSON_CREATOR)));
        }
        catch (Throwable e) {
            if (!(e instanceof IllegalArgumentException) || !"POST\u8bf7\u6c42\uff0cComment \u91cc\u9762\u4e0d\u80fd\u7f3a\u5c11 momentId \u7b49[userId,momentId,content]\u5185\u7684\u4efb\u4f55\u5b57\u6bb5\uff01".equals(e.getMessage())) {
                throw e;
            }
            Log.d((String)TAG, (String)"\u6d4b\u8bd5 Operation.MUST \u6821\u9a8c\u7f3a\u5c11\u5b57\u6bb5\uff1a\u6210\u529f");
        }
        try {
            request = JSON.parseObject((String)"{\"Comment\":{\"id\":0, \"userId\":0, \"momentId\":0, \"content\":\"apijson\"}}");
            Log.d((String)TAG, (String)("test  verifyRequest = " + AbstractVerifier.verifyRequest((RequestMethod)RequestMethod.POST, (String)"", (com.alibaba.fastjson.JSONObject)JSON.parseObject((String)requestConfig), (com.alibaba.fastjson.JSONObject)request, APIJSON_CREATOR)));
        }
        catch (Throwable e) {
            if (!(e instanceof IllegalArgumentException) || !"POST\u8bf7\u6c42\uff0c/Comment \u4e0d\u80fd\u4f20 id \uff01".equals(e.getMessage())) {
                throw e;
            }
            Log.d((String)TAG, (String)"\u6d4b\u8bd5 Operation.REFUSE \u6821\u9a8c\u4e0d\u5141\u8bb8\u4f20\u5b57\u6bb5\uff1a\u6210\u529f");
        }
        request = JSON.parseObject((String)"{\"Comment\":{\"userId\":0, \"momentId\":0, \"content\":\"apijson\"}}");
        Log.d((String)TAG, (String)("test  verifyRequest = " + AbstractVerifier.verifyRequest((RequestMethod)RequestMethod.POST, (String)"", (com.alibaba.fastjson.JSONObject)JSON.parseObject((String)requestConfig), (com.alibaba.fastjson.JSONObject)request, APIJSON_CREATOR)));
        AssertUtil.assertEqual("OWNER", request.getString("@role"));
        Log.d((String)TAG, (String)"\u6d4b\u8bd5 Operation.INSERT \u4e0d\u5b58\u5728\u5b57\u6bb5\u65f6\u63d2\u5165\uff1a\u6210\u529f");
        com.alibaba.fastjson.JSONObject response = JSON.parseObject((String)"{\"User\":{\"userId\":0}}");
        Log.d((String)TAG, (String)("test  verifyResponse = " + AbstractVerifier.verifyResponse((RequestMethod)RequestMethod.GET, (String)"", (com.alibaba.fastjson.JSONObject)JSON.parseObject((String)responseConfig), (com.alibaba.fastjson.JSONObject)response, APIJSON_CREATOR, null)));
        AssertUtil.assertEqual("verifyURLList(pictureList)", response.getJSONObject("User").getString("verifyURLList-()"));
        Log.d((String)TAG, (String)"\u6d4b\u8bd5 Operation.UPDATE \u5f3a\u5236\u63d2\u5165/\u66ff\u6362\uff1a\u6210\u529f");
        response = JSON.parseObject((String)"{\"User\":{\"userId\":0, \"phone\":\"12345678\"}}");
        Log.d((String)TAG, (String)("test  verifyResponse = " + AbstractVerifier.verifyResponse((RequestMethod)RequestMethod.GET, (String)"", (com.alibaba.fastjson.JSONObject)JSON.parseObject((String)responseConfig), (com.alibaba.fastjson.JSONObject)response, APIJSON_CREATOR, null)));
        AssertUtil.assertEqual(null, response.getJSONObject("User").get((Object)"phone"));
        Log.d((String)TAG, (String)"\u6d4b\u8bd5 Operation.REMOVE \u5f3a\u5236\u79fb\u9664\uff1a\u6210\u529f");
        response = JSON.parseObject((String)"{\"User\":{\"userId\":0, \"phone\":\"12345678\", \"sex\":1}}");
        Log.d((String)TAG, (String)("test  verifyResponse = " + AbstractVerifier.verifyResponse((RequestMethod)RequestMethod.GET, (String)"", (com.alibaba.fastjson.JSONObject)JSON.parseObject((String)responseConfig), (com.alibaba.fastjson.JSONObject)response, APIJSON_CREATOR, null)));
        AssertUtil.assertEqual("api", response.getJSONObject("User").get((Object)"name"));
        Log.d((String)TAG, (String)"\u6d4b\u8bd5 Operation.INSERT \u4e0d\u5b58\u5728\u5b57\u6bb5\u65f6\u63d2\u5165\uff1a\u6210\u529f");
        response = JSON.parseObject((String)"{\"User\":{\"id\":0, \"name\":\"tommy\", \"phone\":\"12345678\", \"sex\":1}}");
        Log.d((String)TAG, (String)("test  verifyResponse = " + AbstractVerifier.verifyResponse((RequestMethod)RequestMethod.GET, (String)"", (com.alibaba.fastjson.JSONObject)JSON.parseObject((String)responseConfig), (com.alibaba.fastjson.JSONObject)response, APIJSON_CREATOR, null)));
        AssertUtil.assertEqual(2, response.getJSONObject("User").get((Object)"sex"));
        Log.d((String)TAG, (String)"\u6d4b\u8bd5 Operation.REPLACE \u5b58\u5728\u5b57\u6bb5\u65f6\u66ff\u6362\uff1a\u6210\u529f");
    }

    protected static void onServerError(String msg, boolean shutdown) throws ServerException {
        Log.e((String)TAG, (String)("\n\u6821\u9a8c\u914d\u7f6e\u6d4b\u8bd5\u672a\u901a\u8fc7\uff01\n\u8bf7\u4fee\u6539 Access/Request \u8868\u91cc\u7684\u8bb0\u5f55\uff01\n\u4fdd\u8bc1\u6240\u6709\u914d\u7f6e\u90fd\u662f\u6b63\u786e\u7684\uff01\uff01\uff01\n\n\u539f\u56e0\uff1a\n" + msg));
        if (!shutdown) {
            throw new ServerException(msg);
        }
        System.exit(1);
    }

    @NotNull
    public APIJSONParser<T> createParser() {
        APIJSONParser parser = (APIJSONParser)APIJSON_CREATOR.createParser();
        parser.setVisitor(this.visitor);
        return parser;
    }

    public static void verifyLogin(HttpSession session) throws Exception {
        Log.d((String)TAG, (String)("verifyLogin  session.getId() = " + (session == null ? null : session.getId())));
        APIJSON_CREATOR.createVerifier().setVisitor(APIJSONVerifier.getVisitor(session)).verifyLogin();
    }

    public static <T> T getVisitorId(HttpSession session) {
        if (session == null) {
            return null;
        }
        Visitor<T> id = session.getAttribute("visitorId");
        if (id == null) {
            id = APIJSONVerifier.getVisitor(session);
            session.setAttribute("visitorId", id);
        }
        return (T)id;
    }

    public static <T> Visitor<T> getVisitor(HttpSession session) {
        return session == null ? null : (Visitor)session.getAttribute(APIJSONConstant.VISITOR_);
    }

    public String getIdKey(String database, String schema, String datasource, String table) {
        return APIJSONSQLConfig.SIMPLE_CALLBACK.getIdKey(database, schema, datasource, table);
    }

    public String getUserIdKey(String database, String schema, String datasource, String table) {
        return APIJSONSQLConfig.SIMPLE_CALLBACK.getUserIdKey(database, schema, datasource, table);
    }

    public T newId(RequestMethod method, String database, String schema, String datasource, String table) {
        return (T)APIJSONSQLConfig.SIMPLE_CALLBACK.newId(method, database, schema, datasource, table);
    }
}

