/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryonet.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.ByteBufferInput;
import com.esotericsoftware.kryo.io.ByteBufferOutput;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.FrameworkMessage;
import com.esotericsoftware.kryonet.serialization.Serialization;
import java.nio.ByteBuffer;

public class KryoSerialization
implements Serialization {
    private final Kryo kryo;
    private final ByteBufferInput input;
    private final ByteBufferOutput output;

    public KryoSerialization() {
        this(new Kryo());
        this.kryo.setReferences(false);
        this.kryo.setRegistrationRequired(true);
    }

    public KryoSerialization(Kryo kryo) {
        this.kryo = kryo;
        this.kryo.register(FrameworkMessage.RegisterTCP.class);
        this.kryo.register(FrameworkMessage.RegisterUDP.class);
        this.kryo.register(FrameworkMessage.KeepAlive.class);
        this.kryo.register(FrameworkMessage.DiscoverHost.class);
        this.kryo.register(FrameworkMessage.Ping.class);
        this.input = new ByteBufferInput();
        this.output = new ByteBufferOutput();
    }

    public Kryo getKryo() {
        return this.kryo;
    }

    @Override
    public synchronized void write(Connection connection, ByteBuffer buffer, Object object) {
        this.output.setBuffer(buffer);
        this.kryo.getContext().put((Object)"connection", (Object)connection);
        this.kryo.writeClassAndObject((Output)this.output, object);
        this.output.flush();
    }

    @Override
    public synchronized Object read(Connection connection, ByteBuffer buffer) {
        this.input.setBuffer(buffer);
        this.kryo.getContext().put((Object)"connection", (Object)connection);
        return this.kryo.readClassAndObject((Input)this.input);
    }

    @Override
    public void writeLength(ByteBuffer buffer, int length) {
        buffer.putInt(length);
    }

    @Override
    public int readLength(ByteBuffer buffer) {
        return buffer.getInt();
    }

    @Override
    public int getLengthLength() {
        return 4;
    }
}

