/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryonet.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.ByteBufferInput;
import com.esotericsoftware.kryo.io.ByteBufferOutput;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.FrameworkMessage;
import com.esotericsoftware.kryonet.serialization.Serialization;
import com.esotericsoftware.kryonet.serialization.SerializationFactory;
import java.nio.ByteBuffer;

public class KryoSerializationFactory
implements SerializationFactory {
    private Kryo kryo;

    public KryoSerializationFactory() {
        this(new Kryo());
    }

    public KryoSerializationFactory(Kryo kryo) {
        this.kryo = kryo;
        this.kryo.register(FrameworkMessage.RegisterTCP.class);
        this.kryo.register(FrameworkMessage.RegisterUDP.class);
        this.kryo.register(FrameworkMessage.KeepAlive.class);
        this.kryo.register(FrameworkMessage.DiscoverHost.class);
        this.kryo.register(FrameworkMessage.Ping.class);
    }

    public Kryo getKryo() {
        return this.kryo;
    }

    @Override
    public Serialization newInstance(Connection connection) {
        return new KryoSerialization(connection, this.kryo);
    }

    public class KryoSerialization
    implements Serialization {
        private final Kryo kryo;
        private final ByteBufferInput input;
        private final ByteBufferOutput output;

        public KryoSerialization(Connection connection, Kryo kryo) {
            this(kryo);
            kryo.setReferences(false);
            kryo.setRegistrationRequired(true);
            kryo.getContext().put((Object)"connection", (Object)connection);
        }

        public KryoSerialization(Kryo kryo) {
            this.kryo = kryo;
            this.input = new ByteBufferInput();
            this.output = new ByteBufferOutput();
        }

        public Kryo getKryo() {
            return this.kryo;
        }

        @Override
        public synchronized void write(ByteBuffer buffer, Object object) {
            this.output.setBuffer(buffer);
            this.kryo.writeClassAndObject((Output)this.output, object);
            this.output.flush();
        }

        @Override
        public synchronized Object read(ByteBuffer buffer) {
            this.input.setBuffer(buffer);
            return this.kryo.readClassAndObject((Input)this.input);
        }

        @Override
        public void writeLength(ByteBuffer buffer, int length) {
            buffer.putInt(length);
        }

        @Override
        public int readLength(ByteBuffer buffer) {
            return buffer.getInt();
        }

        @Override
        public int getLengthLength() {
            return 4;
        }
    }
}

