/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryonet;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryonet.ClientDiscoveryHandler;
import com.esotericsoftware.kryonet.Connection;
import com.esotericsoftware.kryonet.EndPoint;
import com.esotericsoftware.kryonet.FrameworkMessage;
import com.esotericsoftware.kryonet.KryoNetException;
import com.esotericsoftware.kryonet.Listener;
import com.esotericsoftware.kryonet.UdpConnection;
import com.esotericsoftware.kryonet.serialization.KryoSerializationFactory;
import com.esotericsoftware.kryonet.serialization.Serialization;
import com.esotericsoftware.kryonet.serialization.SerializationFactory;
import com.esotericsoftware.minlog.Log;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Client
extends Connection
implements EndPoint {
    private final Serialization serialization;
    private Selector selector;
    private int emptySelects;
    private volatile boolean tcpRegistered;
    private volatile boolean udpRegistered;
    private Object tcpRegistrationLock = new Object();
    private Object udpRegistrationLock = new Object();
    private volatile boolean shutdown;
    private final Object updateLock = new Object();
    private Thread updateThread;
    private int connectTimeout;
    private InetAddress connectHost;
    private int connectTcpPort;
    private int connectUdpPort;
    private boolean isClosed;
    private ClientDiscoveryHandler discoveryHandler;

    public Client() {
        this(8192, 2048);
    }

    public Client(int writeBufferSize, int objectBufferSize) {
        this(writeBufferSize, objectBufferSize, new KryoSerializationFactory());
    }

    public Client(int writeBufferSize, int objectBufferSize, SerializationFactory serializationFactory) {
        this.endPoint = this;
        this.serialization = serializationFactory.newInstance(this);
        this.discoveryHandler = ClientDiscoveryHandler.DEFAULT;
        this.initialize(this.serialization, writeBufferSize, objectBufferSize);
        try {
            this.selector = Selector.open();
        }
        catch (IOException ex) {
            throw new RuntimeException("Error opening selector.", ex);
        }
    }

    public void setDiscoveryHandler(ClientDiscoveryHandler newDiscoveryHandler) {
        this.discoveryHandler = newDiscoveryHandler;
    }

    @Override
    public Kryo getKryo() {
        return ((KryoSerializationFactory.KryoSerialization)this.serialization).getKryo();
    }

    public void connect(int timeout, String host, int tcpPort) throws IOException {
        this.connect(timeout, InetAddress.getByName(host), tcpPort, -1);
    }

    public void connect(int timeout, String host, int tcpPort, int udpPort) throws IOException {
        this.connect(timeout, InetAddress.getByName(host), tcpPort, udpPort);
    }

    public void connect(int timeout, InetAddress host, int tcpPort) throws IOException {
        this.connect(timeout, host, tcpPort, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void connect(int timeout, InetAddress host, int tcpPort, int udpPort) throws IOException {
        if (host == null) {
            throw new IllegalArgumentException("host cannot be null.");
        }
        if (Thread.currentThread() == this.getUpdateThread()) {
            throw new IllegalStateException("Cannot connect on the connection's update thread.");
        }
        this.connectTimeout = timeout;
        this.connectHost = host;
        this.connectTcpPort = tcpPort;
        this.connectUdpPort = udpPort;
        this.close();
        if (Log.INFO) {
            if (udpPort != -1) {
                Log.info((String)"kryonet", (String)("Connecting: " + host + ":" + tcpPort + "/" + udpPort));
            } else {
                Log.info((String)"kryonet", (String)("Connecting: " + host + ":" + tcpPort));
            }
        }
        this.id = -1;
        try {
            long endTime;
            if (udpPort != -1) {
                this.udp = new UdpConnection(this.serialization, this.tcp.readBuffer.capacity());
            }
            Object object = this.updateLock;
            synchronized (object) {
                this.tcpRegistered = false;
                this.selector.wakeup();
                endTime = System.currentTimeMillis() + (long)timeout;
                this.tcp.connect(this.selector, new InetSocketAddress(host, tcpPort), 5000);
            }
            object = this.tcpRegistrationLock;
            synchronized (object) {
                while (!this.tcpRegistered && System.currentTimeMillis() < endTime) {
                    try {
                        this.tcpRegistrationLock.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!this.tcpRegistered) {
                    throw new SocketTimeoutException("Connected, but timed out during TCP registration.\nNote: Client#update must be called in a separate thread during connect.");
                }
            }
            if (udpPort == -1) return;
            InetSocketAddress udpAddress = new InetSocketAddress(host, udpPort);
            Object object2 = this.updateLock;
            synchronized (object2) {
                this.udpRegistered = false;
                this.selector.wakeup();
                this.udp.connect(this.selector, udpAddress);
            }
            object2 = this.udpRegistrationLock;
            synchronized (object2) {
                while (!this.udpRegistered && System.currentTimeMillis() < endTime) {
                    FrameworkMessage.RegisterUDP registerUDP = new FrameworkMessage.RegisterUDP();
                    registerUDP.connectionID = this.id;
                    this.udp.send(registerUDP, udpAddress);
                    try {
                        this.udpRegistrationLock.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.udpRegistered) return;
                throw new SocketTimeoutException("Connected, but timed out during UDP registration: " + host + ":" + udpPort);
            }
        }
        catch (IOException ex) {
            this.close();
            throw ex;
        }
    }

    public void reconnect() throws IOException {
        this.reconnect(this.connectTimeout);
    }

    public void reconnect(int timeout) throws IOException {
        if (this.connectHost == null) {
            throw new IllegalStateException("This client has never been connected.");
        }
        this.connect(timeout, this.connectHost, this.connectTcpPort, this.connectUdpPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(int timeout) throws IOException {
        this.updateThread = Thread.currentThread();
        Object object = this.updateLock;
        synchronized (object) {
        }
        long startTime = System.currentTimeMillis();
        int select = 0;
        select = timeout > 0 ? this.selector.select(timeout) : this.selector.selectNow();
        if (select == 0) {
            ++this.emptySelects;
            if (this.emptySelects == 100) {
                this.emptySelects = 0;
                long elapsedTime = System.currentTimeMillis() - startTime;
                try {
                    if (elapsedTime < 25L) {
                        Thread.sleep(25L - elapsedTime);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            Set<SelectionKey> keys;
            this.emptySelects = 0;
            this.isClosed = false;
            Set<SelectionKey> set = keys = this.selector.selectedKeys();
            synchronized (set) {
                Iterator<SelectionKey> iter = keys.iterator();
                while (iter.hasNext()) {
                    this.keepAlive();
                    SelectionKey selectionKey = iter.next();
                    iter.remove();
                    try {
                        int ops = selectionKey.readyOps();
                        if ((ops & 1) == 1) {
                            String objectString;
                            Object object2;
                            if (selectionKey.attachment() == this.tcp) {
                                while ((object2 = this.tcp.readObject()) != null) {
                                    Object object3;
                                    if (!this.tcpRegistered) {
                                        if (!(object2 instanceof FrameworkMessage.RegisterTCP)) continue;
                                        this.id = ((FrameworkMessage.RegisterTCP)object2).connectionID;
                                        object3 = this.tcpRegistrationLock;
                                        synchronized (object3) {
                                            this.tcpRegistered = true;
                                            this.tcpRegistrationLock.notifyAll();
                                            if (Log.TRACE) {
                                                Log.trace((String)"kryonet", (String)(this + " received TCP: RegisterTCP"));
                                            }
                                            if (this.udp == null) {
                                                this.setConnected(true);
                                            }
                                        }
                                        if (this.udp != null) continue;
                                        this.notifyConnected();
                                        continue;
                                    }
                                    if (this.udp != null && !this.udpRegistered) {
                                        if (!(object2 instanceof FrameworkMessage.RegisterUDP)) continue;
                                        object3 = this.udpRegistrationLock;
                                        synchronized (object3) {
                                            this.udpRegistered = true;
                                            this.udpRegistrationLock.notifyAll();
                                            if (Log.TRACE) {
                                                Log.trace((String)"kryonet", (String)(this + " received UDP: RegisterUDP"));
                                            }
                                            if (Log.DEBUG) {
                                                Log.debug((String)"kryonet", (String)("Port " + this.udp.datagramChannel.socket().getLocalPort() + "/UDP connected to: " + this.udp.connectedAddress));
                                            }
                                            this.setConnected(true);
                                        }
                                        this.notifyConnected();
                                        continue;
                                    }
                                    if (!this.isConnected) continue;
                                    if (Log.DEBUG) {
                                        String string = objectString = object2 == null ? "null" : object2.getClass().getSimpleName();
                                        if (!(object2 instanceof FrameworkMessage)) {
                                            Log.debug((String)"kryonet", (String)(this + " received TCP: " + objectString));
                                        } else if (Log.TRACE) {
                                            Log.trace((String)"kryonet", (String)(this + " received TCP: " + objectString));
                                        }
                                    }
                                    this.notifyReceived(object2);
                                }
                            } else {
                                if (this.udp.readFromAddress() == null || (object2 = this.udp.readObject()) == null) continue;
                                if (Log.DEBUG) {
                                    objectString = object2 == null ? "null" : object2.getClass().getSimpleName();
                                    Log.debug((String)"kryonet", (String)(this + " received UDP: " + objectString));
                                }
                                this.notifyReceived(object2);
                            }
                        }
                        if ((ops & 4) != 4) continue;
                        this.tcp.writeOperation();
                    }
                    catch (CancelledKeyException cancelledKeyException) {}
                }
            }
        }
        if (this.isConnected) {
            long time = System.currentTimeMillis();
            if (this.tcp.isTimedOut(time)) {
                if (Log.DEBUG) {
                    Log.debug((String)"kryonet", (String)(this + " timed out."));
                }
                this.close();
            } else {
                this.keepAlive();
            }
            if (this.isIdle()) {
                this.notifyIdle();
            }
        }
    }

    void keepAlive() {
        if (!this.isConnected) {
            return;
        }
        long time = System.currentTimeMillis();
        if (this.tcp.needsKeepAlive(time)) {
            this.sendTCP(FrameworkMessage.keepAlive);
        }
        if (this.udp != null && this.udpRegistered && this.udp.needsKeepAlive(time)) {
            this.sendUDP(FrameworkMessage.keepAlive);
        }
    }

    @Override
    public void run() {
        if (Log.TRACE) {
            Log.trace((String)"kryonet", (String)"Client thread started.");
        }
        this.shutdown = false;
        while (!this.shutdown) {
            try {
                this.update(250);
            }
            catch (IOException ex) {
                if (Log.TRACE) {
                    if (this.isConnected) {
                        Log.trace((String)"kryonet", (String)("Unable to update connection: " + this), (Throwable)ex);
                    } else {
                        Log.trace((String)"kryonet", (String)"Unable to update connection.", (Throwable)ex);
                    }
                } else if (Log.DEBUG) {
                    if (this.isConnected) {
                        Log.debug((String)"kryonet", (String)(this + " update: " + ex.getMessage()));
                    } else {
                        Log.debug((String)"kryonet", (String)("Unable to update connection: " + ex.getMessage()));
                    }
                }
                this.close();
            }
            catch (KryoNetException ex) {
                this.lastProtocolError = ex;
                if (Log.ERROR) {
                    if (this.isConnected) {
                        Log.error((String)"kryonet", (String)("Error updating connection: " + this), (Throwable)ex);
                    } else {
                        Log.error((String)"kryonet", (String)"Error updating connection.", (Throwable)ex);
                    }
                }
                this.close();
                throw ex;
            }
        }
        if (Log.TRACE) {
            Log.trace((String)"kryonet", (String)"Client thread stopped.");
        }
    }

    @Override
    public void start() {
        if (this.updateThread != null) {
            this.shutdown = true;
            try {
                this.updateThread.join(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.updateThread = new Thread((Runnable)this, "Client");
        this.updateThread.setDaemon(true);
        this.updateThread.start();
    }

    @Override
    public void stop() {
        if (this.shutdown) {
            return;
        }
        this.close();
        if (Log.TRACE) {
            Log.trace((String)"kryonet", (String)"Client thread stopping.");
        }
        this.shutdown = true;
        this.selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        super.close();
        Object object = this.updateLock;
        synchronized (object) {
        }
        if (!this.isClosed) {
            this.isClosed = true;
            this.selector.wakeup();
        }
    }

    public void dispose() throws IOException {
        this.close();
        this.selector.close();
    }

    @Override
    public void addListener(Listener listener) {
        super.addListener(listener);
        if (Log.TRACE) {
            Log.trace((String)"kryonet", (String)"Client listener added.");
        }
    }

    @Override
    public void removeListener(Listener listener) {
        super.removeListener(listener);
        if (Log.TRACE) {
            Log.trace((String)"kryonet", (String)"Client listener removed.");
        }
    }

    public void setKeepAliveUDP(int keepAliveMillis) {
        if (this.udp == null) {
            throw new IllegalStateException("Not connected via UDP.");
        }
        this.udp.keepAliveMillis = keepAliveMillis;
    }

    @Override
    public Thread getUpdateThread() {
        return this.updateThread;
    }

    private void broadcast(int udpPort, DatagramSocket socket) throws IOException {
        ByteBuffer dataBuffer = ByteBuffer.allocate(64);
        this.serialization.write(dataBuffer, new FrameworkMessage.DiscoverHost());
        dataBuffer.flip();
        byte[] data = new byte[dataBuffer.limit()];
        dataBuffer.get(data);
        for (NetworkInterface iface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
            for (InetAddress address : Collections.list(iface.getInetAddresses())) {
                byte[] ip = address.getAddress();
                ip[3] = -1;
                try {
                    socket.send(new DatagramPacket(data, data.length, InetAddress.getByAddress(ip), udpPort));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ip[2] = -1;
                try {
                    socket.send(new DatagramPacket(data, data.length, InetAddress.getByAddress(ip), udpPort));
                }
                catch (Exception exception) {}
            }
        }
        if (Log.DEBUG) {
            Log.debug((String)"kryonet", (String)("Broadcasted host discovery on port: " + udpPort));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress discoverHost(int udpPort, int timeoutMillis) {
        DatagramSocket socket = null;
        try {
            socket = new DatagramSocket();
            this.broadcast(udpPort, socket);
            socket.setSoTimeout(timeoutMillis);
            DatagramPacket packet = this.discoveryHandler.onRequestNewDatagramPacket();
            try {
                socket.receive(packet);
            }
            catch (SocketTimeoutException ex) {
                if (Log.INFO) {
                    Log.info((String)"kryonet", (String)"Host discovery timed out.");
                }
                InetAddress inetAddress = null;
                if (socket != null) {
                    socket.close();
                }
                this.discoveryHandler.onFinally();
                return inetAddress;
            }
            if (Log.INFO) {
                Log.info((String)"kryonet", (String)("Discovered server: " + packet.getAddress()));
            }
            this.discoveryHandler.onDiscoveredHost(packet);
            InetAddress inetAddress = packet.getAddress();
            return inetAddress;
        }
        catch (IOException ex) {
            if (Log.ERROR) {
                Log.error((String)"kryonet", (String)"Host discovery failed.", (Throwable)ex);
            }
            InetAddress inetAddress = null;
            return inetAddress;
        }
        finally {
            if (socket != null) {
                socket.close();
            }
            this.discoveryHandler.onFinally();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<InetAddress> discoverHosts(int udpPort, int timeoutMillis) {
        ArrayList<InetAddress> hosts = new ArrayList<InetAddress>();
        DatagramSocket socket = null;
        try {
            socket = new DatagramSocket();
            this.broadcast(udpPort, socket);
            socket.setSoTimeout(timeoutMillis);
            while (true) {
                DatagramPacket packet = this.discoveryHandler.onRequestNewDatagramPacket();
                try {
                    socket.receive(packet);
                }
                catch (SocketTimeoutException ex) {
                    if (Log.INFO) {
                        Log.info((String)"kryonet", (String)"Host discovery timed out.");
                    }
                    ArrayList<InetAddress> arrayList = hosts;
                    if (socket != null) {
                        socket.close();
                    }
                    this.discoveryHandler.onFinally();
                    return arrayList;
                }
                if (Log.INFO) {
                    Log.info((String)"kryonet", (String)("Discovered server: " + packet.getAddress()));
                }
                this.discoveryHandler.onDiscoveredHost(packet);
                hosts.add(packet.getAddress());
                continue;
                break;
            }
        }
        catch (IOException ex) {
            if (Log.ERROR) {
                Log.error((String)"kryonet", (String)"Host discovery failed.", (Throwable)ex);
            }
            ArrayList<InetAddress> arrayList = hosts;
            return arrayList;
        }
        finally {
            if (socket != null) {
                socket.close();
            }
            this.discoveryHandler.onFinally();
        }
    }

    static {
        try {
            System.setProperty("java.net.preferIPv6Addresses", "false");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
    }
}

