/*
 * Decompiled with CFR 0.152.
 */
package one.credify.crypto;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import one.credify.crypto.Encryption;
import one.credify.crypto.EncryptionImpl;
import one.credify.crypto.Signing;
import one.credify.crypto.SigningImpl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0004J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lone/credify/crypto/KeyCreator;", "", "()V", "mPassword", "", "mPrivateKey", "mPublicKey", "createEncryptionKey", "Lone/credify/crypto/Encryption;", "createSigningKey", "Lone/credify/crypto/Signing;", "setPassword", "password", "setPrivateKey", "privateKey", "setPublicKey", "publicKey", "credify-crypto-android_release"})
public final class KeyCreator {
    private String mPrivateKey;
    private String mPublicKey;
    private String mPassword;

    @NotNull
    public final KeyCreator setPrivateKey(@NotNull String privateKey) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        this.mPrivateKey = privateKey;
        return this;
    }

    @NotNull
    public final KeyCreator setPublicKey(@NotNull String publicKey) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        this.mPublicKey = publicKey;
        return this;
    }

    @NotNull
    public final KeyCreator setPassword(@NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.mPassword = password;
        return this;
    }

    @NotNull
    public final Signing createSigningKey() {
        Signing signing;
        String privateKey = this.mPrivateKey;
        String publicKey = this.mPublicKey;
        String password = this.mPassword;
        if (privateKey != null && publicKey != null) {
            signing = SigningImpl.Companion.create(privateKey, publicKey, password);
        } else if (privateKey != null) {
            signing = SigningImpl.Companion.createWithPrivateKey(privateKey, password);
        } else {
            if (publicKey != null) {
                return SigningImpl.Companion.createWithPublicKey(publicKey, password);
            }
            signing = SigningImpl.Companion.create();
        }
        return signing;
    }

    @NotNull
    public final Encryption createEncryptionKey() {
        Encryption encryption;
        String privateKey = this.mPrivateKey;
        String publicKey = this.mPublicKey;
        String password = this.mPassword;
        if (privateKey != null && publicKey != null) {
            encryption = EncryptionImpl.Companion.create(privateKey, publicKey, password);
        } else if (privateKey != null) {
            encryption = EncryptionImpl.Companion.createWithPrivateKey(privateKey, password);
        } else {
            if (publicKey != null) {
                return EncryptionImpl.Companion.createWithPublicKey(publicKey, password);
            }
            encryption = EncryptionImpl.Companion.create();
        }
        return encryption;
    }
}

