/*
 * Decompiled with CFR 0.152.
 */
package com.crabshue.commons.validations;

import java.util.Collection;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectValidator {
    private static final Logger logger = LoggerFactory.getLogger(ObjectValidator.class);

    public <T> Collection<ConstraintViolation<T>> validate(@NonNull T object) {
        if (object == null) {
            throw new NullPointerException("object is marked @NonNull but is null");
        }
        ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
        Validator validator = validatorFactory.getValidator();
        Set ret = validator.validate(object, new Class[0]);
        logger.info("Validated [{}]. Constraints violations discovered: [{}]", object, (Object)ret);
        return ret;
    }
}

