package com.crabshue.commons.validations.path.annotations;

import java.nio.file.Files;
import java.nio.file.Path;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum PathAccessMode implements AccessModeValidator {

    READ("read mode") {
        @Override
        public Boolean canAccessInMode(Path path) {

            return Files.isReadable(path);
        }
    },

    WRITE("write mode") {
        @Override
        public Boolean canAccessInMode(Path path) {

            return Files.isWritable(path);
        }
    },

    EXEC("execute mode") {
        @Override
        public Boolean canAccessInMode(Path path) {

            return Files.isExecutable(path);
        }
    };

    private String accessMode;
}
