package com.crabshue.commons.validations.file.validators;

import java.io.File;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

import com.crabshue.commons.validations.file.annotations.AccessMode;
import com.crabshue.commons.validations.file.annotations.ValidFile;

public class FileValidator implements ConstraintValidator<ValidFile, File> {

    private AccessMode[] accessModes;

    @Override
    public void initialize(ValidFile constraintAnnotation) {
        accessModes = constraintAnnotation.accessModes();
    }

    @Override
    public boolean isValid(File file, ConstraintValidatorContext constraintValidatorContext) {

        if(file != null) {
            if (!file.exists()) {
                setErrorMessage(constraintValidatorContext, "The file '${validatedValue}' does not exist");
                return false;
            }

            if (!file.isFile()) {
                setErrorMessage(constraintValidatorContext, "'${validatedValue}' is not a file");
                return false;
            }

            for (AccessMode accessMode : accessModes) {
                if (!accessMode.canAccessInMode(file)) {
                    setErrorMessage(constraintValidatorContext, "The file '${validatedValue}' cannot be accessed in " + accessMode.getAccessMode());
                    return false;
                }
            }
        }

        return true;
    }

    private void setErrorMessage(ConstraintValidatorContext constraintValidatorContext, String message) {
        constraintValidatorContext.disableDefaultConstraintViolation();

        constraintValidatorContext
            .buildConstraintViolationWithTemplate(message)
            .addConstraintViolation();
    }
}
