package com.crabshue.commons.validations;

import java.util.Collection;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;

/**
 * Object validator.
 */
@Slf4j
public class ObjectValidator {

    /**
     * Validate an {@link Object}.
     *
     * @param object the object to validate.
     * @return the collection of {@link ConstraintViolation}.
     */
    public <T> Collection<ConstraintViolation<T>> validate(@NonNull final T object) {

        final ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
        final Validator validator = validatorFactory.getValidator();

        final Collection<ConstraintViolation<T>> ret = validator.validate(object);

        logger.info("Validated [{}]. Constraints violations discovered: [{}]", object, ret);

        return ret;
    }
}
