/*
 * Decompiled with CFR 0.152.
 */
package com.crabshue.commons.json.serialization;

import com.crabshue.commons.exceptions.SystemException;
import com.crabshue.commons.exceptions.context.CommonErrorContext;
import com.crabshue.commons.exceptions.context.ErrorContext;
import com.crabshue.commons.exceptions.context.ErrorType;
import com.crabshue.commons.file.FileSystemUtils;
import com.crabshue.commons.file.exceptions.FileErrorContext;
import com.crabshue.commons.file.exceptions.FileErrorType;
import com.crabshue.commons.json.serialization.exceptions.JsonErrorType;
import com.crabshue.commons.json.serialization.serializers.JSR310DateTimeSerializer;
import com.crabshue.commons.json.serialization.serializers.JSR310LocalDateDeserializer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import lombok.NonNull;

public class JsonSerializationUtils {
    public static String convertObjectToJsonString(@NonNull Object object) {
        if (object == null) {
            throw new NullPointerException("object is marked @NonNull but is null");
        }
        ObjectMapper mapper = JsonSerializationUtils.provideObjectMapper();
        try {
            return mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new SystemException((ErrorType)JsonErrorType.JSON_CONVERSION_ERROR, (Throwable)e).addContextValue((ErrorContext)CommonErrorContext.CAUSE, object);
        }
    }

    public static File convertObjectToJsonFile(@NonNull Object object, @NonNull File file) {
        if (object == null) {
            throw new NullPointerException("object is marked @NonNull but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked @NonNull but is null");
        }
        FileSystemUtils.retrieveOrCreateFile((File)file);
        ObjectMapper mapper = JsonSerializationUtils.provideObjectMapper();
        try {
            mapper.writeValue(file, object);
        }
        catch (IOException e) {
            throw new SystemException((ErrorType)FileErrorType.ERROR_WRITING_FILE, (Throwable)e).addContextValue((ErrorContext)CommonErrorContext.CAUSE, object).addContextValue((ErrorContext)FileErrorContext.FILE, (Object)file);
        }
        return file;
    }

    public static <T> T readJsonFileToObject(@NonNull File file, @NonNull Class<T> clazz) {
        if (file == null) {
            throw new NullPointerException("file is marked @NonNull but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked @NonNull but is null");
        }
        ObjectMapper mapper = JsonSerializationUtils.provideObjectMapper();
        try {
            return (T)mapper.readValue(file, clazz);
        }
        catch (IOException e) {
            throw new SystemException((ErrorType)JsonErrorType.JSON_PARSING_ERROR, (Throwable)e).addContextValue((ErrorContext)CommonErrorContext.CAUSE, (Object)file);
        }
    }

    public static <T> Collection<T> readJsonFileToCollection(@NonNull File file, @NonNull Class<T[]> arrayClazz) {
        if (file == null) {
            throw new NullPointerException("file is marked @NonNull but is null");
        }
        if (arrayClazz == null) {
            throw new NullPointerException("arrayClazz is marked @NonNull but is null");
        }
        ObjectMapper mapper = JsonSerializationUtils.provideObjectMapper();
        try {
            return Arrays.asList((Object[])mapper.readValue(file, arrayClazz));
        }
        catch (IOException e) {
            throw new SystemException((ErrorType)JsonErrorType.JSON_PARSING_ERROR, (Throwable)e).addContextValue((ErrorContext)CommonErrorContext.CAUSE, (Object)file);
        }
    }

    private static ObjectMapper provideObjectMapper() {
        return ObjectMapperHolder.instance;
    }

    private static class ObjectMapperHolder {
        static ObjectMapper instance = new ObjectMapper();

        private ObjectMapperHolder() {
        }

        static {
            JavaTimeModule module = new JavaTimeModule();
            module.addSerializer(OffsetDateTime.class, (JsonSerializer)JSR310DateTimeSerializer.INSTANCE);
            module.addSerializer(ZonedDateTime.class, (JsonSerializer)JSR310DateTimeSerializer.INSTANCE);
            module.addSerializer(LocalDateTime.class, (JsonSerializer)JSR310DateTimeSerializer.INSTANCE);
            module.addSerializer(Instant.class, (JsonSerializer)JSR310DateTimeSerializer.INSTANCE);
            module.addDeserializer(LocalDate.class, (JsonDeserializer)JSR310LocalDateDeserializer.INSTANCE);
            instance.registerModule((Module)module);
        }
    }
}

