/*
 * Decompiled with CFR 0.152.
 */
package com.crabshue.commons.file;

import com.crabshue.commons.exceptions.SystemException;
import com.crabshue.commons.exceptions.context.ErrorContext;
import com.crabshue.commons.exceptions.context.ErrorType;
import com.crabshue.commons.file.FileSystemUtils;
import com.crabshue.commons.file.exceptions.FileErrorContext;
import com.crabshue.commons.file.exceptions.FileErrorType;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class FileIOUtils {
    public static File writeFile(@NonNull byte[] bytes, @NonNull File outputFile) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked @NonNull but is null");
        }
        if (outputFile == null) {
            throw new NullPointerException("outputFile is marked @NonNull but is null");
        }
        try {
            FileSystemUtils.retrieveOrCreateFile(outputFile);
            FileUtils.writeByteArrayToFile((File)outputFile, (byte[])bytes);
        }
        catch (IOException e) {
            throw new SystemException((ErrorType)FileErrorType.ERROR_WRITING_FILE, "cannot write file", (Throwable)e).addContextValue((ErrorContext)FileErrorContext.FILE, (Object)outputFile);
        }
        return outputFile;
    }

    public static File writeFile(@NonNull InputStream inputStream, @NonNull File outputFile) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked @NonNull but is null");
        }
        if (outputFile == null) {
            throw new NullPointerException("outputFile is marked @NonNull but is null");
        }
        FileSystemUtils.retrieveOrCreateFile(outputFile);
        try (FileOutputStream fos = new FileOutputStream(outputFile);){
            IOUtils.copy((InputStream)inputStream, (OutputStream)fos);
        }
        catch (IOException e) {
            throw new SystemException((ErrorType)FileErrorType.ERROR_WRITING_FILE, "cannot write file", (Throwable)e).addContextValue((ErrorContext)FileErrorContext.FILE, (Object)outputFile);
        }
        return outputFile;
    }

    public static File writeFile(@NonNull String content, @NonNull File outputFile) {
        if (content == null) {
            throw new NullPointerException("content is marked @NonNull but is null");
        }
        if (outputFile == null) {
            throw new NullPointerException("outputFile is marked @NonNull but is null");
        }
        return FileIOUtils.writeFile(content, outputFile, false);
    }

    public static File writeFile(@NonNull String content, @NonNull File outputFile, @NonNull boolean append) {
        if (content == null) {
            throw new NullPointerException("content is marked @NonNull but is null");
        }
        if (outputFile == null) {
            throw new NullPointerException("outputFile is marked @NonNull but is null");
        }
        FileSystemUtils.retrieveOrCreateFile(outputFile);
        try {
            FileUtils.writeStringToFile((File)outputFile, (String)content, (Charset)StandardCharsets.UTF_8, (boolean)append);
        }
        catch (IOException e) {
            throw new SystemException((ErrorType)FileErrorType.ERROR_WRITING_FILE, "cannot write file", (Throwable)e).addContextValue((ErrorContext)FileErrorContext.FILE, (Object)outputFile);
        }
        return outputFile;
    }

    public static File writeFile(@NonNull Collection<String> lines, @NonNull File outputFile) {
        if (lines == null) {
            throw new NullPointerException("lines is marked @NonNull but is null");
        }
        if (outputFile == null) {
            throw new NullPointerException("outputFile is marked @NonNull but is null");
        }
        return FileIOUtils.writeFile(lines, outputFile, false);
    }

    public static File writeFile(@NonNull Collection<String> lines, @NonNull File outputFile, @NonNull boolean append) {
        if (lines == null) {
            throw new NullPointerException("lines is marked @NonNull but is null");
        }
        if (outputFile == null) {
            throw new NullPointerException("outputFile is marked @NonNull but is null");
        }
        FileSystemUtils.retrieveOrCreateFile(outputFile);
        try {
            FileUtils.writeLines((File)outputFile, lines, (boolean)append);
        }
        catch (IOException e) {
            throw new SystemException((ErrorType)FileErrorType.ERROR_WRITING_FILE, "cannot write file", (Throwable)e).addContextValue((ErrorContext)FileErrorContext.FILE, (Object)outputFile);
        }
        return outputFile;
    }

    public static Collection<String> readLines(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked @NonNull but is null");
        }
        try {
            return FileUtils.readLines((File)file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new SystemException((ErrorType)FileErrorType.ERROR_READING_FILE, (Throwable)e).addContextValue((ErrorContext)FileErrorContext.FILE, (Object)file);
        }
    }

    public static InputStream openInputStream(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked @NonNull but is null");
        }
        try {
            return new ByteArrayInputStream(FileUtils.readFileToByteArray((File)file));
        }
        catch (IOException e) {
            throw new SystemException((ErrorType)FileErrorType.ERROR_OPENING_STREAM, (Throwable)e).addContextValue((ErrorContext)FileErrorContext.FILE, (Object)file);
        }
    }

    public static byte[] readFiletoByteArray(@NonNull File file) {
        if (file == null) {
            throw new NullPointerException("file is marked @NonNull but is null");
        }
        try {
            return FileUtils.readFileToByteArray((File)file);
        }
        catch (IOException e) {
            throw new SystemException((ErrorType)FileErrorType.ERROR_READING_FILE, (Throwable)e).addContextValue((ErrorContext)FileErrorContext.FILE, (Object)file);
        }
    }
}

