package com.crabshue.commons.exceptions.context;

import com.crabshue.commons.exceptions.AbstractException;

/**
 * Error types to use with {@link AbstractException} and implementing classes.
 * Those describe the type of error that is raised.
 *
 */
public interface ErrorType {

    /**
     * Provide the name of the error type.
     *
     * @return the name of the error type.
     */
    String name();

    /**
     * Provide a message for the error type.
     * By default, return the name of the error type.
     *
     * @return the message for the error type.
     */
    default String getMessage() {
        return this.name();
    }
}
