package com.crabshue.commons.exceptions;

import com.crabshue.commons.exceptions.context.CommonErrorType;
import com.crabshue.commons.exceptions.context.ErrorType;

/**
 * Exception used to raise system failures.
 */
public class SystemException extends AbstractException {

    protected SystemException() {
    }

    public SystemException(final Throwable throwable) {

        super(CommonErrorType.SYSTEM_ERROR, throwable);
    }


    /**
     * @see AbstractException#AbstractException(ErrorType)
     */
    public SystemException(final ErrorType errorType) {
        super(errorType);
    }


    /**
     * @see AbstractException#AbstractException(ErrorType, Throwable)
     */
    public SystemException(final ErrorType errorType, final Throwable cause) {
        super(errorType, cause);
    }


    /**
     * @see AbstractException#AbstractException(ErrorType, String)
     */
    public SystemException(final ErrorType errorType, final String message) {
        super(errorType, message);
    }


    /**
     * @see AbstractException#AbstractException(ErrorType, String, Throwable)
     */
    public SystemException(final ErrorType errorType, final String message, final Throwable cause) {
        super(errorType, message, cause);
    }
}
