package com.crabshue.commons.exceptions;

import com.crabshue.commons.exceptions.context.ErrorType;

/**
 * Exception used to raise application errors.
 */
public class ApplicationException extends AbstractException {

    protected ApplicationException() {
    }

    /**
     * @param errorType the error type
     * @see AbstractException#AbstractException(ErrorType)
     */
    public ApplicationException(final ErrorType errorType) {
        super(errorType);
    }

    /**
     * @param errorType the error type
     * @param cause     the cause
     * @see AbstractException#AbstractException(ErrorType, Throwable)
     */
    public ApplicationException(final ErrorType errorType, final Throwable cause) {
        super(errorType, cause);
    }

    /**
     * @param errorType the error type
     * @param message   the custom message
     * @see AbstractException#AbstractException(ErrorType, String)
     */
    public ApplicationException(final ErrorType errorType, final String message) {
        super(errorType, message);
    }

    /**
     * @param errorType the error type
     * @param message   the custom message
     * @param cause     the cause
     * @see AbstractException#AbstractException(ErrorType, String, Throwable)
     */
    public ApplicationException(final ErrorType errorType, final String message, final Throwable cause) {
        super(errorType, message, cause);
    }
}
