/*
 * Decompiled with CFR 0.152.
 */
package io.xjar.zip;

import io.xjar.XEncryptor;
import io.xjar.XEntryEncryptor;
import io.xjar.XEntryFilter;
import io.xjar.XKit;
import io.xjar.XUnclosedOutputStream;
import io.xjar.key.XKey;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

public class XZipEncryptor
extends XEntryEncryptor<ZipArchiveEntry>
implements XEncryptor {
    private final int level;

    public XZipEncryptor(XEncryptor xEncryptor) {
        this(xEncryptor, (XEntryFilter<ZipArchiveEntry>)null);
    }

    public XZipEncryptor(XEncryptor xEncryptor, XEntryFilter<ZipArchiveEntry> filter) {
        this(xEncryptor, -1, filter);
    }

    public XZipEncryptor(XEncryptor xEncryptor, int level) {
        this(xEncryptor, level, null);
    }

    public XZipEncryptor(XEncryptor xEncryptor, int level, XEntryFilter<ZipArchiveEntry> filter) {
        super(xEncryptor, filter);
        this.level = level;
    }

    @Override
    public void encrypt(XKey key, File src, File dest) throws IOException {
        try (FileInputStream fis = new FileInputStream(src);
             FileOutputStream fos = new FileOutputStream(dest);){
            this.encrypt(key, fis, fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encrypt(XKey key, InputStream in, OutputStream out) throws IOException {
        ZipArchiveInputStream zis = null;
        ZipArchiveOutputStream zos = null;
        try {
            ZipArchiveEntry entry;
            zis = new ZipArchiveInputStream(in);
            zos = new ZipArchiveOutputStream(out);
            zos.setLevel(this.level);
            XUnclosedOutputStream nos = new XUnclosedOutputStream((OutputStream)zos);
            while ((entry = zis.getNextZipEntry()) != null) {
                if (entry.isDirectory()) continue;
                zos.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(entry.getName()));
                XEncryptor encryptor = this.filtrate(entry) ? this : this.xNopEncryptor;
                try (OutputStream eos = encryptor.encrypt(key, nos);){
                    XKit.transfer((InputStream)zis, eos);
                }
                zos.closeArchiveEntry();
            }
            zos.finish();
        }
        catch (Throwable throwable) {
            XKit.close(zis);
            XKit.close(zos);
            throw throwable;
        }
        XKit.close((Closeable)zis);
        XKit.close((Closeable)zos);
    }
}

