/*
 * Decompiled with CFR 0.152.
 */
package io.xjar.jar;

import io.xjar.XConstants;
import io.xjar.XDecryptor;
import io.xjar.XEncryptor;
import io.xjar.jar.XJarURLConnection;
import io.xjar.key.XKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;

public class XJarURLHandler
extends URLStreamHandler
implements XConstants {
    private final XDecryptor xDecryptor;
    private final XEncryptor xEncryptor;
    private final XKey xKey;
    private final Set<String> indexes;

    public XJarURLHandler(XDecryptor xDecryptor, XEncryptor xEncryptor, XKey xKey, ClassLoader classLoader) throws Exception {
        this.xDecryptor = xDecryptor;
        this.xEncryptor = xEncryptor;
        this.xKey = xKey;
        this.indexes = new LinkedHashSet<String>();
        Enumeration<URL> resources = classLoader.getResources("XJAR-INF/INDEXES.IDX");
        while (resources.hasMoreElements()) {
            String name;
            URL resource = resources.nextElement();
            String url = resource.toString();
            String classpath = url.substring(0, url.lastIndexOf("!/") + 2);
            InputStream in = resource.openStream();
            InputStreamReader isr = new InputStreamReader(in);
            LineNumberReader lnr = new LineNumberReader(isr);
            while ((name = lnr.readLine()) != null) {
                this.indexes.add(classpath + name);
            }
        }
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        URLConnection urlConnection = new URL(url.toString()).openConnection();
        return this.indexes.contains(url.toString()) && urlConnection instanceof JarURLConnection ? new XJarURLConnection((JarURLConnection)urlConnection, this.xDecryptor, this.xEncryptor, this.xKey) : urlConnection;
    }
}

