/*
 * Decompiled with CFR 0.152.
 */
package io.xjar;

import io.xjar.XKit;
import io.xjar.key.XKey;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XGo {
    private static final String CLRF = System.getProperty("line.separator");

    public static void make(File xJar, XKey xKey) throws IOException {
        byte[] md5 = XKit.md5(xJar);
        byte[] sha1 = XKit.sha1(xJar);
        byte[] algorithm = xKey.getAlgorithm().getBytes(StandardCharsets.UTF_8);
        byte[] keysize = String.valueOf(xKey.getKeysize()).getBytes(StandardCharsets.UTF_8);
        byte[] ivsize = String.valueOf(xKey.getIvsize()).getBytes(StandardCharsets.UTF_8);
        byte[] password = xKey.getPassword().getBytes(StandardCharsets.UTF_8);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("xJar.md5", XGo.convert(md5));
        variables.put("xJar.sha1", XGo.convert(sha1));
        variables.put("xKey.algorithm", XGo.convert(algorithm));
        variables.put("xKey.keysize", XGo.convert(keysize));
        variables.put("xKey.ivsize", XGo.convert(ivsize));
        variables.put("xKey.password", XGo.convert(password));
        List<String> templates = Arrays.asList("xjar.go", "xjar_agentable.go");
        for (String template : templates) {
            URL url = XGo.class.getClassLoader().getResource("xjar/" + template);
            if (url == null) {
                throw new IOException("could not find xjar/" + template + " in classpath");
            }
            String dir = xJar.getParent();
            File src = new File(dir, template);
            InputStream in = url.openStream();
            Throwable throwable = null;
            try {
                InputStreamReader reader = new InputStreamReader(in);
                Throwable throwable2 = null;
                try {
                    BufferedReader br = new BufferedReader(reader);
                    Throwable throwable3 = null;
                    try {
                        FileOutputStream out = new FileOutputStream(src);
                        Throwable throwable4 = null;
                        try {
                            OutputStreamWriter writer = new OutputStreamWriter(out);
                            Throwable throwable5 = null;
                            try {
                                BufferedWriter bw = new BufferedWriter(writer);
                                Throwable throwable6 = null;
                                try {
                                    String line;
                                    while ((line = br.readLine()) != null) {
                                        for (Map.Entry variable : variables.entrySet()) {
                                            line = line.replace("#{" + (String)variable.getKey() + "}", (CharSequence)variable.getValue());
                                        }
                                        bw.write(line);
                                        bw.write(CLRF);
                                    }
                                    bw.flush();
                                    ((Writer)writer).flush();
                                    out.flush();
                                }
                                catch (Throwable throwable7) {
                                    throwable6 = throwable7;
                                    throw throwable7;
                                }
                                finally {
                                    if (bw == null) continue;
                                    if (throwable6 != null) {
                                        try {
                                            bw.close();
                                        }
                                        catch (Throwable throwable8) {
                                            throwable6.addSuppressed(throwable8);
                                        }
                                        continue;
                                    }
                                    bw.close();
                                }
                            }
                            catch (Throwable throwable9) {
                                throwable5 = throwable9;
                                throw throwable9;
                            }
                            finally {
                                if (writer == null) continue;
                                if (throwable5 != null) {
                                    try {
                                        ((Writer)writer).close();
                                    }
                                    catch (Throwable throwable10) {
                                        throwable5.addSuppressed(throwable10);
                                    }
                                    continue;
                                }
                                ((Writer)writer).close();
                            }
                        }
                        catch (Throwable throwable11) {
                            throwable4 = throwable11;
                            throw throwable11;
                        }
                        finally {
                            if (out == null) continue;
                            if (throwable4 != null) {
                                try {
                                    ((OutputStream)out).close();
                                }
                                catch (Throwable throwable12) {
                                    throwable4.addSuppressed(throwable12);
                                }
                                continue;
                            }
                            ((OutputStream)out).close();
                        }
                    }
                    catch (Throwable throwable13) {
                        throwable3 = throwable13;
                        throw throwable13;
                    }
                    finally {
                        if (br == null) continue;
                        if (throwable3 != null) {
                            try {
                                br.close();
                            }
                            catch (Throwable throwable14) {
                                throwable3.addSuppressed(throwable14);
                            }
                            continue;
                        }
                        br.close();
                    }
                }
                catch (Throwable throwable15) {
                    throwable2 = throwable15;
                    throw throwable15;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable2 != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable16) {
                            throwable2.addSuppressed(throwable16);
                        }
                        continue;
                    }
                    ((Reader)reader).close();
                }
            }
            catch (Throwable throwable17) {
                throwable = throwable17;
                throw throwable17;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable18) {
                        throwable.addSuppressed(throwable18);
                    }
                    continue;
                }
                in.close();
            }
        }
    }

    private static String convert(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (byte b : bytes) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(b & 0xFF);
        }
        return builder.toString();
    }
}

