/*
 * Decompiled with CFR 0.152.
 */
package io.xjar;

import io.xjar.XEncryptor;
import io.xjar.XKit;
import io.xjar.key.XKey;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class XJdkEncryptor
implements XEncryptor {
    @Override
    public void encrypt(XKey key, File src, File dest) throws IOException {
        if (!dest.getParentFile().exists() && !dest.getParentFile().mkdirs()) {
            throw new IOException("could not make directory: " + dest.getParentFile());
        }
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            this.encrypt(key, in, out);
        }
    }

    @Override
    public void encrypt(XKey key, InputStream in, OutputStream out) throws IOException {
        CipherInputStream cis = null;
        try {
            String algorithm = key.getAlgorithm();
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(1, (Key)new SecretKeySpec(key.getEncryptKey(), algorithm.split("[/]")[0]), new IvParameterSpec(key.getIvParameter()));
            cis = new CipherInputStream(in, cipher);
            XKit.transfer((InputStream)cis, out);
        }
        catch (Exception e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                XKit.close(cis);
                throw throwable;
            }
        }
        XKit.close(cis);
    }

    @Override
    public InputStream encrypt(XKey key, InputStream in) throws IOException {
        try {
            String algorithm = key.getAlgorithm();
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(1, (Key)new SecretKeySpec(key.getEncryptKey(), algorithm.split("[/]")[0]), new IvParameterSpec(key.getIvParameter()));
            return new CipherInputStream(in, cipher);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public OutputStream encrypt(XKey key, OutputStream out) throws IOException {
        try {
            String algorithm = key.getAlgorithm();
            Cipher cipher = Cipher.getInstance(algorithm);
            cipher.init(1, (Key)new SecretKeySpec(key.getEncryptKey(), algorithm.split("[/]")[0]), new IvParameterSpec(key.getIvParameter()));
            return new CipherOutputStream(out, cipher);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

