/*
 * Decompiled with CFR 0.152.
 */
package io.xjar.boot;

import io.xjar.XConstants;
import io.xjar.XDecryptor;
import io.xjar.XEntryDecryptor;
import io.xjar.XEntryFilter;
import io.xjar.XKit;
import io.xjar.XUnclosedInputStream;
import io.xjar.XUnclosedOutputStream;
import io.xjar.boot.XBootJarArchiveEntry;
import io.xjar.jar.XJarAllEntryFilter;
import io.xjar.jar.XJarDecryptor;
import io.xjar.key.XKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveInputStream;
import org.apache.commons.compress.archivers.jar.JarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;

public class XBootDecryptor
extends XEntryDecryptor<JarArchiveEntry>
implements XDecryptor,
XConstants {
    private final int level;

    public XBootDecryptor(XDecryptor xDecryptor) {
        this(xDecryptor, new XJarAllEntryFilter());
    }

    public XBootDecryptor(XDecryptor xDecryptor, XEntryFilter<JarArchiveEntry> filter) {
        this(xDecryptor, -1, filter);
    }

    public XBootDecryptor(XDecryptor xDecryptor, int level) {
        this(xDecryptor, level, new XJarAllEntryFilter());
    }

    public XBootDecryptor(XDecryptor xDecryptor, int level, XEntryFilter<JarArchiveEntry> filter) {
        super(xDecryptor, filter);
        this.level = level;
    }

    @Override
    public void decrypt(XKey key, File src, File dest) throws IOException {
        try (FileInputStream fis = new FileInputStream(src);
             FileOutputStream fos = new FileOutputStream(dest);){
            this.decrypt(key, fis, fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decrypt(XKey key, InputStream in, OutputStream out) throws IOException {
        JarArchiveInputStream zis = null;
        JarArchiveOutputStream zos = null;
        try {
            JarArchiveEntry entry;
            zis = new JarArchiveInputStream(in);
            zos = new JarArchiveOutputStream(out);
            zos.setLevel(this.level);
            XUnclosedInputStream nis = new XUnclosedInputStream((InputStream)zis);
            XUnclosedOutputStream nos = new XUnclosedOutputStream((OutputStream)zos);
            XJarDecryptor xJarDecryptor = new XJarDecryptor(this.xDecryptor, this.level, this.filter);
            while ((entry = zis.getNextJarEntry()) != null) {
                JarArchiveEntry jarArchiveEntry;
                JarArchiveEntry jarArchiveEntry2;
                if (entry.getName().startsWith(XJAR_SRC_DIR) || entry.getName().endsWith("XJAR-INF/") || entry.getName().endsWith("XJAR-INF/INDEXES.IDX")) continue;
                if (entry.isDirectory()) {
                    jarArchiveEntry2 = new JarArchiveEntry(entry.getName());
                    jarArchiveEntry2.setTime(entry.getTime());
                    zos.putArchiveEntry((ArchiveEntry)jarArchiveEntry2);
                } else if (entry.getName().equals("META-INF/MANIFEST.MF")) {
                    Manifest manifest = new Manifest(nis);
                    Attributes attributes = manifest.getMainAttributes();
                    String mainClass = attributes.getValue("Boot-Main-Class");
                    if (mainClass != null) {
                        attributes.putValue("Main-Class", mainClass);
                        attributes.remove(new Attributes.Name("Boot-Main-Class"));
                    }
                    jarArchiveEntry = new JarArchiveEntry(entry.getName());
                    jarArchiveEntry.setTime(entry.getTime());
                    zos.putArchiveEntry((ArchiveEntry)jarArchiveEntry);
                    manifest.write(nos);
                } else if (entry.getName().startsWith("BOOT-INF/classes/")) {
                    jarArchiveEntry2 = new JarArchiveEntry(entry.getName());
                    jarArchiveEntry2.setTime(entry.getTime());
                    zos.putArchiveEntry((ArchiveEntry)jarArchiveEntry2);
                    XBootJarArchiveEntry xBootJarArchiveEntry = new XBootJarArchiveEntry((ZipArchiveEntry)entry);
                    boolean filtered = this.filtrate(xBootJarArchiveEntry);
                    XDecryptor decryptor = filtered ? this.xDecryptor : this.xNopDecryptor;
                    try (OutputStream eos = decryptor.decrypt(key, nos);){
                        XKit.transfer((InputStream)nis, eos);
                    }
                } else if (entry.getName().startsWith("BOOT-INF/lib/")) {
                    byte[] data = XKit.read(nis);
                    ByteArrayInputStream lib = new ByteArrayInputStream(data);
                    boolean need = xJarDecryptor.predicate(lib);
                    lib.reset();
                    if (need) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        CheckedOutputStream cos = new CheckedOutputStream(bos, new CRC32());
                        xJarDecryptor.decrypt(key, lib, cos);
                        JarArchiveEntry jarArchiveEntry3 = new JarArchiveEntry(entry.getName());
                        jarArchiveEntry3.setMethod(0);
                        jarArchiveEntry3.setSize((long)bos.size());
                        jarArchiveEntry3.setTime(entry.getTime());
                        jarArchiveEntry3.setCrc(cos.getChecksum().getValue());
                        zos.putArchiveEntry((ArchiveEntry)jarArchiveEntry3);
                        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
                        XKit.transfer((InputStream)bis, nos);
                    } else {
                        jarArchiveEntry = new JarArchiveEntry(entry.getName());
                        jarArchiveEntry.setMethod(0);
                        jarArchiveEntry.setSize(entry.getSize());
                        jarArchiveEntry.setTime(entry.getTime());
                        jarArchiveEntry.setCrc(entry.getCrc());
                        zos.putArchiveEntry((ArchiveEntry)jarArchiveEntry);
                        XKit.transfer((InputStream)lib, nos);
                    }
                } else {
                    jarArchiveEntry2 = new JarArchiveEntry(entry.getName());
                    jarArchiveEntry2.setTime(entry.getTime());
                    zos.putArchiveEntry((ArchiveEntry)jarArchiveEntry2);
                    XKit.transfer((InputStream)nis, nos);
                }
                zos.closeArchiveEntry();
            }
            zos.finish();
        }
        catch (Throwable throwable) {
            XKit.close(zis);
            XKit.close(zos);
            throw throwable;
        }
        XKit.close((Closeable)zis);
        XKit.close((Closeable)zos);
    }
}

