/*
 * Decompiled with CFR 0.152.
 */
package io.xjar;

import io.xjar.XKit;
import io.xjar.key.XKey;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class XGo {
    private static final String CLRF = System.getProperty("line.separator");

    public static void make(File xJar, XKey xKey) throws IOException {
        byte[] md5 = XKit.md5(xJar);
        byte[] sha1 = XKit.sha1(xJar);
        byte[] algorithm = xKey.getAlgorithm().getBytes(StandardCharsets.UTF_8);
        byte[] keysize = String.valueOf(xKey.getKeysize()).getBytes(StandardCharsets.UTF_8);
        byte[] ivsize = String.valueOf(xKey.getIvsize()).getBytes(StandardCharsets.UTF_8);
        byte[] password = xKey.getPassword().getBytes(StandardCharsets.UTF_8);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("xJar.md5", XGo.convert(md5));
        variables.put("xJar.sha1", XGo.convert(sha1));
        variables.put("xKey.algorithm", XGo.convert(algorithm));
        variables.put("xKey.keysize", XGo.convert(keysize));
        variables.put("xKey.ivsize", XGo.convert(ivsize));
        variables.put("xKey.password", XGo.convert(password));
        URL url = XGo.class.getClassLoader().getResource("xjar/xjar.go");
        if (url == null) {
            throw new IOException("could not find xjar.go");
        }
        String dir = xJar.getParent();
        File src = new File(dir, "xjar.go");
        try (InputStream in = url.openStream();
             InputStreamReader reader = new InputStreamReader(in);
             BufferedReader br = new BufferedReader(reader);
             FileOutputStream out = new FileOutputStream(src);
             OutputStreamWriter writer = new OutputStreamWriter(out);
             BufferedWriter bw = new BufferedWriter(writer);){
            String line;
            while ((line = br.readLine()) != null) {
                for (Map.Entry variable : variables.entrySet()) {
                    line = line.replace("#{" + (String)variable.getKey() + "}", (CharSequence)variable.getValue());
                }
                bw.write(line);
                bw.write(CLRF);
            }
            bw.flush();
            ((Writer)writer).flush();
            out.flush();
        }
    }

    private static String convert(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (byte b : bytes) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(b & 0xFF);
        }
        return builder.toString();
    }
}

