/*
 * Decompiled with CFR 0.152.
 */
package io.xjar;

import io.xjar.XCryptos;
import io.xjar.XEntryFilter;
import io.xjar.XFilters;
import io.xjar.XKit;
import io.xjar.filter.XAllEntryFilter;
import io.xjar.filter.XAnyEntryFilter;
import io.xjar.filter.XMixEntryFilter;
import io.xjar.key.XKey;
import java.io.File;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;

public class XEncryption {
    private File jar;
    private XKey key;
    private XAnyEntryFilter<JarArchiveEntry> includes = XKit.any();
    private XAllEntryFilter<JarArchiveEntry> excludes = XKit.all();

    public XEncryption from(String jar) {
        return this.from(new File(jar));
    }

    public XEncryption from(File jar) {
        this.jar = jar;
        return this;
    }

    public XEncryption use(String password) {
        try {
            this.key = XKit.key(password);
            return this;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public XEncryption use(String algorithm, int keysize, int ivsize, String password) {
        try {
            this.key = XKit.key(algorithm, keysize, ivsize, password);
            return this;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public XEncryption include(String ant) {
        this.includes.mix((XEntryFilter)XFilters.ant(ant));
        return this;
    }

    public XEncryption include(Pattern regex) {
        this.includes.mix((XEntryFilter)XFilters.regex(regex.pattern()));
        return this;
    }

    public XEncryption exclude(String ant) {
        this.excludes.mix(XFilters.not(XFilters.ant(ant)));
        return this;
    }

    public XEncryption exclude(Pattern regex) {
        this.excludes.mix(XFilters.not(XFilters.regex(regex.pattern())));
        return this;
    }

    public void to(String xJar) throws Exception {
        this.to(new File(xJar));
    }

    public void to(File xJar) throws Exception {
        XAllEntryFilter<JarArchiveEntry> filter;
        if (this.jar == null) {
            throw new IllegalArgumentException("jar to encrypt is null. [please call from(String jar) or from(File jar) before]");
        }
        if (this.key == null) {
            throw new IllegalArgumentException("key to encrypt is null. [please call use(String password) or use(String algorithm, int keysize, int ivsize, String password) before]");
        }
        if (this.includes.size() == 0 && this.excludes.size() == 0) {
            filter = null;
        } else {
            filter = XKit.all();
            if (this.includes.size() > 0) {
                ((XMixEntryFilter)filter).mix(this.includes);
            }
            if (this.excludes.size() > 0) {
                ((XMixEntryFilter)filter).mix(this.excludes);
            }
        }
        XCryptos.encrypt(this.jar, xJar, this.key, filter);
    }
}

