/*
 * Decompiled with CFR 0.152.
 */
package io.httpdoc.web.conversion;

import io.httpdoc.web.conversion.Conversion;
import io.httpdoc.web.conversion.ConversionProvider;
import io.httpdoc.web.conversion.Converter;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Map;

public class WrapperConverter
implements Converter<Object> {
    @Override
    public boolean supports(Class<?> type) {
        return type == Boolean.class || type == Byte.class || type == Short.class || type == Character.class || type == Integer.class || type == Float.class || type == Long.class || type == Double.class;
    }

    @Override
    public Map<String, String[]> convert(String name, Object value, ConversionProvider provider) throws Exception {
        return Collections.singletonMap(name, new String[]{String.valueOf(value)});
    }

    @Override
    public boolean supports(Conversion conversion) {
        return conversion.type == Boolean.class || conversion.type == Byte.class || conversion.type == Short.class || conversion.type == Character.class || conversion.type == Integer.class || conversion.type == Float.class || conversion.type == Long.class || conversion.type == Double.class;
    }

    @Override
    public Object convert(Conversion conversion, ConversionProvider provider) throws Exception {
        if (!this.supports(conversion) || !conversion.name.equals(conversion.expression)) {
            return conversion.value;
        }
        if (conversion.type == Boolean.class) {
            return Boolean.valueOf(conversion.decoded ? conversion.values[0] : URLDecoder.decode(conversion.values[0], conversion.charset));
        }
        if (conversion.type == Byte.class) {
            return Byte.valueOf(conversion.decoded ? conversion.values[0] : URLDecoder.decode(conversion.values[0], conversion.charset));
        }
        if (conversion.type == Short.class) {
            return Short.valueOf(conversion.decoded ? conversion.values[0] : URLDecoder.decode(conversion.values[0], conversion.charset));
        }
        if (conversion.type == Character.class) {
            return conversion.decoded ? conversion.values[0] : Character.valueOf(URLDecoder.decode(conversion.values[0], conversion.charset).charAt(0));
        }
        if (conversion.type == Integer.class) {
            return Integer.valueOf(conversion.decoded ? conversion.values[0] : URLDecoder.decode(conversion.values[0], conversion.charset));
        }
        if (conversion.type == Float.class) {
            return Float.valueOf(conversion.decoded ? conversion.values[0] : URLDecoder.decode(conversion.values[0], conversion.charset));
        }
        if (conversion.type == Long.class) {
            return Long.valueOf(conversion.decoded ? conversion.values[0] : URLDecoder.decode(conversion.values[0], conversion.charset));
        }
        if (conversion.type == Double.class) {
            return Double.valueOf(conversion.decoded ? conversion.values[0] : URLDecoder.decode(conversion.values[0], conversion.charset));
        }
        return conversion.value;
    }
}

