/*
 * Decompiled with CFR 0.152.
 */
package io.httpdoc.web.conversion;

import io.httpdoc.web.conversion.Conversion;
import io.httpdoc.web.conversion.ConversionProvider;
import io.httpdoc.web.conversion.Converter;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Map;

public class StringConverter
implements Converter<CharSequence> {
    @Override
    public boolean supports(Class<?> type) {
        return CharSequence.class.isAssignableFrom(type);
    }

    @Override
    public Map<String, String[]> convert(String name, CharSequence value, ConversionProvider provider) throws Exception {
        char[] chars = new char[value.length()];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = value.charAt(i);
        }
        return Collections.singletonMap(name, new String[]{new String(chars)});
    }

    @Override
    public boolean supports(Conversion conversion) {
        return conversion.type == String.class || conversion.type == StringBuilder.class || conversion.type == StringBuffer.class || conversion.type == CharSequence.class;
    }

    @Override
    public CharSequence convert(Conversion conversion, ConversionProvider provider) throws Exception {
        if (!this.supports(conversion) || !conversion.name.equals(conversion.expression)) {
            return (CharSequence)conversion.value;
        }
        if (conversion.type == String.class) {
            return conversion.decoded ? conversion.values[0] : URLDecoder.decode(conversion.values[0], conversion.charset);
        }
        if (conversion.type == StringBuilder.class) {
            return new StringBuilder(conversion.decoded ? conversion.values[0] : URLDecoder.decode(conversion.values[0], conversion.charset));
        }
        if (conversion.type == StringBuffer.class) {
            return new StringBuffer(conversion.decoded ? conversion.values[0] : URLDecoder.decode(conversion.values[0], conversion.charset));
        }
        if (conversion.type == CharSequence.class) {
            return conversion.decoded ? conversion.values[0] : URLDecoder.decode(conversion.values[0], conversion.charset);
        }
        return (CharSequence)conversion.value;
    }
}

