/*
 * Decompiled with CFR 0.152.
 */
package io.httpdoc.web.conversion;

import io.httpdoc.web.conversion.Conversion;
import io.httpdoc.web.conversion.ConversionProvider;
import io.httpdoc.web.conversion.Converter;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Map;

public class PrimaryConverter
implements Converter<Object> {
    @Override
    public boolean supports(Class<?> type) {
        return type == Boolean.TYPE || type == Byte.TYPE || type == Short.TYPE || type == Character.TYPE || type == Integer.TYPE || type == Float.TYPE || type == Long.TYPE || type == Double.TYPE;
    }

    @Override
    public Map<String, String[]> convert(String name, Object value, ConversionProvider provider) throws Exception {
        return Collections.singletonMap(name, new String[]{String.valueOf(value)});
    }

    @Override
    public boolean supports(Conversion conversion) {
        return conversion.type == Boolean.TYPE || conversion.type == Byte.TYPE || conversion.type == Short.TYPE || conversion.type == Character.TYPE || conversion.type == Integer.TYPE || conversion.type == Float.TYPE || conversion.type == Long.TYPE || conversion.type == Double.TYPE;
    }

    @Override
    public Object convert(Conversion conversion, ConversionProvider provider) throws Exception {
        if (!this.supports(conversion) || !conversion.name.equals(conversion.expression)) {
            return conversion.value;
        }
        if (conversion.type == Boolean.TYPE) {
            return Boolean.parseBoolean(conversion.decoded ? conversion.values[0] : URLDecoder.decode(conversion.values[0], conversion.charset));
        }
        if (conversion.type == Byte.TYPE) {
            return Byte.parseByte(conversion.decoded ? conversion.values[0] : URLDecoder.decode(conversion.values[0], conversion.charset));
        }
        if (conversion.type == Short.TYPE) {
            return Short.parseShort(conversion.decoded ? conversion.values[0] : URLDecoder.decode(conversion.values[0], conversion.charset));
        }
        if (conversion.type == Character.TYPE) {
            return conversion.decoded ? conversion.values[0] : Character.valueOf(URLDecoder.decode(conversion.values[0], conversion.charset).charAt(0));
        }
        if (conversion.type == Integer.TYPE) {
            return Integer.parseInt(conversion.decoded ? conversion.values[0] : URLDecoder.decode(conversion.values[0], conversion.charset));
        }
        if (conversion.type == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(conversion.decoded ? conversion.values[0] : URLDecoder.decode(conversion.values[0], conversion.charset)));
        }
        if (conversion.type == Long.TYPE) {
            return Long.parseLong(conversion.decoded ? conversion.values[0] : URLDecoder.decode(conversion.values[0], conversion.charset));
        }
        if (conversion.type == Double.TYPE) {
            return Double.parseDouble(conversion.decoded ? conversion.values[0] : URLDecoder.decode(conversion.values[0], conversion.charset));
        }
        return conversion.value;
    }
}

