/*
 * Decompiled with CFR 0.152.
 */
package io.httpdoc.web.conversion;

import io.httpdoc.web.conversion.Conversion;
import io.httpdoc.web.conversion.ConversionProvider;
import io.httpdoc.web.conversion.Converter;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public class DateConverter
implements Converter<Date> {
    @Override
    public boolean supports(Class<?> type) {
        return Date.class.isAssignableFrom(type);
    }

    @Override
    public Map<String, String[]> convert(String name, Date value, ConversionProvider provider) throws Exception {
        return Collections.singletonMap(name, new String[]{provider.getSerializationDateFormat().format(value)});
    }

    @Override
    public boolean supports(Conversion conversion) {
        return conversion.type == Date.class;
    }

    @Override
    public Date convert(Conversion conversion, ConversionProvider provider) throws Exception {
        String value;
        if (!this.supports(conversion) || !conversion.name.equals(conversion.expression)) {
            return (Date)conversion.value;
        }
        String[] values = conversion.values;
        boolean decoded = conversion.decoded;
        String charset = conversion.charset;
        String string = value = values != null && values.length > 0 ? values[0] : null;
        if (value == null) {
            return (Date)conversion.value;
        }
        if (!decoded) {
            value = URLDecoder.decode(value, charset);
        }
        return provider.getDeserializationDateFormat().parse(value);
    }
}

