/*
 * Decompiled with CFR 0.152.
 */
package io.httpdoc.web;

import io.httpdoc.core.kit.IOKit;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Stack;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

public class ZipKit {
    public static void pack(String source, String target) throws IOException {
        ZipKit.pack(new File(source), new File(target));
    }

    public static void pack(File source, File target) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(target);){
            ZipKit.pack(source, outputStream);
        }
    }

    public static void pack(File source, OutputStream out) throws IOException {
        try (ZipArchiveOutputStream zipArchiveOutputStream = new ZipArchiveOutputStream(out);){
            ZipKit.pack(source, zipArchiveOutputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pack(File source, ZipArchiveOutputStream zipArchiveOutputStream) throws IOException {
        Stack<String> parents = new Stack<String>();
        Stack<File> files = new Stack<File>();
        if (source.exists()) {
            parents.push(null);
            files.push(source);
        }
        while (!files.isEmpty()) {
            File file = (File)files.pop();
            String parent = (String)parents.pop();
            if (file.isDirectory()) {
                ZipArchiveEntry zipArchiveEntry = new ZipArchiveEntry(parent == null ? file.getName() + "/" : parent + "/" + file.getName() + "/");
                zipArchiveEntry.setTime(file.lastModified());
                zipArchiveOutputStream.putArchiveEntry((ArchiveEntry)zipArchiveEntry);
                zipArchiveOutputStream.closeArchiveEntry();
                File[] children = file.listFiles();
                for (int i = 0; children != null && i < children.length; ++i) {
                    File child = children[i];
                    parents.push(parent == null ? file.getName() : parent + "/" + file.getName());
                    files.push(child);
                }
                continue;
            }
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                ZipArchiveEntry zipArchiveEntry = new ZipArchiveEntry(file, parent == null ? file.getName() : parent + "/" + file.getName());
                zipArchiveOutputStream.putArchiveEntry((ArchiveEntry)zipArchiveEntry);
                IOKit.transfer((InputStream)fileInputStream, (OutputStream)zipArchiveOutputStream);
                zipArchiveOutputStream.closeArchiveEntry();
            }
            catch (Throwable throwable) {
                IOKit.close(fileInputStream);
                throw throwable;
            }
            IOKit.close((Closeable)fileInputStream);
        }
    }

    public static void unpack(String source, String target) throws IOException {
        ZipKit.unpack(new File(source), new File(target));
    }

    public static void unpack(File source, File target) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(source);){
            ZipKit.unpack(inputStream, target);
        }
    }

    public static void unpack(InputStream in, File target) throws IOException {
        try (ZipArchiveInputStream zipArchiveInputStream = new ZipArchiveInputStream(in);){
            ZipKit.unpack(zipArchiveInputStream, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unpack(ZipArchiveInputStream zipArchiveInputStream, File target) throws IOException {
        ZipArchiveEntry zipArchiveEntry;
        while ((zipArchiveEntry = zipArchiveInputStream.getNextZipEntry()) != null) {
            if (zipArchiveEntry.isDirectory()) {
                File parent = new File(target, zipArchiveEntry.getName());
                if (parent.exists() || parent.mkdirs() || parent.exists()) continue;
                throw new IOException("could not make directory: " + parent);
            }
            FileOutputStream fileOutputStream = null;
            try {
                File file = new File(target, zipArchiveEntry.getName());
                File parent = file.getParentFile();
                if (!(parent.exists() || parent.mkdirs() || parent.exists())) {
                    throw new IOException("could not make directory: " + parent);
                }
                fileOutputStream = new FileOutputStream(file);
                IOKit.transfer((InputStream)zipArchiveInputStream, (OutputStream)fileOutputStream);
            }
            catch (Throwable throwable) {
                IOKit.close(fileOutputStream);
                throw throwable;
            }
            IOKit.close((Closeable)fileOutputStream);
        }
    }
}

