/*
 * Decompiled with CFR 0.152.
 */
package io.httpdoc.web;

import io.httpdoc.core.Config;
import io.httpdoc.core.Document;
import io.httpdoc.core.Lifecycle;
import io.httpdoc.core.Sdk;
import io.httpdoc.core.conversion.Converter;
import io.httpdoc.core.conversion.CustomFormat;
import io.httpdoc.core.conversion.Format;
import io.httpdoc.core.conversion.StandardConverter;
import io.httpdoc.core.export.Exporter;
import io.httpdoc.core.interpretation.Interpreter;
import io.httpdoc.core.interpretation.SourceInterpreter;
import io.httpdoc.core.kit.IOKit;
import io.httpdoc.core.kit.LoadKit;
import io.httpdoc.core.serialization.Serializer;
import io.httpdoc.core.supplier.Supplier;
import io.httpdoc.core.supplier.SystemSupplier;
import io.httpdoc.core.translation.Container;
import io.httpdoc.core.translation.Translation;
import io.httpdoc.core.translation.Translator;
import io.httpdoc.jackson.serialization.JsonSerializer;
import io.httpdoc.web.Handler;
import io.httpdoc.web.HttpdocConversionProvider;
import io.httpdoc.web.HttpdocMergedTranslator;
import io.httpdoc.web.HttpdocThreadLocal;
import io.httpdoc.web.HttpdocWebConfig;
import io.httpdoc.web.HttpdocWebContainer;
import io.httpdoc.web.conversion.Conversion;
import io.httpdoc.web.conversion.ConversionProvider;
import io.httpdoc.web.conversion.ConvertingException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class HttpdocWebSupport
implements Handler {
    private String httpdoc;
    private String protocol;
    private String hostname;
    private Integer port;
    private String context;
    private String version;
    private String dateFormat = "yyyy-MM-dd HH:mm:ss";
    private String description;
    private String charset = "UTF-8";
    private String contentType = null;
    private Translator translator = new HttpdocMergedTranslator();
    private Supplier supplier = new SystemSupplier();
    private Interpreter interpreter = new SourceInterpreter();
    private Converter converter = new StandardConverter();
    private Serializer serializer = new JsonSerializer();
    private ConversionProvider conversionProvider = new HttpdocConversionProvider();
    private Format format = new CustomFormat();
    private Map<String, Handler> handlers = LoadKit.load((ClassLoader)this.getClass().getClassLoader(), Handler.class);
    private Map<String, Exporter> exporters = LoadKit.load((ClassLoader)this.getClass().getClassLoader(), Exporter.class);

    public void init(HttpdocWebConfig config) throws ServletException {
        try {
            String conversionProvider;
            String serializer;
            String converter;
            String interpreter;
            String provider;
            String translator;
            String contentType;
            String charset;
            String description;
            String dateFormat;
            String version;
            String context;
            String port;
            String hostname;
            String protocol;
            String packages = config.getInitParameter("packages");
            if (packages == null || packages.trim().length() == 0) {
                throw new IllegalArgumentException("packages to scan is not defined");
            }
            String httpdoc = config.getInitParameter("httpdoc");
            if (httpdoc != null && httpdoc.trim().length() > 0) {
                this.httpdoc = httpdoc;
            }
            if ((protocol = config.getInitParameter("protocol")) != null && protocol.trim().length() > 0) {
                this.protocol = protocol;
            }
            if ((hostname = config.getInitParameter("hostname")) != null && hostname.trim().length() > 0) {
                this.hostname = hostname;
            }
            if ((port = config.getInitParameter("port")) != null && port.trim().length() > 0 && port.matches("\\d+")) {
                this.port = Integer.valueOf(port);
            }
            if ((context = config.getInitParameter("context")) != null && context.trim().length() > 0) {
                this.context = context;
            }
            if ((version = config.getInitParameter("version")) != null && version.trim().length() > 0) {
                this.version = version;
            }
            if ((dateFormat = config.getInitParameter("dateFormat")) != null && dateFormat.trim().length() > 0) {
                this.dateFormat = dateFormat;
            }
            if ((description = config.getInitParameter("description")) != null && description.trim().length() > 0) {
                this.description = description;
            }
            if ((charset = config.getInitParameter("charset")) != null && charset.trim().length() > 0) {
                this.charset = charset;
            }
            if ((contentType = config.getInitParameter("contentType")) != null && contentType.trim().length() > 0) {
                this.contentType = contentType;
            }
            if ((translator = config.getInitParameter("translator")) != null && translator.trim().length() > 0) {
                this.translator = Class.forName(translator).asSubclass(Translator.class).newInstance();
            }
            if (this.translator instanceof Lifecycle) {
                ((Lifecycle)this.translator).initial((Config)config);
            }
            if ((provider = config.getInitParameter("supplier")) != null && provider.trim().length() > 0) {
                this.supplier = Class.forName(provider).asSubclass(Supplier.class).newInstance();
            }
            if (this.supplier instanceof Lifecycle) {
                ((Lifecycle)this.supplier).initial((Config)config);
            }
            if ((interpreter = config.getInitParameter("interpreter")) != null && interpreter.trim().length() > 0) {
                this.interpreter = Class.forName(interpreter).asSubclass(Interpreter.class).newInstance();
            }
            if (this.interpreter instanceof Lifecycle) {
                ((Lifecycle)this.interpreter).initial((Config)config);
            }
            if ((converter = config.getInitParameter("converter")) != null && converter.trim().length() > 0) {
                this.converter = Class.forName(converter).asSubclass(Converter.class).newInstance();
            }
            if (this.converter instanceof Lifecycle) {
                ((Lifecycle)this.converter).initial((Config)config);
            }
            if ((serializer = config.getInitParameter("serializer")) != null && serializer.trim().length() > 0) {
                this.serializer = Class.forName(serializer).asSubclass(Serializer.class).newInstance();
            }
            if (this.serializer instanceof Lifecycle) {
                ((Lifecycle)this.serializer).initial((Config)config);
            }
            if ((conversionProvider = config.getInitParameter("conversionProvider")) != null && conversionProvider.trim().length() > 0) {
                this.conversionProvider = Class.forName(conversionProvider).asSubclass(ConversionProvider.class).newInstance();
            }
            if (this.conversionProvider instanceof Lifecycle) {
                ((Lifecycle)this.conversionProvider).initial((Config)config);
            }
            for (Handler handler : this.handlers.values()) {
                if (!(handler instanceof Lifecycle)) continue;
                ((Lifecycle)handler).initial((Config)config);
            }
            for (Exporter exporter : this.exporters.values()) {
                if (!(exporter instanceof Lifecycle)) continue;
                ((Lifecycle)exporter).initial((Config)config);
            }
            Enumeration names = config.getInitParameterNames();
            while (names.hasMoreElements()) {
                String expression = (String)names.nextElement();
                if (!expression.startsWith("format.")) continue;
                this.conversionProvider.convert(new Conversion("format", this.format, (Type)((Object)CustomFormat.class), true, "UTF-8", expression, new String[]{config.getInitParameter(expression)}));
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void handle(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        try {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse res = (HttpServletResponse)response;
            HttpdocThreadLocal.bind(req, res);
            HttpdocWebContainer container = new HttpdocWebContainer(request.getServletContext());
            Translation translation = new Translation((Container)container, this.supplier, this.interpreter);
            translation.setHttpdoc(this.httpdoc);
            translation.setProtocol(this.protocol != null ? this.protocol : req.getProtocol().split("/")[0].toLowerCase());
            translation.setHostname(this.hostname != null ? this.hostname : req.getServerName());
            translation.setPort(Integer.valueOf(this.port != null ? this.port.intValue() : req.getServerPort()));
            translation.setContext(this.context != null ? this.context : req.getContextPath());
            translation.setVersion(this.version);
            translation.setDateFormat(this.dateFormat);
            translation.setDescription(this.description);
            Map map = request.getParameterMap();
            this.assign("translation", translation, map);
            Document doc = this.translator.translate(translation);
            for (Map.Entry<String, Exporter> entry : this.exporters.entrySet()) {
                Sdk sdk = new Sdk();
                sdk.setPlatform(entry.getValue().platform());
                sdk.setFramework(entry.getKey());
                doc.getSdks().add(sdk);
            }
            String action = request.getParameter("action");
            HttpdocWebSupport handler = this.handlers.containsKey(action) ? this.handlers.get(action) : this;
            handler.handle(doc, req, res);
        }
        catch (IOException | ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        finally {
            HttpdocThreadLocal.clear();
        }
    }

    @Override
    public void handle(Document document, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Map map = request.getParameterMap();
        response.setCharacterEncoding(this.charset);
        response.setContentType(this.contentType != null ? this.contentType : this.serializer.getType() + "; charset=" + this.charset);
        Format clone = (Format)IOKit.clone((Serializable)this.format);
        this.assign("format", clone, map);
        Map doc = this.converter.convert(document, clone);
        this.serializer.serialize(doc, (OutputStream)response.getOutputStream());
    }

    private void assign(String name, Object object, Map<String, String[]> map) throws ConvertingException {
        if (object == null) {
            throw new NullPointerException();
        }
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            String key = entry.getKey();
            String[] value = entry.getValue();
            this.conversionProvider.convert(new Conversion(name, object, object.getClass(), true, "UTF-8", key, value));
        }
    }

    public void destroy() {
        if (this.translator instanceof Lifecycle) {
            ((Lifecycle)this.translator).destroy();
        }
        if (this.supplier instanceof Lifecycle) {
            ((Lifecycle)this.supplier).destroy();
        }
        if (this.interpreter instanceof Lifecycle) {
            ((Lifecycle)this.interpreter).destroy();
        }
        if (this.converter instanceof Lifecycle) {
            ((Lifecycle)this.converter).destroy();
        }
        if (this.serializer instanceof Lifecycle) {
            ((Lifecycle)this.serializer).destroy();
        }
        if (this.conversionProvider instanceof Lifecycle) {
            ((Lifecycle)this.conversionProvider).destroy();
        }
        for (Handler handler : this.handlers.values()) {
            if (!(handler instanceof Lifecycle)) continue;
            ((Lifecycle)handler).destroy();
        }
        for (Exporter exporter : this.exporters.values()) {
            if (!(exporter instanceof Lifecycle)) continue;
            ((Lifecycle)exporter).destroy();
        }
    }
}

