/*
 * Decompiled with CFR 0.152.
 */
package io.httpdoc.web;

import io.httpdoc.core.Config;
import io.httpdoc.core.Lifecycle;
import io.httpdoc.core.exception.HttpdocRuntimeException;
import io.httpdoc.core.kit.LoadKit;
import io.httpdoc.core.serialization.Serializer;
import io.httpdoc.web.HttpdocThreadLocal;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class HttpdocSuffixSerializer
implements Serializer,
Lifecycle {
    private final Map<String, Serializer> map = LoadKit.load((ClassLoader)this.getClass().getClassLoader(), Serializer.class);

    private Serializer get() {
        HttpServletRequest request = HttpdocThreadLocal.getRequest();
        String uri = request.getRequestURI();
        int index = uri.lastIndexOf(".");
        if (index < 0) {
            return this.map.values().iterator().next();
        }
        String suffix = uri.substring(index + 1);
        Serializer serializer = this.map.get(suffix);
        if (serializer == null) {
            throw new HttpdocRuntimeException("unknown serializer named " + suffix);
        }
        return serializer;
    }

    public String getName() {
        return this.get().getName();
    }

    public String getType() {
        return this.get().getType();
    }

    public void serialize(Map<String, Object> doc, OutputStream out) throws IOException {
        this.get().serialize(doc, out);
    }

    public void serialize(Map<String, Object> doc, Writer writer) throws IOException {
        this.get().serialize(doc, writer);
    }

    public void initial(Config config) throws Exception {
        for (Serializer serializer : this.map.values()) {
            if (!(serializer instanceof Lifecycle)) continue;
            ((Lifecycle)serializer).initial(config);
        }
    }

    public void destroy() {
        for (Serializer serializer : this.map.values()) {
            if (!(serializer instanceof Lifecycle)) continue;
            ((Lifecycle)serializer).destroy();
        }
    }
}

