/*
 * Decompiled with CFR 0.152.
 */
package io.httpdoc.web;

import io.httpdoc.core.Config;
import io.httpdoc.core.Document;
import io.httpdoc.core.Lifecycle;
import io.httpdoc.core.exception.DocumentTranslationException;
import io.httpdoc.core.kit.LoadKit;
import io.httpdoc.core.translation.Translation;
import io.httpdoc.core.translation.Translator;
import java.util.Collection;

public class HttpdocMergedTranslator
implements Translator,
Lifecycle {
    private final Collection<Translator> translators = LoadKit.load((ClassLoader)this.getClass().getClassLoader(), Translator.class).values();

    HttpdocMergedTranslator() {
    }

    public Document translate(Translation translation) throws DocumentTranslationException {
        Document document = new Document();
        document.setHttpdoc(translation.getHttpdoc());
        document.setProtocol(translation.getProtocol());
        document.setHostname(translation.getHostname());
        document.setPort(translation.getPort());
        document.setContext(translation.getContext());
        document.setVersion(translation.getVersion());
        document.setDateFormat(translation.getDateFormat());
        document.setDescription(translation.getDescription());
        for (Translator translator : this.translators) {
            Document doc = translator.translate(translation);
            document.getControllers().addAll(doc.getControllers());
            document.getSchemas().putAll(doc.getSchemas());
        }
        return document;
    }

    public String normalize(String path) {
        return null;
    }

    public void initial(Config config) throws Exception {
        for (Translator translator : this.translators) {
            if (!(translator instanceof Lifecycle)) continue;
            ((Lifecycle)translator).initial(config);
        }
    }

    public void destroy() {
        for (Translator translator : this.translators) {
            if (!(translator instanceof Lifecycle)) continue;
            ((Lifecycle)translator).destroy();
        }
    }
}

