/*
 * Decompiled with CFR 0.152.
 */
package io.httpdoc.web;

import io.httpdoc.core.Config;
import io.httpdoc.core.Controller;
import io.httpdoc.core.Document;
import io.httpdoc.core.Lifecycle;
import io.httpdoc.core.Operation;
import io.httpdoc.core.Parameter;
import io.httpdoc.core.Schema;
import io.httpdoc.core.export.Exporter;
import io.httpdoc.core.kit.IOKit;
import io.httpdoc.core.kit.LoadKit;
import io.httpdoc.web.Handler;
import io.httpdoc.web.ZipKit;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpdocExportHandler
implements Handler,
Lifecycle {
    private final String root = System.getProperty("java.io.tmpdir");
    private Map<String, Exporter> exporters = LoadKit.load((ClassLoader)this.getClass().getClassLoader(), Exporter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Document document, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String sdk = request.getParameter("sdk");
        Exporter exporter = this.exporters.get(sdk);
        if (exporter == null) {
            response.sendError(404, "Not Found");
            return;
        }
        UUID random = UUID.randomUUID();
        File folder = new File(this.root, random + File.separator + sdk + "-SDK");
        try {
            if (!folder.exists() && !folder.mkdirs()) {
                throw new IOException("could not make directory: " + folder);
            }
            for (Controller controller : document.getControllers()) {
                for (Operation operation : controller.getOperations()) {
                    for (Parameter parameter : operation.getParameters()) {
                        Schema type = parameter.getType();
                        Collection dependencies = type.getDependencies();
                        for (Schema schema : dependencies) {
                            document.getSchemas().put(schema.getPkg() + "." + schema.getName(), schema);
                        }
                    }
                    Schema type = operation.getResult().getType();
                    Collection dependencies = type.getDependencies();
                    for (Schema schema : dependencies) {
                        document.getSchemas().put(schema.getPkg() + "." + schema.getName(), schema);
                    }
                }
            }
            exporter.export(document, folder.getPath());
            response.setContentType("application/x-zip-compressed");
            response.setHeader("Content-Disposition", "attachment; filename=\"" + URLEncoder.encode(folder.getName() + ".zip", "UTF-8") + "\"");
            ServletOutputStream out = response.getOutputStream();
            ZipKit.pack(folder, (OutputStream)out);
        }
        finally {
            IOKit.delete((File)folder, (boolean)true);
        }
    }

    public void initial(Config config) throws Exception {
        for (Exporter exporter : this.exporters.values()) {
            if (!(exporter instanceof Lifecycle)) continue;
            ((Lifecycle)exporter).initial(config);
        }
    }

    public void destroy() {
        for (Exporter exporter : this.exporters.values()) {
            if (!(exporter instanceof Lifecycle)) continue;
            ((Lifecycle)exporter).destroy();
        }
    }
}

