/*
 * Decompiled with CFR 0.152.
 */
package io.httpdoc.spring.mvc;

import io.httpdoc.core.Controller;
import io.httpdoc.core.Document;
import io.httpdoc.core.Operation;
import io.httpdoc.core.Parameter;
import io.httpdoc.core.Result;
import io.httpdoc.core.Schema;
import io.httpdoc.core.annotation.Alias;
import io.httpdoc.core.annotation.Ignore;
import io.httpdoc.core.annotation.Name;
import io.httpdoc.core.annotation.Order;
import io.httpdoc.core.annotation.Package;
import io.httpdoc.core.annotation.Skip;
import io.httpdoc.core.annotation.Style;
import io.httpdoc.core.annotation.Tag;
import io.httpdoc.core.interpretation.ClassInterpretation;
import io.httpdoc.core.interpretation.Interpreter;
import io.httpdoc.core.interpretation.MethodInterpretation;
import io.httpdoc.core.interpretation.Note;
import io.httpdoc.core.reflection.ParameterizedTypeImpl;
import io.httpdoc.core.supplier.Supplier;
import io.httpdoc.core.translation.Container;
import io.httpdoc.core.translation.Translation;
import io.httpdoc.core.translation.Translator;
import io.httpdoc.spring.mvc.ControllerTranslation;
import io.httpdoc.spring.mvc.OperationTranslation;
import io.httpdoc.spring.mvc.ParameterTranslation;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import org.springframework.context.ApplicationContext;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.ExtendedModelMap;
import org.springframework.ui.Model;
import org.springframework.ui.ModelMap;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.MatrixVariable;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartRequest;
import org.springframework.web.servlet.mvc.condition.MediaTypeExpression;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.UriComponentsBuilder;

public class SpringMVCTranslator
implements Translator {
    protected static final String EMPTY = "";
    protected static final Collection<Class<?>> IGNORED_PARAMETER_TYPES = Arrays.asList(Void.TYPE, Void.class, Class.class, ServletContext.class, ServletRequest.class, ServletResponse.class, HttpServletRequest.class, HttpServletResponse.class, HttpSession.class, HttpHeaders.class, BindingResult.class, UriComponentsBuilder.class, Model.class, ModelMap.class, ExtendedModelMap.class);
    protected static final Collection<Class<?>> PRIMITIVE_TYPES = Arrays.asList(Boolean.TYPE, Byte.TYPE, Short.TYPE, Character.TYPE, Integer.TYPE, Float.TYPE, Long.TYPE, Double.TYPE);
    protected static final Collection<Class<?>> WRAPPER_TYPES = Arrays.asList(Boolean.class, Byte.class, Short.class, Character.class, Integer.class, Float.class, Long.class, Double.class);
    protected static final Collection<Class<?>> NUMBER_TYPES = Arrays.asList(BigInteger.class, BigDecimal.class, AtomicInteger.class, AtomicLong.class);
    protected static final Collection<Class<?>> STRING_TYPES = Arrays.asList(String.class, StringBuilder.class, StringBuffer.class);
    protected static final Collection<Class<?>> DATE_TYPES = Arrays.asList(Date.class, java.sql.Date.class, Time.class, Timestamp.class);
    protected static final Pattern PATTERN = Pattern.compile("\\{([^{}]+?)(:([^{}]+?))?}");
    protected static final ParameterNameDiscoverer DISCOVERER = new DefaultParameterNameDiscoverer();

    protected String getPartName(MethodParameter parameter) {
        String paramName;
        String partName;
        Method method = parameter.getMethod();
        int index = parameter.getParameterIndex();
        String[] names = DISCOVERER.getParameterNames(method);
        String bindName = names[index];
        RequestPart part = (RequestPart)parameter.getParameterAnnotation(RequestPart.class);
        String partValue = part != null ? part.value() : EMPTY;
        String string = partName = part != null ? part.name() : EMPTY;
        bindName = partValue.isEmpty() ? (partName.isEmpty() ? bindName : partName) : partValue;
        RequestParam param = (RequestParam)parameter.getParameterAnnotation(RequestParam.class);
        String paramValue = param != null ? param.value() : EMPTY;
        String string2 = paramName = param != null ? param.name() : EMPTY;
        bindName = paramValue.isEmpty() ? (paramName.isEmpty() ? bindName : paramName) : paramValue;
        return bindName;
    }

    protected Type getReturnType(HandlerMethod handler) {
        ParameterizedType parameterizedType;
        Type rawType;
        Type returnType = handler.getReturnType().getGenericParameterType();
        if (returnType instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)returnType).getRawType()) == ResponseEntity.class) {
            return parameterizedType.getActualTypeArguments()[0];
        }
        return returnType;
    }

    protected boolean isSimpleType(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                return this.isSimpleType(clazz.getComponentType());
            }
            if (clazz.isEnum()) {
                return true;
            }
            if (PRIMITIVE_TYPES.contains(clazz)) {
                return true;
            }
            if (WRAPPER_TYPES.contains(clazz)) {
                return true;
            }
            if (NUMBER_TYPES.contains(clazz)) {
                return true;
            }
            if (STRING_TYPES.contains(clazz)) {
                return true;
            }
            return DATE_TYPES.contains(clazz);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (!(rawType instanceof Class)) {
                return false;
            }
            Class clazz = (Class)rawType;
            if (Collection.class.isAssignableFrom(clazz)) {
                return this.isSimpleType(parameterizedType.getActualTypeArguments()[0]);
            }
            if (Map.class.isAssignableFrom(clazz)) {
                return this.isSimpleType(parameterizedType.getActualTypeArguments()[0]) && this.isSimpleType(parameterizedType.getActualTypeArguments()[1]);
            }
            return false;
        }
        return false;
    }

    protected boolean isMultipartFile(Type type) {
        return type instanceof Class && (MultipartFile.class.isAssignableFrom((Class)type) || Part.class.isAssignableFrom((Class)type));
    }

    protected boolean isMultipartFiles(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz.isArray() && this.isMultipartFile(clazz.getComponentType());
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (!(rawType instanceof Class)) {
                return false;
            }
            Class clazz = (Class)rawType;
            if (!Collection.class.isAssignableFrom(clazz)) {
                return false;
            }
            Type actualTypeArgument = parameterizedType.getActualTypeArguments()[0];
            return this.isMultipartFile(actualTypeArgument);
        }
        return false;
    }

    protected String getBindScope(MethodParameter parameter) {
        if (parameter.hasParameterAnnotation(RequestBody.class)) {
            return "body";
        }
        if (parameter.hasParameterAnnotation(RequestPart.class)) {
            return "body";
        }
        if (parameter.hasParameterAnnotation(PathVariable.class)) {
            return "path";
        }
        if (parameter.hasParameterAnnotation(MatrixVariable.class)) {
            return "matrix";
        }
        if (parameter.hasParameterAnnotation(RequestHeader.class)) {
            return "header";
        }
        if (parameter.hasParameterAnnotation(CookieValue.class)) {
            return "cookie";
        }
        return null;
    }

    protected String getBindName(MethodParameter parameter) {
        Method method = parameter.getMethod();
        int index = parameter.getParameterIndex();
        String[] names = DISCOVERER.getParameterNames(method);
        if (parameter.hasParameterAnnotation(RequestBody.class)) {
            return EMPTY;
        }
        if (parameter.hasParameterAnnotation(RequestPart.class)) {
            return this.getPartName(parameter);
        }
        if (parameter.hasParameterAnnotation(PathVariable.class)) {
            PathVariable variable = (PathVariable)parameter.getParameterAnnotation(PathVariable.class);
            String value = variable.value();
            String name = variable.name();
            return value.isEmpty() ? (name.isEmpty() ? names[index] : name) : value;
        }
        if (parameter.hasParameterAnnotation(MatrixVariable.class)) {
            MatrixVariable variable = (MatrixVariable)parameter.getParameterAnnotation(MatrixVariable.class);
            String value = variable.value();
            String name = variable.name();
            return value.isEmpty() ? (name.isEmpty() ? names[index] : name) : value;
        }
        if (parameter.hasParameterAnnotation(RequestHeader.class)) {
            RequestHeader header = (RequestHeader)parameter.getParameterAnnotation(RequestHeader.class);
            String value = header.value();
            String name = header.name();
            return value.isEmpty() ? (name.isEmpty() ? names[index] : name) : value;
        }
        if (parameter.hasParameterAnnotation(CookieValue.class)) {
            CookieValue cookie = (CookieValue)parameter.getParameterAnnotation(CookieValue.class);
            String value = cookie.value();
            String name = cookie.name();
            return value.isEmpty() ? (name.isEmpty() ? names[index] : name) : value;
        }
        return EMPTY;
    }

    public Document translate(Translation translation) {
        Document document = new Document();
        document.setHttpdoc(translation.getHttpdoc());
        document.setProtocol(translation.getProtocol());
        document.setHostname(translation.getHostname());
        document.setPort(translation.getPort());
        document.setContext(translation.getContext());
        document.setVersion(translation.getVersion());
        document.setDateFormat(translation.getDateFormat());
        document.setDescription(translation.getDescription());
        this.translate(new ControllerTranslation(translation, document));
        return document;
    }

    protected void translate(ControllerTranslation translation) {
        Object mapping2;
        Document document = translation.getDocument();
        LinkedHashMap map = new LinkedHashMap();
        Container container = translation.getContainer();
        Collection applications = container.get(ApplicationContext.class).values();
        for (ApplicationContext application : applications) {
            Collection mappings = application.getBeansOfType(RequestMappingHandlerMapping.class).values();
            for (Object mapping2 : mappings) {
                map.putAll(mapping2.getHandlerMethods());
            }
            Collection infos = application.getBeansOfType(RequestMappingInfoHandlerMapping.class).values();
            mapping2 = infos.iterator();
            while (mapping2.hasNext()) {
                RequestMappingInfoHandlerMapping info = (RequestMappingInfoHandlerMapping)mapping2.next();
                map.putAll(info.getHandlerMethods());
            }
        }
        LinkedHashMap<Class, Controller> controllers = new LinkedHashMap<Class, Controller>();
        Interpreter interpreter = translation.getInterpreter();
        for (Map.Entry entry : map.entrySet()) {
            mapping2 = (RequestMappingInfo)entry.getKey();
            HandlerMethod handler = (HandlerMethod)entry.getValue();
            Class clazz = handler.getBeanType();
            Method method = handler.getMethod();
            ClassInterpretation interpretation = interpreter.interpret(clazz);
            if (interpretation != null && interpretation.isSkip() || (interpretation = interpreter.interpret(method)) != null && interpretation.isSkip() || clazz.isAnnotationPresent(Skip.class) || method.isAnnotationPresent(Skip.class)) continue;
            Controller controller = (Controller)controllers.get(clazz);
            if (controller == null) {
                List tags;
                Integer order;
                String alias;
                String name;
                String pkg;
                ClassInterpretation interpretation2 = interpreter.interpret(clazz);
                controller = new Controller();
                String string = pkg = interpretation2 != null ? interpretation2.getPackage() : null;
                if (StringUtils.hasText((String)pkg)) {
                    controller.setPkg(pkg);
                } else {
                    controller.setPkg(clazz.isAnnotationPresent(Package.class) ? clazz.getAnnotation(Package.class).value() : clazz.getPackage().getName());
                }
                String string2 = name = interpretation2 != null ? interpretation2.getName() : null;
                if (StringUtils.hasText((String)name)) {
                    controller.setName(name);
                } else {
                    controller.setName(clazz.isAnnotationPresent(Name.class) ? clazz.getAnnotation(Name.class).value() : clazz.getSimpleName());
                }
                String string3 = alias = interpretation2 != null ? interpretation2.getAlias() : null;
                if (StringUtils.hasText((String)alias)) {
                    controller.setAlias(alias);
                } else {
                    controller.setAlias(clazz.isAnnotationPresent(Alias.class) ? clazz.getAnnotation(Alias.class).value() : controller.getName());
                }
                controller.setSummary(interpretation2 == null ? null : interpretation2.getSummary());
                controller.setDescription(interpretation2 == null ? null : interpretation2.getContent());
                controller.setDeprecated(interpretation2 != null && interpretation2.getDeprecated() != null ? interpretation2.getDeprecated() : (clazz.isAnnotationPresent(Deprecated.class) ? "deprecated" : null));
                Integer n = order = interpretation2 != null ? interpretation2.getOrder() : null;
                if (order != null) {
                    controller.setOrder(order.intValue());
                } else {
                    controller.setOrder(clazz.isAnnotationPresent(Order.class) ? clazz.getAnnotation(Order.class).value() : Integer.MAX_VALUE);
                }
                List list = tags = interpretation2 != null ? interpretation2.getTags() : null;
                if (tags != null && !tags.isEmpty()) {
                    controller.setTags(tags);
                } else {
                    Tag tag = clazz.getAnnotation(Tag.class);
                    if (tag == null || tag.value().length == 0 || !tag.override()) {
                        controller.getTags().add(controller.getName());
                    }
                    if (tag != null) {
                        controller.getTags().addAll(Arrays.asList(tag.value()));
                    }
                }
                controllers.put(clazz, controller);
            }
            this.translate(new OperationTranslation(translation, (RequestMappingInfo)mapping2, handler, method, controller));
        }
        document.getControllers().addAll(controllers.values());
    }

    protected void translate(OperationTranslation translation) {
        List tags;
        Integer order;
        String name;
        Supplier supplier = translation.getSupplier();
        Interpreter interpreter = translation.getInterpreter();
        RequestMappingInfo mapping = translation.getMapping();
        HandlerMethod handler = translation.getHandler();
        Method method = translation.getMethod();
        Controller controller = translation.getController();
        if (mapping.getPatternsCondition().getPatterns().isEmpty()) {
            return;
        }
        String expression = (String)mapping.getPatternsCondition().getPatterns().iterator().next();
        MethodInterpretation interpretation = interpreter.interpret(method);
        Operation operation = new Operation();
        String string = name = interpretation != null ? interpretation.getName() : null;
        if (StringUtils.hasText((String)name)) {
            operation.setName(name);
        } else {
            operation.setName(method.isAnnotationPresent(Name.class) ? method.getAnnotation(Name.class).value() : method.getName());
        }
        operation.setPath(this.normalize(expression));
        Set produces = mapping.getProducesCondition().getExpressions();
        for (Object produce : produces) {
            operation.getProduces().add(produce.getMediaType().toString());
        }
        Set consumes = mapping.getConsumesCondition().getExpressions();
        for (MediaTypeExpression consume : consumes) {
            operation.getConsumes().add(consume.getMediaType().toString());
        }
        Set methods = mapping.getMethodsCondition().getMethods();
        operation.setMethod(methods.isEmpty() ? RequestMethod.POST.name() : ((RequestMethod)methods.iterator().next()).name());
        operation.setSummary(interpretation == null ? null : interpretation.getSummary());
        operation.setDescription(interpretation == null ? null : interpretation.getContent());
        operation.setDeprecated(interpretation != null && interpretation.getDeprecated() != null ? interpretation.getDeprecated() : (method.isAnnotationPresent(Deprecated.class) ? "deprecated" : null));
        Integer n = order = interpretation != null ? interpretation.getOrder() : null;
        if (order != null) {
            operation.setOrder(order.intValue());
        } else {
            operation.setOrder(method.isAnnotationPresent(Order.class) ? method.getAnnotation(Order.class).value() : Integer.MAX_VALUE);
        }
        List list = tags = interpretation != null ? interpretation.getTags() : null;
        if (tags != null && !tags.isEmpty()) {
            operation.setTags(tags);
        } else {
            Tag tag = method.getAnnotation(Tag.class);
            if (tag == null || tag.value().length == 0 || !tag.override()) {
                operation.getTags().addAll(controller.getTags());
            }
            if (tag != null) {
                operation.getTags().addAll(Arrays.asList(tag.value()));
            }
        }
        Result result = new Result();
        Type resultType = this.getReturnType(handler);
        Schema schema = Schema.valueOf((Type)resultType, (Supplier)supplier, (Interpreter)interpreter);
        result.setType(schema);
        result.setDescription(interpretation != null && interpretation.getReturnNote() != null ? interpretation.getReturnNote().getText() : null);
        operation.setResult(result);
        this.translate(new ParameterTranslation(translation, mapping, handler, method, controller, operation));
        controller.getOperations().add(operation);
    }

    protected void translate(ParameterTranslation translation) {
        Supplier supplier = translation.getSupplier();
        Interpreter interpreter = translation.getInterpreter();
        HandlerMethod handler = translation.getHandler();
        Method method = translation.getMethod();
        Operation operation = translation.getOperation();
        HashMap<String, String> descriptions = new HashMap<String, String>();
        MethodInterpretation interpretation = interpreter.interpret(method);
        Note[] notes = interpretation != null ? interpretation.getParamNotes() : null;
        for (int i = 0; notes != null && i < notes.length; ++i) {
            descriptions.put(notes[i].getName(), notes[i].getText());
        }
        String[] names = DISCOVERER.getParameterNames(method);
        List ignores = interpretation != null ? interpretation.getIgnores() : Collections.emptyList();
        Map aliases = interpretation != null ? interpretation.getAliases() : Collections.emptyMap();
        Map styles = interpretation != null ? interpretation.getStyles() : Collections.emptyMap();
        MethodParameter[] params = handler.getMethodParameters();
        for (int i = 0; i < params.length; ++i) {
            String paramName;
            Type paramType;
            MethodParameter param = params[i];
            if (ignores.contains(names[i]) || param.hasParameterAnnotation(Ignore.class) || (paramType = param.getGenericParameterType()) instanceof Class && IGNORED_PARAMETER_TYPES.contains(paramType)) continue;
            int bodies = 0;
            Parameter parameter = new Parameter();
            String name = this.getBindName(param);
            parameter.setName(name);
            if (StringUtils.hasText((String)((String)aliases.get(names[i])))) {
                parameter.setAlias(((String)aliases.get(names[i])).trim());
            } else {
                parameter.setAlias(param.hasParameterAnnotation(Alias.class) ? ((Alias)param.getParameterAnnotation(Alias.class)).value() : parameter.getName());
            }
            if (StringUtils.hasText((String)((String)styles.get(names[i])))) {
                parameter.setStyle(((String)styles.get(names[i])).trim());
            } else {
                parameter.setStyle(param.hasParameterAnnotation(Style.class) ? ((Style)param.getParameterAnnotation(Style.class)).value() : null);
            }
            String scope = this.getBindScope(param);
            bodies += "body".equals(scope) ? 1 : 0;
            parameter.setScope(scope);
            String path = param.hasParameterAnnotation(MatrixVariable.class) ? ((MatrixVariable)param.getParameterAnnotation(MatrixVariable.class)).pathVar() : null;
            parameter.setPath(path == null || path.equals("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n") ? null : path);
            parameter.setDescription((String)descriptions.get(names[i]));
            boolean upload = false;
            if (paramType instanceof Class && MultipartRequest.class.isAssignableFrom((Class)paramType)) {
                parameter.setScope("body");
                parameter.setType(Schema.valueOf((Type)new ParameterizedTypeImpl(Map.class, null, new Type[]{String.class, File.class})));
                upload = true;
            } else if (this.isMultipartFile(paramType)) {
                parameter.setScope("body");
                parameter.setType(Schema.valueOf(File.class));
                paramName = this.getPartName(param);
                parameter.setName(paramName);
                if (StringUtils.hasText((String)((String)aliases.get(names[i])))) {
                    parameter.setAlias(((String)aliases.get(names[i])).trim());
                } else {
                    parameter.setAlias(param.hasParameterAnnotation(Alias.class) ? ((Alias)param.getParameterAnnotation(Alias.class)).value() : parameter.getName());
                }
                upload = true;
            } else if (this.isMultipartFiles(paramType)) {
                parameter.setScope("body");
                parameter.setType(Schema.valueOf(File[].class));
                paramName = this.getPartName(param);
                parameter.setName(paramName);
                if (StringUtils.hasText((String)((String)aliases.get(names[i])))) {
                    parameter.setAlias(((String)aliases.get(names[i])).trim());
                } else {
                    parameter.setAlias(param.hasParameterAnnotation(Alias.class) ? ((Alias)param.getParameterAnnotation(Alias.class)).value() : parameter.getName());
                }
                upload = true;
            } else if (scope == null) {
                String annoName;
                parameter.setScope("query");
                parameter.setType(Schema.valueOf((Type)paramType, (Supplier)supplier, (Interpreter)interpreter));
                RequestParam annotation = (RequestParam)param.getParameterAnnotation(RequestParam.class);
                String annoValue = annotation != null ? annotation.value() : EMPTY;
                String string = annoName = annotation != null ? annotation.name() : EMPTY;
                if (!annoValue.isEmpty() || !annoName.isEmpty()) {
                    parameter.setName(annoValue.isEmpty() ? annoName : annoValue);
                    if (StringUtils.hasText((String)((String)aliases.get(names[i])))) {
                        parameter.setAlias(((String)aliases.get(names[i])).trim());
                    } else {
                        parameter.setAlias(param.hasParameterAnnotation(Alias.class) ? ((Alias)param.getParameterAnnotation(Alias.class)).value() : parameter.getName());
                    }
                } else if (this.isSimpleType(paramType)) {
                    int index = param.getParameterIndex();
                    parameter.setName(names[index]);
                    if (StringUtils.hasText((String)((String)aliases.get(names[i])))) {
                        parameter.setAlias(((String)aliases.get(names[i])).trim());
                    } else {
                        parameter.setAlias(param.hasParameterAnnotation(Alias.class) ? ((Alias)param.getParameterAnnotation(Alias.class)).value() : parameter.getName());
                    }
                } else {
                    parameter.setName(EMPTY);
                    if (StringUtils.hasText((String)((String)aliases.get(names[i])))) {
                        parameter.setAlias(((String)aliases.get(names[i])).trim());
                    } else {
                        parameter.setAlias(param.hasParameterAnnotation(Alias.class) ? ((Alias)param.getParameterAnnotation(Alias.class)).value() : parameter.getName());
                    }
                }
            } else {
                parameter.setType(Schema.valueOf((Type)paramType, (Supplier)supplier, (Interpreter)interpreter));
            }
            operation.setMultipart(bodies > 1 || upload);
            operation.getParameters().add(parameter);
        }
    }

    public String normalize(String path) {
        Matcher matcher = PATTERN.matcher(path);
        while (matcher.find()) {
            String name = matcher.group(1);
            path = path.replace(matcher.group(), "{" + name + "}");
        }
        return path;
    }
}

