/*
 * Decompiled with CFR 0.152.
 */
package io.httpdoc.spring.mvc;

import io.httpdoc.core.Document;
import io.httpdoc.core.conversion.Converter;
import io.httpdoc.core.conversion.DefaultFormat;
import io.httpdoc.core.conversion.Format;
import io.httpdoc.core.conversion.StandardConverter;
import io.httpdoc.core.exception.DocumentTranslationException;
import io.httpdoc.core.interpretation.DefaultInterpreter;
import io.httpdoc.core.interpretation.Interpreter;
import io.httpdoc.core.kit.LoadKit;
import io.httpdoc.core.serialization.Serializer;
import io.httpdoc.core.supplier.Supplier;
import io.httpdoc.core.supplier.SystemSupplier;
import io.httpdoc.core.translation.Container;
import io.httpdoc.core.translation.Translation;
import io.httpdoc.core.translation.Translator;
import io.httpdoc.spring.mvc.Module;
import io.httpdoc.spring.mvc.SpringMVCHttpdocContainer;
import io.httpdoc.spring.mvc.SpringMVCTranslator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@RequestMapping(value={"/spring-mvc"})
public class SpringMVCHttpdocController {
    private String httpdoc;
    private String protocol;
    private String hostname;
    private Integer port;
    private String context;
    private String version;
    private Translator translator = new SpringMVCTranslator();
    private Supplier supplier = new SystemSupplier();
    private Interpreter interpreter = new DefaultInterpreter();
    private Converter converter = new StandardConverter();
    private Map<String, Serializer> serializers = LoadKit.load((ClassLoader)this.getClass().getClassLoader(), Serializer.class);
    private Format format = new DefaultFormat();

    @RequestMapping(value={"/httpdoc"})
    public void render(@RequestParam(value="charset", required=false) String charset, @RequestParam(value="contentType", required=false) String contentType, HttpServletRequest req, HttpServletResponse res) throws IOException, DocumentTranslationException {
        Serializer serializer;
        String uri = req.getRequestURI();
        int index = uri.indexOf(46);
        String suffix = index < 0 ? null : uri.substring(index + 1);
        Serializer serializer2 = serializer = suffix != null ? this.serializers.get(suffix) : this.serializers.values().iterator().next();
        if (serializer == null) {
            res.sendError(404);
            return;
        }
        SpringMVCHttpdocContainer container = new SpringMVCHttpdocContainer(req.getServletContext());
        Translation translation = new Translation((Container)container, this.supplier, this.interpreter);
        translation.setHttpdoc(this.httpdoc != null ? this.httpdoc : Module.getInstance().getVersion());
        translation.setProtocol(this.protocol != null ? this.protocol : req.getProtocol().split("/")[0].toLowerCase());
        translation.setHostname(this.hostname != null ? this.hostname : req.getServerName());
        translation.setPort(Integer.valueOf(this.port != null ? this.port.intValue() : req.getServerPort()));
        translation.setContext(this.context != null ? this.context : req.getContextPath());
        translation.setVersion(this.version);
        Document document = this.translator.translate(translation);
        charset = charset != null && charset.trim().length() > 0 ? charset : "UTF-8";
        contentType = contentType != null && charset.trim().length() > 0 ? contentType : serializer.getType();
        res.setCharacterEncoding(charset);
        res.setContentType(contentType + "; charset=" + charset);
        Map doc = this.converter.convert(document, this.format);
        serializer.serialize(doc, (OutputStream)res.getOutputStream());
    }

    public String getHttpdoc() {
        return this.httpdoc;
    }

    public void setHttpdoc(String httpdoc) {
        this.httpdoc = httpdoc;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Translator getTranslator() {
        return this.translator;
    }

    public void setTranslator(Translator translator) {
        this.translator = translator;
    }

    public Supplier getSupplier() {
        return this.supplier;
    }

    public void setSupplier(Supplier supplier) {
        this.supplier = supplier;
    }

    public Interpreter getInterpreter() {
        return this.interpreter;
    }

    public void setInterpreter(Interpreter interpreter) {
        this.interpreter = interpreter;
    }

    public Converter getConverter() {
        return this.converter;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public Map<String, Serializer> getSerializers() {
        return this.serializers;
    }

    public void setSerializers(Map<String, Serializer> serializers) {
        this.serializers = serializers;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }
}

