/*
 * Decompiled with CFR 0.152.
 */
package io.httpdoc.spring.boot;

import io.httpdoc.spring.boot.EnableHttpdoc;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.DispatcherType;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.StringUtils;

public class HttpdocFilterRegistrar
implements ImportBeanDefinitionRegistrar {
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes[] params;
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(EnableHttpdoc.class.getName()));
        RootBeanDefinition httpdoc = new RootBeanDefinition(FilterRegistrationBean.class);
        String name = attributes.getString("name");
        httpdoc.getPropertyValues().add("name", (Object)name);
        boolean asyncSupported = attributes.getBoolean("asyncSupported");
        httpdoc.getPropertyValues().add("asyncSupported", (Object)asyncSupported);
        DispatcherType[] dispatcherTypes = (DispatcherType[])attributes.get((Object)"dispatcherTypes");
        httpdoc.getPropertyValues().add("dispatcherTypes", EnumSet.of(dispatcherTypes[0], dispatcherTypes));
        boolean matchAfter = attributes.getBoolean("matchAfter");
        httpdoc.getPropertyValues().add("matchAfter", (Object)matchAfter);
        boolean enabled = attributes.getBoolean("enabled");
        httpdoc.getPropertyValues().add("enabled", (Object)enabled);
        int order = (Integer)attributes.getNumber("order");
        httpdoc.getPropertyValues().add("order", (Object)order);
        String[] patterns = attributes.getStringArray("value");
        httpdoc.getPropertyValues().add("urlPatterns", Arrays.asList(patterns));
        Class filter = attributes.getClass("filter");
        httpdoc.getPropertyValues().add("filter", this.newInstance(filter));
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        for (AnnotationAttributes param : params = attributes.getAnnotationArray("params")) {
            parameters.put(param.getString("name"), param.getString("value"));
        }
        parameters.put("packages", this.concat(attributes.getStringArray("packages")));
        parameters.put("httpdoc", attributes.getString("httpdoc"));
        parameters.put("protocol", attributes.getString("protocol"));
        parameters.put("hostname", attributes.getString("hostname"));
        parameters.put("port", attributes.getNumber("port").toString());
        parameters.put("context", attributes.getString("context"));
        parameters.put("version", attributes.getString("version"));
        parameters.put("dateFormat", attributes.getString("dateFormat"));
        parameters.put("description", attributes.getString("description"));
        parameters.put("charset", attributes.getString("charset"));
        parameters.put("contentType", attributes.getString("contentType"));
        parameters.put("translator", attributes.getClass("translator").getName());
        parameters.put("supplier", attributes.getClass("supplier").getName());
        parameters.put("interpreter", attributes.getClass("interpreter").getName());
        parameters.put("converter", attributes.getClass("converter").getName());
        parameters.put("serializer", attributes.getClass("serializer").getName());
        parameters.put("conversionProvider", attributes.getClass("conversionProvider").getName());
        httpdoc.getPropertyValues().add("initParameters", parameters);
        String beanName = attributes.getString("bean");
        registry.registerBeanDefinition(beanName, (BeanDefinition)httpdoc);
    }

    private <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String concat(String ... values) {
        StringBuilder builder = new StringBuilder();
        for (String value : values) {
            if (!StringUtils.hasText((String)value)) continue;
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(value);
        }
        return builder.toString();
    }
}

