/*
 * Decompiled with CFR 0.152.
 */
package io.httpdoc.jackson.serialization;

import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.httpdoc.core.serialization.Serializer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;

public class YamlSerializer
implements Serializer {
    private final YAMLMapper mapper;

    public YamlSerializer() {
        this(new YAMLFactory());
    }

    public YamlSerializer(YAMLFactory factory) {
        this(new YAMLMapper(factory));
        this.mapper.configure(YAMLGenerator.Feature.WRITE_DOC_START_MARKER, false);
        this.mapper.configure(YAMLGenerator.Feature.MINIMIZE_QUOTES, false);
    }

    public YamlSerializer(YAMLMapper mapper) {
        this.mapper = mapper;
    }

    public String getName() {
        return "yaml";
    }

    public String getType() {
        return "application/yaml";
    }

    public void serialize(Map<String, Object> doc, OutputStream out) throws IOException {
        this.mapper.writeValue(out, doc);
    }

    public void serialize(Map<String, Object> doc, Writer writer) throws IOException {
        this.mapper.writeValue(writer, doc);
    }
}

