/*
 * Decompiled with CFR 0.152.
 */
package io.httpdoc.jackson.serialization;

import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import io.httpdoc.core.serialization.Serializer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;

public class XmlSerializer
implements Serializer {
    private final XmlMapper mapper;

    public XmlSerializer() {
        this(new XmlFactory());
    }

    public XmlSerializer(XmlFactory factory) {
        this(new XmlMapper(factory));
    }

    public XmlSerializer(XmlMapper mapper) {
        this.mapper = mapper;
    }

    public String getName() {
        return "xml";
    }

    public String getType() {
        return "application/xml";
    }

    public void serialize(Map<String, Object> doc, OutputStream out) throws IOException {
        this.mapper.writeValue(out, doc);
    }

    public void serialize(Map<String, Object> doc, Writer writer) throws IOException {
        this.mapper.writeValue(writer, doc);
    }
}

