/*
 * Decompiled with CFR 0.152.
 */
package io.httpdoc.jackson.serialization;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.httpdoc.core.serialization.Serializer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;

public class JsonSerializer
implements Serializer {
    private final ObjectMapper mapper;

    public JsonSerializer() {
        this(new JsonFactory());
    }

    public JsonSerializer(JsonFactory factory) {
        this(new ObjectMapper(factory));
    }

    public JsonSerializer(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public String getName() {
        return "json";
    }

    public String getType() {
        return "application/json";
    }

    public void serialize(Map<String, Object> doc, OutputStream out) throws IOException {
        this.mapper.writeValue(out, doc);
    }

    public void serialize(Map<String, Object> doc, Writer writer) throws IOException {
        this.mapper.writeValue(writer, doc);
    }
}

