/*
 * Decompiled with CFR 0.152.
 */
package io.httpdoc.jackson.deserialization;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.httpdoc.core.deserialization.Deserializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;

public class JsonDeserializer
implements Deserializer {
    private final ObjectMapper mapper;

    public JsonDeserializer() {
        this(new JsonFactory());
    }

    public JsonDeserializer(JsonFactory factory) {
        this(new ObjectMapper(factory));
    }

    public JsonDeserializer(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public Map<String, Object> deserialize(InputStream in) throws IOException {
        return (Map)this.mapper.readValue(in, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public Map<String, Object> deserialize(Reader reader) throws IOException {
        return (Map)this.mapper.readValue(reader, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }
}

