/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.spi;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class Completion
implements Iterable<Map.Entry<String, Boolean>>,
Serializable {
    private static final Completion EMPTY = Completion.create("");
    private final String prefix;
    private final Map<String, Boolean> values;

    public static Builder builder(String prefix) {
        return new Builder(prefix);
    }

    public static Completion create() {
        return EMPTY;
    }

    public static Completion create(String prefix) {
        return Completion.create(prefix, Collections.emptyMap());
    }

    public static Completion create(String prefix, String suffix, boolean value) {
        return Completion.create(prefix, Collections.singletonMap(suffix, value));
    }

    public static Completion create(String suffix, boolean value) {
        return Completion.create("", suffix, value);
    }

    public static Completion create(String prefix, Map<String, Boolean> suffixes) {
        return new Completion(prefix, suffixes);
    }

    private Completion(String prefix, Map<String, Boolean> values) {
        if (prefix == null) {
            throw new NullPointerException("No null prefix allowed");
        }
        if (values == null) {
            throw new NullPointerException("No null suffixes allowed");
        }
        this.prefix = prefix;
        this.values = values;
    }

    @Override
    public Iterator<Map.Entry<String, Boolean>> iterator() {
        return this.values.entrySet().iterator();
    }

    public Set<String> getValues() {
        return this.values.keySet();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public Boolean get(String key) {
        return this.values.get(key);
    }

    public int getSize() {
        return this.values.size();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int hashCode() {
        return this.prefix.hashCode() ^ this.values.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Completion) {
            Completion that = (Completion)obj;
            return this.prefix.equals(that.prefix) && this.values.equals(that.values);
        }
        return false;
    }

    public String toString() {
        return "Completion[prefix=" + this.prefix + ",entries=" + this.values + "]";
    }

    public static class Builder {
        private String prefix;
        private Map<String, Boolean> entries;

        public Builder(String prefix) {
            this.prefix = prefix;
            this.entries = null;
        }

        public Builder add(String key, boolean value) {
            if (this.entries == null) {
                this.entries = new LinkedHashMap<String, Boolean>();
            }
            this.entries.put(key, value);
            return this;
        }

        public Completion build() {
            return Completion.create(this.prefix, this.entries != null ? this.entries : Collections.emptyMap());
        }
    }
}

