/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.lang;

import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import org.crsh.cli.descriptor.CommandDescriptor;
import org.crsh.cli.descriptor.Description;
import org.crsh.cli.descriptor.OptionDescriptor;
import org.crsh.cli.descriptor.ParameterDescriptor;
import org.crsh.cli.impl.SyntaxException;
import org.crsh.cli.impl.descriptor.IntrospectionException;
import org.crsh.cli.impl.invocation.InvocationException;
import org.crsh.cli.impl.invocation.InvocationMatch;
import org.crsh.cli.impl.lang.Instance;
import org.crsh.cli.impl.lang.MethodDescriptor;
import org.crsh.cli.impl.lang.ObjectCommandDescriptor;
import org.crsh.cli.impl.lang.ObjectCommandInvoker;
import org.crsh.cli.impl.lang.Util;

class ClassDescriptor<T>
extends ObjectCommandDescriptor<T> {
    private final Class<T> type;
    private final Map<String, MethodDescriptor<T>> methods;

    ClassDescriptor(Class<T> type, String name, Map<String, MethodDescriptor<T>> methods, Description info) throws IntrospectionException {
        super(name, info);
        this.methods = methods;
        this.type = type;
    }

    @Override
    protected void addParameter(ParameterDescriptor parameter) throws IntrospectionException {
        if (parameter instanceof OptionDescriptor) {
            OptionDescriptor option = (OptionDescriptor)parameter;
            HashSet<String> blah = new HashSet<String>();
            for (String string : option.getNames()) {
                blah.add((string.length() == 1 ? "-" : "--") + string);
            }
            for (MethodDescriptor methodDescriptor : this.methods.values()) {
                HashSet<String> diff = new HashSet<String>(methodDescriptor.getOptionNames());
                diff.retainAll(blah);
                if (diff.size() <= 0) continue;
                throw new IntrospectionException("Cannot add method " + methodDescriptor.getName() + " because it has common  options with its class: " + diff);
            }
        }
        super.addParameter(parameter);
    }

    @Override
    public ObjectCommandInvoker<T, ?> getInvoker(final InvocationMatch<Instance<T>> match) {
        if (Runnable.class.isAssignableFrom(this.type)) {
            return new ObjectCommandInvoker<T, Void>(match){

                @Override
                public Class<Void> getReturnType() {
                    return Void.class;
                }

                @Override
                public Type getGenericReturnType() {
                    return Void.class;
                }

                @Override
                public Class<?>[] getParameterTypes() {
                    return new Class[0];
                }

                @Override
                public Type[] getGenericParameterTypes() {
                    return new Type[0];
                }

                @Override
                public Void invoke(Instance<T> commandInstance) throws InvocationException, SyntaxException {
                    Object command;
                    try {
                        command = commandInstance.get();
                    }
                    catch (Exception e) {
                        throw new InvocationException(e);
                    }
                    MethodDescriptor.bind(match, ClassDescriptor.this.getParameters(), command, Util.EMPTY_ARGS);
                    Runnable runnable = (Runnable)Runnable.class.cast(command);
                    try {
                        runnable.run();
                    }
                    catch (Exception e) {
                        throw new InvocationException(e);
                    }
                    return null;
                }
            };
        }
        return null;
    }

    @Override
    public CommandDescriptor<Instance<T>> getOwner() {
        return null;
    }

    @Override
    public Map<String, ? extends MethodDescriptor<T>> getSubordinates() {
        return this.methods;
    }
}

